/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.cf;

import ai2.org.apache.poi.ss.formula.Formula;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormattingThreshold;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;
import java.util.Arrays;

public abstract class Threshold {
    private byte type;
    private Formula formula;
    private Double value;

    protected Threshold() {
        this.type = (byte)ConditionalFormattingThreshold.RangeType.NUMBER.id;
        this.formula = Formula.create(null);
        this.value = 0.0;
    }

    protected Threshold(LittleEndianInput littleEndianInput) {
        this.type = littleEndianInput.readByte();
        short s = littleEndianInput.readShort();
        this.formula = s > 0 ? Formula.read(s, littleEndianInput) : Formula.create(null);
        if (s == 0 && this.type != ConditionalFormattingThreshold.RangeType.MIN.id && this.type != ConditionalFormattingThreshold.RangeType.MAX.id) {
            this.value = littleEndianInput.readDouble();
        }
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte by) {
        this.type = by;
        if (by == ConditionalFormattingThreshold.RangeType.MIN.id || by == ConditionalFormattingThreshold.RangeType.MAX.id || by == ConditionalFormattingThreshold.RangeType.FORMULA.id) {
            this.value = null;
        } else if (this.value == null) {
            this.value = 0.0;
        }
    }

    public void setType(int n) {
        this.type = (byte)n;
    }

    protected Formula getFormula() {
        return this.formula;
    }

    public Ptg[] getParsedExpression() {
        return this.formula.getTokens();
    }

    public void setParsedExpression(Ptg[] ptgArray) {
        this.formula = Formula.create(ptgArray);
        if (ptgArray.length > 0) {
            this.value = null;
        }
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double d) {
        this.value = d;
    }

    public int getDataLength() {
        int n = 1 + this.formula.getEncodedSize();
        if (this.value != null) {
            n += 8;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    [CF Threshold]\n");
        stringBuffer.append("          .type    = ").append(Integer.toHexString(this.type)).append("\n");
        stringBuffer.append("          .formula = ").append(Arrays.toString(this.formula.getTokens())).append("\n");
        stringBuffer.append("          .value   = ").append(this.value).append("\n");
        stringBuffer.append("    [/CF Threshold]\n");
        return stringBuffer.toString();
    }

    public void copyTo(Threshold threshold) {
        threshold.type = this.type;
        threshold.formula = this.formula;
        threshold.value = this.value;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(this.type);
        if (this.formula.getTokens().length == 0) {
            littleEndianOutput.writeShort(0);
        } else {
            this.formula.serialize(littleEndianOutput);
        }
        if (this.value != null) {
            littleEndianOutput.writeDouble(this.value);
        }
    }
}

