/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.cf;

import ai2.org.apache.poi.hssf.record.cf.IconMultiStateThreshold;
import ai2.org.apache.poi.hssf.record.cf.Threshold;
import ai2.org.apache.poi.ss.usermodel.IconMultiStateFormatting;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;

public final class IconMultiStateFormatting
implements Cloneable {
    private static POILogger log = POILogFactory.getLogger(IconMultiStateFormatting.class);
    private IconMultiStateFormatting.IconSet iconSet;
    private byte options;
    private Threshold[] thresholds;
    private static BitField iconOnly = BitFieldFactory.getInstance(1);
    private static BitField reversed = BitFieldFactory.getInstance(4);

    public IconMultiStateFormatting() {
        this.iconSet = IconMultiStateFormatting.IconSet.GYR_3_TRAFFIC_LIGHTS;
        this.options = 0;
        this.thresholds = new Threshold[this.iconSet.num];
    }

    public IconMultiStateFormatting(LittleEndianInput littleEndianInput) {
        littleEndianInput.readShort();
        littleEndianInput.readByte();
        byte by = littleEndianInput.readByte();
        byte by2 = littleEndianInput.readByte();
        this.iconSet = IconMultiStateFormatting.IconSet.byId(by2);
        if (this.iconSet.num != by) {
            log.log(5, new Object[]{"Inconsistent Icon Set defintion, found " + (Object)((Object)this.iconSet) + " but defined as " + by + " entries"});
        }
        this.options = littleEndianInput.readByte();
        this.thresholds = new Threshold[this.iconSet.num];
        for (int i = 0; i < this.thresholds.length; ++i) {
            this.thresholds[i] = new IconMultiStateThreshold(littleEndianInput);
        }
    }

    public IconMultiStateFormatting.IconSet getIconSet() {
        return this.iconSet;
    }

    public void setIconSet(IconMultiStateFormatting.IconSet iconSet) {
        this.iconSet = iconSet;
    }

    public Threshold[] getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(Threshold[] thresholdArray) {
        this.thresholds = thresholdArray;
    }

    public boolean isIconOnly() {
        return this.getOptionFlag(iconOnly);
    }

    public void setIconOnly(boolean bl) {
        this.setOptionFlag(bl, iconOnly);
    }

    public boolean isReversed() {
        return this.getOptionFlag(reversed);
    }

    public void setReversed(boolean bl) {
        this.setOptionFlag(bl, reversed);
    }

    private boolean getOptionFlag(BitField bitField) {
        int n = bitField.getValue(this.options);
        return n != 0;
    }

    private void setOptionFlag(boolean bl, BitField bitField) {
        this.options = bitField.setByteBoolean(this.options, bl);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    [Icon Formatting]\n");
        stringBuffer.append("          .icon_set = ").append((Object)this.iconSet).append("\n");
        stringBuffer.append("          .icon_only= ").append(this.isIconOnly()).append("\n");
        stringBuffer.append("          .reversed = ").append(this.isReversed()).append("\n");
        for (Threshold threshold : this.thresholds) {
            stringBuffer.append(threshold.toString());
        }
        stringBuffer.append("    [/Icon Formatting]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        IconMultiStateFormatting iconMultiStateFormatting = new IconMultiStateFormatting();
        iconMultiStateFormatting.iconSet = this.iconSet;
        iconMultiStateFormatting.options = this.options;
        iconMultiStateFormatting.thresholds = new Threshold[this.thresholds.length];
        System.arraycopy(this.thresholds, 0, iconMultiStateFormatting.thresholds, 0, this.thresholds.length);
        return iconMultiStateFormatting;
    }

    public int getDataLength() {
        int n = 6;
        for (Threshold threshold : this.thresholds) {
            n += threshold.getDataLength();
        }
        return n;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(0);
        littleEndianOutput.writeByte(0);
        littleEndianOutput.writeByte(this.iconSet.num);
        littleEndianOutput.writeByte(this.iconSet.id);
        littleEndianOutput.writeByte(this.options);
        for (Threshold threshold : this.thresholds) {
            threshold.serialize(littleEndianOutput);
        }
    }
}

