/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.cf;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class BorderFormatting {
    public static final short BORDER_NONE = 0;
    public static final short BORDER_THIN = 1;
    public static final short BORDER_MEDIUM = 2;
    public static final short BORDER_DASHED = 3;
    public static final short BORDER_HAIR = 4;
    public static final short BORDER_THICK = 5;
    public static final short BORDER_DOUBLE = 6;
    public static final short BORDER_DOTTED = 7;
    public static final short BORDER_MEDIUM_DASHED = 8;
    public static final short BORDER_DASH_DOT = 9;
    public static final short BORDER_MEDIUM_DASH_DOT = 10;
    public static final short BORDER_DASH_DOT_DOT = 11;
    public static final short BORDER_MEDIUM_DASH_DOT_DOT = 12;
    public static final short BORDER_SLANTED_DASH_DOT = 13;
    private int field_13_border_styles1;
    private static final BitField bordLeftLineStyle = BitFieldFactory.getInstance(15);
    private static final BitField bordRightLineStyle = BitFieldFactory.getInstance(240);
    private static final BitField bordTopLineStyle = BitFieldFactory.getInstance(3840);
    private static final BitField bordBottomLineStyle = BitFieldFactory.getInstance(61440);
    private static final BitField bordLeftLineColor = BitFieldFactory.getInstance(0x7F0000);
    private static final BitField bordRightLineColor = BitFieldFactory.getInstance(1065353216);
    private static final BitField bordTlBrLineOnOff = BitFieldFactory.getInstance(0x40000000);
    private static final BitField bordBlTrtLineOnOff = BitFieldFactory.getInstance(Integer.MIN_VALUE);
    private int field_14_border_styles2;
    private static final BitField bordTopLineColor = BitFieldFactory.getInstance(127);
    private static final BitField bordBottomLineColor = BitFieldFactory.getInstance(16256);
    private static final BitField bordDiagLineColor = BitFieldFactory.getInstance(2080768);
    private static final BitField bordDiagLineStyle = BitFieldFactory.getInstance(0x1E00000);

    public BorderFormatting() {
        this.field_13_border_styles1 = 0;
        this.field_14_border_styles2 = 0;
    }

    public BorderFormatting(LittleEndianInput littleEndianInput) {
        this.field_13_border_styles1 = littleEndianInput.readInt();
        this.field_14_border_styles2 = littleEndianInput.readInt();
    }

    public int getDataLength() {
        return 8;
    }

    public void setBorderLeft(int n) {
        this.field_13_border_styles1 = bordLeftLineStyle.setValue(this.field_13_border_styles1, n);
    }

    public int getBorderLeft() {
        return bordLeftLineStyle.getValue(this.field_13_border_styles1);
    }

    public void setBorderRight(int n) {
        this.field_13_border_styles1 = bordRightLineStyle.setValue(this.field_13_border_styles1, n);
    }

    public int getBorderRight() {
        return bordRightLineStyle.getValue(this.field_13_border_styles1);
    }

    public void setBorderTop(int n) {
        this.field_13_border_styles1 = bordTopLineStyle.setValue(this.field_13_border_styles1, n);
    }

    public int getBorderTop() {
        return bordTopLineStyle.getValue(this.field_13_border_styles1);
    }

    public void setBorderBottom(int n) {
        this.field_13_border_styles1 = bordBottomLineStyle.setValue(this.field_13_border_styles1, n);
    }

    public int getBorderBottom() {
        return bordBottomLineStyle.getValue(this.field_13_border_styles1);
    }

    public void setBorderDiagonal(int n) {
        this.field_14_border_styles2 = bordDiagLineStyle.setValue(this.field_14_border_styles2, n);
    }

    public int getBorderDiagonal() {
        return bordDiagLineStyle.getValue(this.field_14_border_styles2);
    }

    public void setLeftBorderColor(int n) {
        this.field_13_border_styles1 = bordLeftLineColor.setValue(this.field_13_border_styles1, n);
    }

    public int getLeftBorderColor() {
        return bordLeftLineColor.getValue(this.field_13_border_styles1);
    }

    public void setRightBorderColor(int n) {
        this.field_13_border_styles1 = bordRightLineColor.setValue(this.field_13_border_styles1, n);
    }

    public int getRightBorderColor() {
        return bordRightLineColor.getValue(this.field_13_border_styles1);
    }

    public void setTopBorderColor(int n) {
        this.field_14_border_styles2 = bordTopLineColor.setValue(this.field_14_border_styles2, n);
    }

    public int getTopBorderColor() {
        return bordTopLineColor.getValue(this.field_14_border_styles2);
    }

    public void setBottomBorderColor(int n) {
        this.field_14_border_styles2 = bordBottomLineColor.setValue(this.field_14_border_styles2, n);
    }

    public int getBottomBorderColor() {
        return bordBottomLineColor.getValue(this.field_14_border_styles2);
    }

    public void setDiagonalBorderColor(int n) {
        this.field_14_border_styles2 = bordDiagLineColor.setValue(this.field_14_border_styles2, n);
    }

    public int getDiagonalBorderColor() {
        return bordDiagLineColor.getValue(this.field_14_border_styles2);
    }

    public void setForwardDiagonalOn(boolean bl) {
        this.field_13_border_styles1 = bordBlTrtLineOnOff.setBoolean(this.field_13_border_styles1, bl);
    }

    public void setBackwardDiagonalOn(boolean bl) {
        this.field_13_border_styles1 = bordTlBrLineOnOff.setBoolean(this.field_13_border_styles1, bl);
    }

    public boolean isForwardDiagonalOn() {
        return bordBlTrtLineOnOff.isSet(this.field_13_border_styles1);
    }

    public boolean isBackwardDiagonalOn() {
        return bordTlBrLineOnOff.isSet(this.field_13_border_styles1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    [Border Formatting]\n");
        stringBuffer.append("          .lftln     = ").append(Integer.toHexString(this.getBorderLeft())).append("\n");
        stringBuffer.append("          .rgtln     = ").append(Integer.toHexString(this.getBorderRight())).append("\n");
        stringBuffer.append("          .topln     = ").append(Integer.toHexString(this.getBorderTop())).append("\n");
        stringBuffer.append("          .btmln     = ").append(Integer.toHexString(this.getBorderBottom())).append("\n");
        stringBuffer.append("          .leftborder= ").append(Integer.toHexString(this.getLeftBorderColor())).append("\n");
        stringBuffer.append("          .rghtborder= ").append(Integer.toHexString(this.getRightBorderColor())).append("\n");
        stringBuffer.append("          .topborder= ").append(Integer.toHexString(this.getTopBorderColor())).append("\n");
        stringBuffer.append("          .bottomborder= ").append(Integer.toHexString(this.getBottomBorderColor())).append("\n");
        stringBuffer.append("          .fwdiag= ").append(this.isForwardDiagonalOn()).append("\n");
        stringBuffer.append("          .bwdiag= ").append(this.isBackwardDiagonalOn()).append("\n");
        stringBuffer.append("    [/Border Formatting]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        BorderFormatting borderFormatting = new BorderFormatting();
        borderFormatting.field_13_border_styles1 = this.field_13_border_styles1;
        borderFormatting.field_14_border_styles2 = this.field_14_border_styles2;
        return borderFormatting;
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putInt(byArray, n + 0, this.field_13_border_styles1);
        LittleEndian.putInt(byArray, n + 4, this.field_14_border_styles2);
        return 8;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.field_13_border_styles1);
        littleEndianOutput.writeInt(this.field_14_border_styles2);
    }
}

