/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.aggregates;

import ai2.org.apache.poi.hssf.model.RecordStream;
import ai2.org.apache.poi.hssf.record.DVALRecord;
import ai2.org.apache.poi.hssf.record.DVRecord;
import ai2.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import java.util.ArrayList;
import java.util.List;

public final class DataValidityTable
extends RecordAggregate {
    private final DVALRecord _headerRec;
    private final List<DVRecord> _validationList;

    public DataValidityTable(RecordStream recordStream) {
        this._headerRec = (DVALRecord)recordStream.getNext();
        ArrayList<DVRecord> arrayList = new ArrayList<DVRecord>();
        while (recordStream.peekNextClass() == DVRecord.class) {
            arrayList.add((DVRecord)recordStream.getNext());
        }
        this._validationList = arrayList;
    }

    public DataValidityTable() {
        this._headerRec = new DVALRecord();
        this._validationList = new ArrayList<DVRecord>();
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        if (this._validationList.isEmpty()) {
            return;
        }
        recordVisitor.visitRecord(this._headerRec);
        for (int i = 0; i < this._validationList.size(); ++i) {
            recordVisitor.visitRecord(this._validationList.get(i));
        }
    }

    public void addDataValidation(DVRecord dVRecord) {
        this._validationList.add(dVRecord);
        this._headerRec.setDVRecNo(this._validationList.size());
    }
}

