/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.aggregates;

import ai2.org.apache.poi.hssf.model.RecordStream;
import ai2.org.apache.poi.hssf.record.HeaderFooterRecord;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RecordBase;
import ai2.org.apache.poi.hssf.record.aggregates.PageSettingsBlock;
import ai2.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import java.util.ArrayList;
import java.util.List;

public final class CustomViewSettingsRecordAggregate
extends RecordAggregate {
    private final Record _begin;
    private final Record _end;
    private final List<RecordBase> _recs;
    private PageSettingsBlock _psBlock;

    public CustomViewSettingsRecordAggregate(RecordStream recordStream) {
        this._begin = recordStream.getNext();
        if (this._begin.getSid() != 426) {
            throw new IllegalStateException("Bad begin record");
        }
        ArrayList<RecordBase> arrayList = new ArrayList<RecordBase>();
        while (recordStream.peekNextSid() != 427) {
            if (PageSettingsBlock.isComponentRecord(recordStream.peekNextSid())) {
                if (this._psBlock != null) {
                    if (recordStream.peekNextSid() == 2204) {
                        this._psBlock.addLateHeaderFooter((HeaderFooterRecord)recordStream.getNext());
                        continue;
                    }
                    throw new IllegalStateException("Found more than one PageSettingsBlock in chart sub-stream, had sid: " + recordStream.peekNextSid());
                }
                this._psBlock = new PageSettingsBlock(recordStream);
                arrayList.add(this._psBlock);
                continue;
            }
            arrayList.add(recordStream.getNext());
        }
        this._recs = arrayList;
        this._end = recordStream.getNext();
        if (this._end.getSid() != 427) {
            throw new IllegalStateException("Bad custom view settings end record");
        }
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        if (this._recs.isEmpty()) {
            return;
        }
        recordVisitor.visitRecord(this._begin);
        for (int i = 0; i < this._recs.size(); ++i) {
            RecordBase recordBase = this._recs.get(i);
            if (recordBase instanceof RecordAggregate) {
                ((RecordAggregate)recordBase).visitContainedRecords(recordVisitor);
                continue;
            }
            recordVisitor.visitRecord((Record)recordBase);
        }
        recordVisitor.visitRecord(this._end);
    }

    public static boolean isBeginRecord(int n) {
        return n == 426;
    }

    public void append(RecordBase recordBase) {
        this._recs.add(recordBase);
    }
}

