/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.aggregates;

import ai2.org.apache.poi.hssf.model.RecordStream;
import ai2.org.apache.poi.hssf.record.CFHeader12Record;
import ai2.org.apache.poi.hssf.record.CFHeaderRecord;
import ai2.org.apache.poi.hssf.record.aggregates.CFRecordsAggregate;
import ai2.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import ai2.org.apache.poi.ss.formula.FormulaShifter;
import java.util.ArrayList;
import java.util.List;

public final class ConditionalFormattingTable
extends RecordAggregate {
    private final List<CFRecordsAggregate> _cfHeaders;

    public ConditionalFormattingTable() {
        this._cfHeaders = new ArrayList<CFRecordsAggregate>();
    }

    public ConditionalFormattingTable(RecordStream recordStream) {
        ArrayList<CFRecordsAggregate> arrayList = new ArrayList<CFRecordsAggregate>();
        while (recordStream.peekNextClass() == CFHeaderRecord.class || recordStream.peekNextClass() == CFHeader12Record.class) {
            arrayList.add(CFRecordsAggregate.createCFAggregate(recordStream));
        }
        this._cfHeaders = arrayList;
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        for (int i = 0; i < this._cfHeaders.size(); ++i) {
            CFRecordsAggregate cFRecordsAggregate = this._cfHeaders.get(i);
            cFRecordsAggregate.visitContainedRecords(recordVisitor);
        }
    }

    public int add(CFRecordsAggregate cFRecordsAggregate) {
        cFRecordsAggregate.getHeader().setID(this._cfHeaders.size());
        this._cfHeaders.add(cFRecordsAggregate);
        return this._cfHeaders.size() - 1;
    }

    public int size() {
        return this._cfHeaders.size();
    }

    public CFRecordsAggregate get(int n) {
        this.checkIndex(n);
        return this._cfHeaders.get(n);
    }

    public void remove(int n) {
        this.checkIndex(n);
        this._cfHeaders.remove(n);
    }

    private void checkIndex(int n) {
        if (n < 0 || n >= this._cfHeaders.size()) {
            throw new IllegalArgumentException("Specified CF index " + n + " is outside the allowable range (0.." + (this._cfHeaders.size() - 1) + ")");
        }
    }

    public void updateFormulasAfterCellShift(FormulaShifter formulaShifter, int n) {
        for (int i = 0; i < this._cfHeaders.size(); ++i) {
            CFRecordsAggregate cFRecordsAggregate = this._cfHeaders.get(i);
            boolean bl = cFRecordsAggregate.updateFormulasAfterCellShift(formulaShifter, n);
            if (bl) continue;
            this._cfHeaders.remove(i);
            --i;
        }
    }
}

