/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.aggregates;

import ai2.org.apache.poi.hssf.model.RecordStream;
import ai2.org.apache.poi.hssf.record.BOFRecord;
import ai2.org.apache.poi.hssf.record.EOFRecord;
import ai2.org.apache.poi.hssf.record.HeaderFooterRecord;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RecordBase;
import ai2.org.apache.poi.hssf.record.aggregates.PageSettingsBlock;
import ai2.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import java.util.ArrayList;
import java.util.List;

public final class ChartSubstreamRecordAggregate
extends RecordAggregate {
    private final BOFRecord _bofRec;
    private final List<RecordBase> _recs;
    private PageSettingsBlock _psBlock;

    public ChartSubstreamRecordAggregate(RecordStream recordStream) {
        this._bofRec = (BOFRecord)recordStream.getNext();
        ArrayList<RecordBase> arrayList = new ArrayList<RecordBase>();
        while (recordStream.peekNextClass() != EOFRecord.class) {
            if (PageSettingsBlock.isComponentRecord(recordStream.peekNextSid())) {
                if (this._psBlock != null) {
                    if (recordStream.peekNextSid() == 2204) {
                        this._psBlock.addLateHeaderFooter((HeaderFooterRecord)recordStream.getNext());
                        continue;
                    }
                    throw new IllegalStateException("Found more than one PageSettingsBlock in chart sub-stream, had sid: " + recordStream.peekNextSid());
                }
                this._psBlock = new PageSettingsBlock(recordStream);
                arrayList.add(this._psBlock);
                continue;
            }
            arrayList.add(recordStream.getNext());
        }
        this._recs = arrayList;
        Record record = recordStream.getNext();
        if (!(record instanceof EOFRecord)) {
            throw new IllegalStateException("Bad chart EOF");
        }
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        if (this._recs.isEmpty()) {
            return;
        }
        recordVisitor.visitRecord(this._bofRec);
        for (int i = 0; i < this._recs.size(); ++i) {
            RecordBase recordBase = this._recs.get(i);
            if (recordBase instanceof RecordAggregate) {
                ((RecordAggregate)recordBase).visitContainedRecords(recordVisitor);
                continue;
            }
            recordVisitor.visitRecord((Record)recordBase);
        }
        recordVisitor.visitRecord(EOFRecord.instance);
    }
}

