/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.aggregates;

import ai2.org.apache.poi.hssf.model.RecordStream;
import ai2.org.apache.poi.hssf.record.CFHeader12Record;
import ai2.org.apache.poi.hssf.record.CFHeaderBase;
import ai2.org.apache.poi.hssf.record.CFHeaderRecord;
import ai2.org.apache.poi.hssf.record.CFRule12Record;
import ai2.org.apache.poi.hssf.record.CFRuleBase;
import ai2.org.apache.poi.hssf.record.CFRuleRecord;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import ai2.org.apache.poi.ss.formula.FormulaShifter;
import ai2.org.apache.poi.ss.formula.ptg.AreaErrPtg;
import ai2.org.apache.poi.ss.formula.ptg.AreaPtg;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.ArrayList;
import java.util.List;

public final class CFRecordsAggregate
extends RecordAggregate {
    private static final int MAX_97_2003_CONDTIONAL_FORMAT_RULES = 3;
    private static final POILogger logger = POILogFactory.getLogger(CFRecordsAggregate.class);
    private final CFHeaderBase header;
    private final List<CFRuleBase> rules;

    private CFRecordsAggregate(CFHeaderBase cFHeaderBase, CFRuleBase[] cFRuleBaseArray) {
        if (cFHeaderBase == null) {
            throw new IllegalArgumentException("header must not be null");
        }
        if (cFRuleBaseArray == null) {
            throw new IllegalArgumentException("rules must not be null");
        }
        if (cFRuleBaseArray.length > 3) {
            logger.log(5, new Object[]{"Excel versions before 2007 require that No more than 3 rules may be specified, " + cFRuleBaseArray.length + " were found," + " this file will cause problems with old Excel versions"});
        }
        if (cFRuleBaseArray.length != cFHeaderBase.getNumberOfConditionalFormats()) {
            throw new RuntimeException("Mismatch number of rules");
        }
        this.header = cFHeaderBase;
        this.rules = new ArrayList<CFRuleBase>(cFRuleBaseArray.length);
        for (int i = 0; i < cFRuleBaseArray.length; ++i) {
            this.checkRuleType(cFRuleBaseArray[i]);
            this.rules.add(cFRuleBaseArray[i]);
        }
    }

    public CFRecordsAggregate(CellRangeAddress[] cellRangeAddressArray, CFRuleBase[] cFRuleBaseArray) {
        this(CFRecordsAggregate.createHeader(cellRangeAddressArray, cFRuleBaseArray), cFRuleBaseArray);
    }

    private static CFHeaderBase createHeader(CellRangeAddress[] cellRangeAddressArray, CFRuleBase[] cFRuleBaseArray) {
        if (cFRuleBaseArray.length == 0 || cFRuleBaseArray[0] instanceof CFRuleRecord) {
            return new CFHeaderRecord(cellRangeAddressArray, cFRuleBaseArray.length);
        }
        return new CFHeader12Record(cellRangeAddressArray, cFRuleBaseArray.length);
    }

    public static CFRecordsAggregate createCFAggregate(RecordStream recordStream) {
        Record record = recordStream.getNext();
        if (record.getSid() != 432 && record.getSid() != 2169) {
            throw new IllegalStateException("next record sid was " + record.getSid() + " instead of " + 432 + " or " + 2169 + " as expected");
        }
        CFHeaderBase cFHeaderBase = (CFHeaderBase)record;
        int n = cFHeaderBase.getNumberOfConditionalFormats();
        CFRuleBase[] cFRuleBaseArray = new CFRuleBase[n];
        for (int i = 0; i < cFRuleBaseArray.length; ++i) {
            cFRuleBaseArray[i] = (CFRuleBase)recordStream.getNext();
        }
        return new CFRecordsAggregate(cFHeaderBase, cFRuleBaseArray);
    }

    public CFRecordsAggregate cloneCFAggregate() {
        CFRuleBase[] cFRuleBaseArray = new CFRuleBase[this.rules.size()];
        for (int i = 0; i < cFRuleBaseArray.length; ++i) {
            cFRuleBaseArray[i] = (CFRuleRecord)this.getRule(i).clone();
        }
        return new CFRecordsAggregate((CFHeaderBase)this.header.clone(), cFRuleBaseArray);
    }

    public CFHeaderBase getHeader() {
        return this.header;
    }

    private void checkRuleIndex(int n) {
        if (n < 0 || n >= this.rules.size()) {
            throw new IllegalArgumentException("Bad rule record index (" + n + ") nRules=" + this.rules.size());
        }
    }

    private void checkRuleType(CFRuleBase cFRuleBase) {
        if (this.header instanceof CFHeaderRecord && cFRuleBase instanceof CFRuleRecord) {
            return;
        }
        if (this.header instanceof CFHeader12Record && cFRuleBase instanceof CFRule12Record) {
            return;
        }
        throw new IllegalArgumentException("Header and Rule must both be CF or both be CF12, can't mix");
    }

    public CFRuleBase getRule(int n) {
        this.checkRuleIndex(n);
        return this.rules.get(n);
    }

    public void setRule(int n, CFRuleBase cFRuleBase) {
        if (cFRuleBase == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        this.checkRuleIndex(n);
        this.checkRuleType(cFRuleBase);
        this.rules.set(n, cFRuleBase);
    }

    public void addRule(CFRuleBase cFRuleBase) {
        if (cFRuleBase == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        if (this.rules.size() >= 3) {
            logger.log(5, new Object[]{"Excel versions before 2007 cannot cope with any more than 3 - this file will cause problems with old Excel versions"});
        }
        this.checkRuleType(cFRuleBase);
        this.rules.add(cFRuleBase);
        this.header.setNumberOfConditionalFormats(this.rules.size());
    }

    public int getNumberOfRules() {
        return this.rules.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "CF";
        if (this.header instanceof CFHeader12Record) {
            string = "CF12";
        }
        stringBuffer.append("[").append(string).append("]\n");
        if (this.header != null) {
            stringBuffer.append(this.header.toString());
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            CFRuleBase cFRuleBase = this.rules.get(i);
            stringBuffer.append(cFRuleBase.toString());
        }
        stringBuffer.append("[/").append(string).append("]\n");
        return stringBuffer.toString();
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        recordVisitor.visitRecord(this.header);
        for (int i = 0; i < this.rules.size(); ++i) {
            CFRuleBase cFRuleBase = this.rules.get(i);
            recordVisitor.visitRecord(cFRuleBase);
        }
    }

    public boolean updateFormulasAfterCellShift(FormulaShifter formulaShifter, int n) {
        Ptg[] ptgArray;
        Object object;
        int n2;
        CellRangeAddress[] cellRangeAddressArray = this.header.getCellRanges();
        boolean bl = false;
        ArrayList<Ptg[]> arrayList = new ArrayList<Ptg[]>();
        for (n2 = 0; n2 < cellRangeAddressArray.length; ++n2) {
            object = cellRangeAddressArray[n2];
            ptgArray = CFRecordsAggregate.shiftRange(formulaShifter, (CellRangeAddress)object, n);
            if (ptgArray == null) {
                bl = true;
                continue;
            }
            arrayList.add(ptgArray);
            if (ptgArray == object) continue;
            bl = true;
        }
        if (bl) {
            n2 = arrayList.size();
            if (n2 == 0) {
                return false;
            }
            object = new CellRangeAddress[n2];
            arrayList.toArray((T[])object);
            this.header.setCellRanges((CellRangeAddress[])object);
        }
        for (n2 = 0; n2 < this.rules.size(); ++n2) {
            CFRule12Record cFRule12Record;
            object = this.rules.get(n2);
            ptgArray = ((CFRuleBase)object).getParsedExpression1();
            if (ptgArray != null && formulaShifter.adjustFormula(ptgArray, n)) {
                ((CFRuleBase)object).setParsedExpression1(ptgArray);
            }
            if ((ptgArray = ((CFRuleBase)object).getParsedExpression2()) != null && formulaShifter.adjustFormula(ptgArray, n)) {
                ((CFRuleBase)object).setParsedExpression2(ptgArray);
            }
            if (!(object instanceof CFRule12Record) || (ptgArray = (cFRule12Record = (CFRule12Record)object).getParsedExpressionScale()) == null || !formulaShifter.adjustFormula(ptgArray, n)) continue;
            cFRule12Record.setParsedExpressionScale(ptgArray);
        }
        return true;
    }

    private static CellRangeAddress shiftRange(FormulaShifter formulaShifter, CellRangeAddress cellRangeAddress, int n) {
        AreaPtg areaPtg = new AreaPtg(cellRangeAddress.getFirstRow(), cellRangeAddress.getLastRow(), cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn(), false, false, false, false);
        Ptg[] ptgArray = new Ptg[]{areaPtg};
        if (!formulaShifter.adjustFormula(ptgArray, n)) {
            return cellRangeAddress;
        }
        Ptg ptg = ptgArray[0];
        if (ptg instanceof AreaPtg) {
            AreaPtg areaPtg2 = (AreaPtg)ptg;
            return new CellRangeAddress(areaPtg2.getFirstRow(), areaPtg2.getLastRow(), areaPtg2.getFirstColumn(), areaPtg2.getLastColumn());
        }
        if (ptg instanceof AreaErrPtg) {
            return null;
        }
        throw new IllegalStateException("Unexpected shifted ptg class (" + ptg.getClass().getName() + ")");
    }
}

