/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class WindowProtectRecord
extends StandardRecord {
    public static final short sid = 25;
    private static final BitField settingsProtectedFlag = BitFieldFactory.getInstance(1);
    private int _options;

    public WindowProtectRecord(int n) {
        this._options = n;
    }

    public WindowProtectRecord(RecordInputStream recordInputStream) {
        this(recordInputStream.readUShort());
    }

    public WindowProtectRecord(boolean bl) {
        this(0);
        this.setProtect(bl);
    }

    public void setProtect(boolean bl) {
        this._options = settingsProtectedFlag.setBoolean(this._options, bl);
    }

    public boolean getProtect() {
        return settingsProtectedFlag.isSet(this._options);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[WINDOWPROTECT]\n");
        stringBuffer.append("    .options = ").append(HexDump.shortToHex(this._options)).append("\n");
        stringBuffer.append("[/WINDOWPROTECT]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._options);
    }

    protected int getDataSize() {
        return 2;
    }

    public short getSid() {
        return 25;
    }

    public Object clone() {
        return new WindowProtectRecord(this._options);
    }
}

