/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class TabIdRecord
extends StandardRecord {
    public static final short sid = 317;
    private static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public short[] _tabids;

    public TabIdRecord() {
        this._tabids = EMPTY_SHORT_ARRAY;
    }

    public TabIdRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.remaining() / 2;
        this._tabids = new short[n];
        for (int i = 0; i < this._tabids.length; ++i) {
            this._tabids[i] = recordInputStream.readShort();
        }
    }

    public void setTabIdArray(short[] sArray) {
        this._tabids = sArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[TABID]\n");
        stringBuffer.append("    .elements        = ").append(this._tabids.length).append("\n");
        for (int i = 0; i < this._tabids.length; ++i) {
            stringBuffer.append("    .element_").append(i).append(" = ").append(this._tabids[i]).append("\n");
        }
        stringBuffer.append("[/TABID]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        short[] sArray = this._tabids;
        for (int i = 0; i < sArray.length; ++i) {
            littleEndianOutput.writeShort(sArray[i]);
        }
    }

    protected int getDataSize() {
        return this._tabids.length * 2;
    }

    public short getSid() {
        return 317;
    }
}

