/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.FormulaRecord;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.SharedValueRecordBase;
import ai2.org.apache.poi.hssf.util.CellRangeAddress8Bit;
import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.formula.Formula;
import ai2.org.apache.poi.ss.formula.SharedFormula;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class SharedFormulaRecord
extends SharedValueRecordBase {
    public static final short sid = 1212;
    private int field_5_reserved;
    private Formula field_7_parsed_expr;

    public SharedFormulaRecord() {
        this(new CellRangeAddress8Bit(0, 0, 0, 0));
    }

    private SharedFormulaRecord(CellRangeAddress8Bit cellRangeAddress8Bit) {
        super(cellRangeAddress8Bit);
        this.field_7_parsed_expr = Formula.create(Ptg.EMPTY_PTG_ARRAY);
    }

    public SharedFormulaRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        this.field_5_reserved = recordInputStream.readShort();
        short s = recordInputStream.readShort();
        int n = recordInputStream.available();
        this.field_7_parsed_expr = Formula.read(s, recordInputStream, n);
    }

    protected void serializeExtraData(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_5_reserved);
        this.field_7_parsed_expr.serialize(littleEndianOutput);
    }

    protected int getExtraDataSize() {
        return 2 + this.field_7_parsed_expr.getEncodedSize();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SHARED FORMULA (").append(HexDump.intToHex(1212)).append("]\n");
        stringBuffer.append("    .range      = ").append(this.getRange().toString()).append("\n");
        stringBuffer.append("    .reserved    = ").append(HexDump.shortToHex(this.field_5_reserved)).append("\n");
        Ptg[] ptgArray = this.field_7_parsed_expr.getTokens();
        for (int i = 0; i < ptgArray.length; ++i) {
            stringBuffer.append("Formula[").append(i).append("]");
            Ptg ptg = ptgArray[i];
            stringBuffer.append(ptg.toString()).append(ptg.getRVAType()).append("\n");
        }
        stringBuffer.append("[/SHARED FORMULA]\n");
        return stringBuffer.toString();
    }

    public short getSid() {
        return 1212;
    }

    public Ptg[] getFormulaTokens(FormulaRecord formulaRecord) {
        short s;
        int n = formulaRecord.getRow();
        if (!this.isInRange(n, s = formulaRecord.getColumn())) {
            throw new RuntimeException("Shared Formula Conversion: Coding Error");
        }
        SharedFormula sharedFormula = new SharedFormula(SpreadsheetVersion.EXCEL97);
        return sharedFormula.convertSharedFormulas(this.field_7_parsed_expr.getTokens(), n, s);
    }

    public Object clone() {
        SharedFormulaRecord sharedFormulaRecord = new SharedFormulaRecord(this.getRange());
        sharedFormulaRecord.field_5_reserved = this.field_5_reserved;
        sharedFormulaRecord.field_7_parsed_expr = this.field_7_parsed_expr.copy();
        return sharedFormulaRecord;
    }

    public boolean isFormulaSame(SharedFormulaRecord sharedFormulaRecord) {
        return this.field_7_parsed_expr.isSame(sharedFormulaRecord.field_7_parsed_expr);
    }
}

