/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.hssf.util.CellRangeAddress8Bit;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class SelectionRecord
extends StandardRecord {
    public static final short sid = 29;
    private byte field_1_pane;
    private int field_2_row_active_cell;
    private int field_3_col_active_cell;
    private int field_4_active_cell_ref_index;
    private CellRangeAddress8Bit[] field_6_refs;

    public SelectionRecord(int n, int n2) {
        this.field_1_pane = (byte)3;
        this.field_2_row_active_cell = n;
        this.field_3_col_active_cell = n2;
        this.field_4_active_cell_ref_index = 0;
        this.field_6_refs = new CellRangeAddress8Bit[]{new CellRangeAddress8Bit(n, n, n2, n2)};
    }

    public SelectionRecord(RecordInputStream recordInputStream) {
        this.field_1_pane = recordInputStream.readByte();
        this.field_2_row_active_cell = recordInputStream.readUShort();
        this.field_3_col_active_cell = recordInputStream.readShort();
        this.field_4_active_cell_ref_index = recordInputStream.readShort();
        int n = recordInputStream.readUShort();
        this.field_6_refs = new CellRangeAddress8Bit[n];
        for (int i = 0; i < this.field_6_refs.length; ++i) {
            this.field_6_refs[i] = new CellRangeAddress8Bit(recordInputStream);
        }
    }

    public void setPane(byte by) {
        this.field_1_pane = by;
    }

    public void setActiveCellRow(int n) {
        this.field_2_row_active_cell = n;
    }

    public void setActiveCellCol(short s) {
        this.field_3_col_active_cell = s;
    }

    public void setActiveCellRef(short s) {
        this.field_4_active_cell_ref_index = s;
    }

    public byte getPane() {
        return this.field_1_pane;
    }

    public int getActiveCellRow() {
        return this.field_2_row_active_cell;
    }

    public int getActiveCellCol() {
        return this.field_3_col_active_cell;
    }

    public int getActiveCellRef() {
        return this.field_4_active_cell_ref_index;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SELECTION]\n");
        stringBuffer.append("    .pane            = ").append(HexDump.byteToHex(this.getPane())).append("\n");
        stringBuffer.append("    .activecellrow   = ").append(HexDump.shortToHex(this.getActiveCellRow())).append("\n");
        stringBuffer.append("    .activecellcol   = ").append(HexDump.shortToHex(this.getActiveCellCol())).append("\n");
        stringBuffer.append("    .activecellref   = ").append(HexDump.shortToHex(this.getActiveCellRef())).append("\n");
        stringBuffer.append("    .numrefs         = ").append(HexDump.shortToHex(this.field_6_refs.length)).append("\n");
        stringBuffer.append("[/SELECTION]\n");
        return stringBuffer.toString();
    }

    protected int getDataSize() {
        return 9 + CellRangeAddress8Bit.getEncodedSize(this.field_6_refs.length);
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(this.getPane());
        littleEndianOutput.writeShort(this.getActiveCellRow());
        littleEndianOutput.writeShort(this.getActiveCellCol());
        littleEndianOutput.writeShort(this.getActiveCellRef());
        int n = this.field_6_refs.length;
        littleEndianOutput.writeShort(n);
        for (int i = 0; i < this.field_6_refs.length; ++i) {
            this.field_6_refs[i].serialize(littleEndianOutput);
        }
    }

    public short getSid() {
        return 29;
    }

    public Object clone() {
        SelectionRecord selectionRecord = new SelectionRecord(this.field_2_row_active_cell, this.field_3_col_active_cell);
        selectionRecord.field_1_pane = this.field_1_pane;
        selectionRecord.field_4_active_cell_ref_index = this.field_4_active_cell_ref_index;
        selectionRecord.field_6_refs = this.field_6_refs;
        return selectionRecord;
    }
}

