/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import ai2.org.apache.poi.hssf.record.BOFRecord;
import ai2.org.apache.poi.hssf.record.ContinueRecord;
import ai2.org.apache.poi.hssf.record.DBCellRecord;
import ai2.org.apache.poi.hssf.record.DrawingGroupRecord;
import ai2.org.apache.poi.hssf.record.DrawingRecord;
import ai2.org.apache.poi.hssf.record.EOFRecord;
import ai2.org.apache.poi.hssf.record.FilePassRecord;
import ai2.org.apache.poi.hssf.record.MulRKRecord;
import ai2.org.apache.poi.hssf.record.NumberRecord;
import ai2.org.apache.poi.hssf.record.ObjRecord;
import ai2.org.apache.poi.hssf.record.RKRecord;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RecordFactory;
import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.TextObjectRecord;
import ai2.org.apache.poi.hssf.record.UnknownRecord;
import ai2.org.apache.poi.hssf.record.WriteProtectRecord;
import ai2.org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import ai2.org.apache.poi.hssf.record.crypto.Biff8RC4Key;
import ai2.org.apache.poi.hssf.record.crypto.Biff8XORKey;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class RecordFactoryInputStream {
    private final RecordInputStream _recStream;
    private final boolean _shouldIncludeContinueRecords;
    private Record[] _unreadRecordBuffer;
    private int _unreadRecordIndex = -1;
    private Record _lastRecord = null;
    private DrawingRecord _lastDrawingRecord = new DrawingRecord();
    private int _bofDepth;
    private boolean _lastRecordWasEOFLevelZero;

    public RecordFactoryInputStream(InputStream inputStream, boolean bl) {
        RecordInputStream recordInputStream = new RecordInputStream(inputStream);
        ArrayList<Record> arrayList = new ArrayList<Record>();
        StreamEncryptionInfo streamEncryptionInfo = new StreamEncryptionInfo(recordInputStream, arrayList);
        if (streamEncryptionInfo.hasEncryption()) {
            recordInputStream = streamEncryptionInfo.createDecryptingStream(inputStream);
        }
        if (!arrayList.isEmpty()) {
            this._unreadRecordBuffer = new Record[arrayList.size()];
            arrayList.toArray(this._unreadRecordBuffer);
            this._unreadRecordIndex = 0;
        }
        this._recStream = recordInputStream;
        this._shouldIncludeContinueRecords = bl;
        this._lastRecord = streamEncryptionInfo.getLastRecord();
        this._bofDepth = streamEncryptionInfo.hasBOFRecord() ? 1 : 0;
        this._lastRecordWasEOFLevelZero = false;
    }

    public Record nextRecord() {
        Record record = this.getNextUnreadRecord();
        if (record != null) {
            return record;
        }
        do {
            if (!this._recStream.hasNextRecord()) {
                return null;
            }
            if (this._lastRecordWasEOFLevelZero && this._recStream.getNextSid() != 2057) {
                return null;
            }
            this._recStream.nextRecord();
            record = this.readNextRecord();
        } while (record == null);
        return record;
    }

    private Record getNextUnreadRecord() {
        if (this._unreadRecordBuffer != null) {
            int n = this._unreadRecordIndex;
            if (n < this._unreadRecordBuffer.length) {
                Record record = this._unreadRecordBuffer[n];
                this._unreadRecordIndex = n + 1;
                return record;
            }
            this._unreadRecordIndex = -1;
            this._unreadRecordBuffer = null;
        }
        return null;
    }

    private Record readNextRecord() {
        Record record = RecordFactory.createSingleRecord(this._recStream);
        this._lastRecordWasEOFLevelZero = false;
        if (record instanceof BOFRecord) {
            ++this._bofDepth;
            return record;
        }
        if (record instanceof EOFRecord) {
            --this._bofDepth;
            if (this._bofDepth < 1) {
                this._lastRecordWasEOFLevelZero = true;
            }
            return record;
        }
        if (record instanceof DBCellRecord) {
            return null;
        }
        if (record instanceof RKRecord) {
            return RecordFactory.convertToNumberRecord((RKRecord)record);
        }
        if (record instanceof MulRKRecord) {
            NumberRecord[] numberRecordArray = RecordFactory.convertRKRecords((MulRKRecord)record);
            this._unreadRecordBuffer = numberRecordArray;
            this._unreadRecordIndex = 1;
            return numberRecordArray[0];
        }
        if (record.getSid() == 235 && this._lastRecord instanceof DrawingGroupRecord) {
            DrawingGroupRecord drawingGroupRecord = (DrawingGroupRecord)this._lastRecord;
            drawingGroupRecord.join((AbstractEscherHolderRecord)record);
            return null;
        }
        if (record.getSid() == 60) {
            ContinueRecord continueRecord = (ContinueRecord)record;
            if (this._lastRecord instanceof ObjRecord || this._lastRecord instanceof TextObjectRecord) {
                this._lastDrawingRecord.processContinueRecord(continueRecord.getData());
                if (this._shouldIncludeContinueRecords) {
                    return record;
                }
                return null;
            }
            if (this._lastRecord instanceof DrawingGroupRecord) {
                ((DrawingGroupRecord)this._lastRecord).processContinueRecord(continueRecord.getData());
                return null;
            }
            if (this._lastRecord instanceof DrawingRecord) {
                return continueRecord;
            }
            if (this._lastRecord instanceof UnknownRecord) {
                return record;
            }
            if (this._lastRecord instanceof EOFRecord) {
                return record;
            }
            throw new RecordFormatException("Unhandled Continue Record followining " + this._lastRecord.getClass());
        }
        this._lastRecord = record;
        if (record instanceof DrawingRecord) {
            this._lastDrawingRecord = (DrawingRecord)record;
        }
        return record;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StreamEncryptionInfo {
        private final int _initialRecordsSize;
        private final FilePassRecord _filePassRec;
        private final Record _lastRecord;
        private final boolean _hasBOFRecord;
        private static POILogger log = POILogFactory.getLogger(StreamEncryptionInfo.class);

        public StreamEncryptionInfo(RecordInputStream recordInputStream, List<Record> list) {
            recordInputStream.nextRecord();
            int n = 4 + recordInputStream.remaining();
            Record record = RecordFactory.createSingleRecord(recordInputStream);
            list.add(record);
            FilePassRecord filePassRecord = null;
            if (record instanceof BOFRecord) {
                this._hasBOFRecord = true;
                if (recordInputStream.hasNextRecord()) {
                    recordInputStream.nextRecord();
                    record = RecordFactory.createSingleRecord(recordInputStream);
                    n += record.getRecordSize();
                    list.add(record);
                    if (record instanceof WriteProtectRecord && recordInputStream.hasNextRecord()) {
                        recordInputStream.nextRecord();
                        record = RecordFactory.createSingleRecord(recordInputStream);
                        n += record.getRecordSize();
                        list.add(record);
                    }
                    if (record instanceof FilePassRecord) {
                        filePassRecord = (FilePassRecord)record;
                        list.remove(list.size() - 1);
                        record = list.get(0);
                    } else if (record instanceof EOFRecord) {
                        throw new IllegalStateException("Nothing between BOF and EOF");
                    }
                }
            } else {
                this._hasBOFRecord = false;
            }
            this._initialRecordsSize = n;
            this._filePassRec = filePassRecord;
            this._lastRecord = record;
        }

        public RecordInputStream createDecryptingStream(InputStream inputStream) {
            Biff8EncryptionKey biff8EncryptionKey;
            FilePassRecord filePassRecord = this._filePassRec;
            String string = Biff8EncryptionKey.getCurrentUserPassword();
            if (string == null) {
                string = "VelvetSweatshop";
            }
            if (filePassRecord.getRc4KeyData() != null) {
                Biff8RC4Key biff8RC4Key;
                FilePassRecord.Rc4KeyData rc4KeyData = filePassRecord.getRc4KeyData();
                biff8EncryptionKey = biff8RC4Key = Biff8RC4Key.create(string, rc4KeyData.getSalt());
                if (!biff8RC4Key.validate(rc4KeyData.getEncryptedVerifier(), rc4KeyData.getEncryptedVerifierHash())) {
                    throw new EncryptedDocumentException(("VelvetSweatshop".equals(string) ? "Default" : "Supplied") + " password is invalid for salt/verifier/verifierHash");
                }
            } else if (filePassRecord.getXorKeyData() != null) {
                FilePassRecord.XorKeyData xorKeyData = filePassRecord.getXorKeyData();
                Biff8XORKey biff8XORKey = Biff8XORKey.create(string, xorKeyData.getKey());
                biff8EncryptionKey = biff8XORKey;
                if (!biff8XORKey.validate(string, xorKeyData.getVerifier())) {
                    throw new EncryptedDocumentException(("VelvetSweatshop".equals(string) ? "Default" : "Supplied") + " password is invalid for key/verifier");
                }
            } else {
                throw new EncryptedDocumentException("Crypto API not yet supported.");
            }
            return new RecordInputStream(inputStream, biff8EncryptionKey, this._initialRecordsSize);
        }

        public boolean hasEncryption() {
            return this._filePassRec != null;
        }

        public Record getLastRecord() {
            return this._lastRecord;
        }

        public boolean hasBOFRecord() {
            return this._hasBOFRecord;
        }
    }
}

