/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordBase;
import ai2.org.apache.poi.hssf.record.RecordFactory;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import java.io.ByteArrayInputStream;

public abstract class Record
extends RecordBase {
    protected Record() {
    }

    public final byte[] serialize() {
        byte[] byArray = new byte[this.getRecordSize()];
        this.serialize(0, byArray);
        return byArray;
    }

    public String toString() {
        return super.toString();
    }

    public abstract short getSid();

    public Object clone() {
        throw new RuntimeException("The class " + this.getClass().getName() + " needs to define a clone method");
    }

    public Record cloneViaReserialise() {
        byte[] byArray = this.serialize();
        RecordInputStream recordInputStream = new RecordInputStream(new ByteArrayInputStream(byArray));
        recordInputStream.nextRecord();
        Record[] recordArray = RecordFactory.createRecord(recordInputStream);
        if (recordArray.length != 1) {
            throw new IllegalStateException("Re-serialised a record to clone it, but got " + recordArray.length + " records back!");
        }
        return recordArray[0];
    }
}

