/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class PasswordRecord
extends StandardRecord {
    public static final short sid = 19;
    private int field_1_password;

    public PasswordRecord(int n) {
        this.field_1_password = n;
    }

    public PasswordRecord(RecordInputStream recordInputStream) {
        this.field_1_password = recordInputStream.readShort();
    }

    public static short hashPassword(String string) {
        return (short)CryptoFunctions.createXorVerifier1(string);
    }

    public void setPassword(int n) {
        this.field_1_password = n;
    }

    public int getPassword() {
        return this.field_1_password;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[PASSWORD]\n");
        stringBuffer.append("    .password = ").append(HexDump.shortToHex(this.field_1_password)).append("\n");
        stringBuffer.append("[/PASSWORD]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_password);
    }

    protected int getDataSize() {
        return 2;
    }

    public short getSid() {
        return 19;
    }

    public Object clone() {
        return new PasswordRecord(this.field_1_password);
    }
}

