/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.LittleEndianOutput;
import java.util.ArrayList;
import java.util.List;

public final class PaletteRecord
extends StandardRecord {
    public static final short sid = 146;
    public static final byte STANDARD_PALETTE_SIZE = 56;
    public static final short FIRST_COLOR_INDEX = 8;
    private final List<PColor> _colors;

    public PaletteRecord() {
        PColor[] pColorArray = PaletteRecord.createDefaultPalette();
        this._colors = new ArrayList<PColor>(pColorArray.length);
        for (int i = 0; i < pColorArray.length; ++i) {
            this._colors.add(pColorArray[i]);
        }
    }

    public PaletteRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.readShort();
        this._colors = new ArrayList<PColor>(n);
        for (int i = 0; i < n; ++i) {
            this._colors.add(new PColor(recordInputStream));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[PALETTE]\n");
        stringBuffer.append("  numcolors     = ").append(this._colors.size()).append('\n');
        for (int i = 0; i < this._colors.size(); ++i) {
            PColor pColor = this._colors.get(i);
            stringBuffer.append("* colornum      = ").append(i).append('\n');
            stringBuffer.append(pColor.toString());
            stringBuffer.append("/*colornum      = ").append(i).append('\n');
        }
        stringBuffer.append("[/PALETTE]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._colors.size());
        for (int i = 0; i < this._colors.size(); ++i) {
            this._colors.get(i).serialize(littleEndianOutput);
        }
    }

    protected int getDataSize() {
        return 2 + this._colors.size() * 4;
    }

    public short getSid() {
        return 146;
    }

    public byte[] getColor(int n) {
        int n2 = n - 8;
        if (n2 < 0 || n2 >= this._colors.size()) {
            return null;
        }
        return this._colors.get(n2).getTriplet();
    }

    public void setColor(short s, byte by, byte by2, byte by3) {
        int n = s - 8;
        if (n < 0 || n >= 56) {
            return;
        }
        while (this._colors.size() <= n) {
            this._colors.add(new PColor(0, 0, 0));
        }
        PColor pColor = new PColor(by, by2, by3);
        this._colors.set(n, pColor);
    }

    private static PColor[] createDefaultPalette() {
        return new PColor[]{PaletteRecord.pc(0, 0, 0), PaletteRecord.pc(255, 255, 255), PaletteRecord.pc(255, 0, 0), PaletteRecord.pc(0, 255, 0), PaletteRecord.pc(0, 0, 255), PaletteRecord.pc(255, 255, 0), PaletteRecord.pc(255, 0, 255), PaletteRecord.pc(0, 255, 255), PaletteRecord.pc(128, 0, 0), PaletteRecord.pc(0, 128, 0), PaletteRecord.pc(0, 0, 128), PaletteRecord.pc(128, 128, 0), PaletteRecord.pc(128, 0, 128), PaletteRecord.pc(0, 128, 128), PaletteRecord.pc(192, 192, 192), PaletteRecord.pc(128, 128, 128), PaletteRecord.pc(153, 153, 255), PaletteRecord.pc(153, 51, 102), PaletteRecord.pc(255, 255, 204), PaletteRecord.pc(204, 255, 255), PaletteRecord.pc(102, 0, 102), PaletteRecord.pc(255, 128, 128), PaletteRecord.pc(0, 102, 204), PaletteRecord.pc(204, 204, 255), PaletteRecord.pc(0, 0, 128), PaletteRecord.pc(255, 0, 255), PaletteRecord.pc(255, 255, 0), PaletteRecord.pc(0, 255, 255), PaletteRecord.pc(128, 0, 128), PaletteRecord.pc(128, 0, 0), PaletteRecord.pc(0, 128, 128), PaletteRecord.pc(0, 0, 255), PaletteRecord.pc(0, 204, 255), PaletteRecord.pc(204, 255, 255), PaletteRecord.pc(204, 255, 204), PaletteRecord.pc(255, 255, 153), PaletteRecord.pc(153, 204, 255), PaletteRecord.pc(255, 153, 204), PaletteRecord.pc(204, 153, 255), PaletteRecord.pc(255, 204, 153), PaletteRecord.pc(51, 102, 255), PaletteRecord.pc(51, 204, 204), PaletteRecord.pc(153, 204, 0), PaletteRecord.pc(255, 204, 0), PaletteRecord.pc(255, 153, 0), PaletteRecord.pc(255, 102, 0), PaletteRecord.pc(102, 102, 153), PaletteRecord.pc(150, 150, 150), PaletteRecord.pc(0, 51, 102), PaletteRecord.pc(51, 153, 102), PaletteRecord.pc(0, 51, 0), PaletteRecord.pc(51, 51, 0), PaletteRecord.pc(153, 51, 0), PaletteRecord.pc(153, 51, 102), PaletteRecord.pc(51, 51, 153), PaletteRecord.pc(51, 51, 51)};
    }

    private static PColor pc(int n, int n2, int n3) {
        return new PColor(n, n2, n3);
    }

    private static final class PColor {
        public static final short ENCODED_SIZE = 4;
        private int _red;
        private int _green;
        private int _blue;

        public PColor(int n, int n2, int n3) {
            this._red = n;
            this._green = n2;
            this._blue = n3;
        }

        public byte[] getTriplet() {
            return new byte[]{(byte)this._red, (byte)this._green, (byte)this._blue};
        }

        public PColor(RecordInputStream recordInputStream) {
            this._red = recordInputStream.readByte();
            this._green = recordInputStream.readByte();
            this._blue = recordInputStream.readByte();
            recordInputStream.readByte();
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeByte(this._red);
            littleEndianOutput.writeByte(this._green);
            littleEndianOutput.writeByte(this._blue);
            littleEndianOutput.writeByte(0);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("  red   = ").append(this._red & 0xFF).append('\n');
            stringBuffer.append("  green = ").append(this._green & 0xFF).append('\n');
            stringBuffer.append("  blue  = ").append(this._blue & 0xFF).append('\n');
            return stringBuffer.toString();
        }
    }
}

