/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.CodepageRecord;
import ai2.org.apache.poi.hssf.record.OldCellRecord;
import ai2.org.apache.poi.hssf.record.OldStringRecord;
import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;

public final class OldLabelRecord
extends OldCellRecord {
    private static final POILogger logger = POILogFactory.getLogger(OldLabelRecord.class);
    public static final short biff2_sid = 4;
    public static final short biff345_sid = 516;
    private short field_4_string_len;
    private byte[] field_5_bytes;
    private CodepageRecord codepage;

    public OldLabelRecord(RecordInputStream recordInputStream) {
        super(recordInputStream, recordInputStream.getSid() == 4);
        this.field_4_string_len = this.isBiff2() ? (short)recordInputStream.readUByte() : recordInputStream.readShort();
        this.field_5_bytes = new byte[this.field_4_string_len];
        recordInputStream.read(this.field_5_bytes, 0, this.field_4_string_len);
        if (recordInputStream.remaining() > 0) {
            logger.log(3, new Object[]{"LabelRecord data remains: " + recordInputStream.remaining() + " : " + HexDump.toHex(recordInputStream.readRemainder())});
        }
    }

    public void setCodePage(CodepageRecord codepageRecord) {
        this.codepage = codepageRecord;
    }

    public short getStringLength() {
        return this.field_4_string_len;
    }

    public String getValue() {
        return OldStringRecord.getString(this.field_5_bytes, this.codepage);
    }

    public int serialize(int n, byte[] byArray) {
        throw new RecordFormatException("Old Label Records are supported READ ONLY");
    }

    public int getRecordSize() {
        throw new RecordFormatException("Old Label Records are supported READ ONLY");
    }

    protected void appendValueText(StringBuilder stringBuilder) {
        stringBuilder.append("    .string_len= ").append(HexDump.shortToHex(this.field_4_string_len)).append("\n");
        stringBuilder.append("    .value       = ").append(this.getValue()).append("\n");
    }

    protected String getRecordName() {
        return "OLD LABEL";
    }
}

