/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.util.HexDump;

public abstract class OldCellRecord {
    private short sid;
    private boolean isBiff2;
    private int field_1_row;
    private short field_2_column;
    private int field_3_cell_attrs;
    private short field_3_xf_index;

    protected OldCellRecord(RecordInputStream recordInputStream, boolean bl) {
        this.sid = recordInputStream.getSid();
        this.isBiff2 = bl;
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_column = recordInputStream.readShort();
        if (bl) {
            this.field_3_cell_attrs = recordInputStream.readUShort() << 8;
            this.field_3_cell_attrs += recordInputStream.readUByte();
        } else {
            this.field_3_xf_index = recordInputStream.readShort();
        }
    }

    public final int getRow() {
        return this.field_1_row;
    }

    public final short getColumn() {
        return this.field_2_column;
    }

    public final short getXFIndex() {
        return this.field_3_xf_index;
    }

    public int getCellAttrs() {
        return this.field_3_cell_attrs;
    }

    public boolean isBiff2() {
        return this.isBiff2;
    }

    public short getSid() {
        return this.sid;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getRecordName();
        stringBuilder.append("[").append(string).append("]\n");
        stringBuilder.append("    .row    = ").append(HexDump.shortToHex(this.getRow())).append("\n");
        stringBuilder.append("    .col    = ").append(HexDump.shortToHex(this.getColumn())).append("\n");
        if (this.isBiff2()) {
            stringBuilder.append("    .cellattrs = ").append(HexDump.shortToHex(this.getCellAttrs())).append("\n");
        } else {
            stringBuilder.append("    .xfindex   = ").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        }
        this.appendValueText(stringBuilder);
        stringBuilder.append("\n");
        stringBuilder.append("[/").append(string).append("]\n");
        return stringBuilder.toString();
    }

    protected abstract void appendValueText(StringBuilder var1);

    protected abstract String getRecordName();
}

