/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.SubRecord;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.StringUtil;

public class LbsDataSubRecord
extends SubRecord {
    public static final int sid = 19;
    private int _cbFContinued;
    private int _unknownPreFormulaInt;
    private Ptg _linkPtg;
    private Byte _unknownPostFormulaByte;
    private int _cLines;
    private int _iSel;
    private int _flags;
    private int _idEdit;
    private LbsDropData _dropData;
    private String[] _rgLines;
    private boolean[] _bsels;

    public LbsDataSubRecord(LittleEndianInput littleEndianInput, int n, int n2) {
        int n3;
        this._cbFContinued = n;
        int n4 = littleEndianInput.readUShort();
        if (n4 > 0) {
            n3 = littleEndianInput.readUShort();
            this._unknownPreFormulaInt = littleEndianInput.readInt();
            Ptg[] ptgArray = Ptg.readTokens(n3, littleEndianInput);
            if (ptgArray.length != 1) {
                throw new RecordFormatException("Read " + ptgArray.length + " tokens but expected exactly 1");
            }
            this._linkPtg = ptgArray[0];
            switch (n4 - n3 - 6) {
                case 1: {
                    this._unknownPostFormulaByte = littleEndianInput.readByte();
                    break;
                }
                case 0: {
                    this._unknownPostFormulaByte = null;
                    break;
                }
                default: {
                    throw new RecordFormatException("Unexpected leftover bytes");
                }
            }
        }
        this._cLines = littleEndianInput.readUShort();
        this._iSel = littleEndianInput.readUShort();
        this._flags = littleEndianInput.readUShort();
        this._idEdit = littleEndianInput.readUShort();
        if (n2 == 20) {
            this._dropData = new LbsDropData(littleEndianInput);
        }
        if ((this._flags & 2) != 0) {
            this._rgLines = new String[this._cLines];
            for (n3 = 0; n3 < this._cLines; ++n3) {
                this._rgLines[n3] = StringUtil.readUnicodeString(littleEndianInput);
            }
        }
        if ((this._flags >> 4 & 2) != 0) {
            this._bsels = new boolean[this._cLines];
            for (n3 = 0; n3 < this._cLines; ++n3) {
                this._bsels[n3] = littleEndianInput.readByte() == 1;
            }
        }
    }

    LbsDataSubRecord() {
    }

    public static LbsDataSubRecord newAutoFilterInstance() {
        LbsDataSubRecord lbsDataSubRecord = new LbsDataSubRecord();
        lbsDataSubRecord._cbFContinued = 8174;
        lbsDataSubRecord._iSel = 0;
        lbsDataSubRecord._flags = 769;
        lbsDataSubRecord._dropData = new LbsDropData();
        lbsDataSubRecord._dropData._wStyle = 2;
        lbsDataSubRecord._dropData._cLine = 8;
        return lbsDataSubRecord;
    }

    public boolean isTerminating() {
        return true;
    }

    protected int getDataSize() {
        int n = 2;
        if (this._linkPtg != null) {
            n += 2;
            n += 4;
            n += this._linkPtg.getSize();
            if (this._unknownPostFormulaByte != null) {
                ++n;
            }
        }
        n += 8;
        if (this._dropData != null) {
            n += this._dropData.getDataSize();
        }
        if (this._rgLines != null) {
            for (String string : this._rgLines) {
                n += StringUtil.getEncodedSize(string);
            }
        }
        if (this._bsels != null) {
            n += this._bsels.length;
        }
        return n;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(19);
        littleEndianOutput.writeShort(this._cbFContinued);
        if (this._linkPtg == null) {
            littleEndianOutput.writeShort(0);
        } else {
            int n = this._linkPtg.getSize();
            int n2 = n + 6;
            if (this._unknownPostFormulaByte != null) {
                ++n2;
            }
            littleEndianOutput.writeShort(n2);
            littleEndianOutput.writeShort(n);
            littleEndianOutput.writeInt(this._unknownPreFormulaInt);
            this._linkPtg.write(littleEndianOutput);
            if (this._unknownPostFormulaByte != null) {
                littleEndianOutput.writeByte(this._unknownPostFormulaByte.intValue());
            }
        }
        littleEndianOutput.writeShort(this._cLines);
        littleEndianOutput.writeShort(this._iSel);
        littleEndianOutput.writeShort(this._flags);
        littleEndianOutput.writeShort(this._idEdit);
        if (this._dropData != null) {
            this._dropData.serialize(littleEndianOutput);
        }
        if (this._rgLines != null) {
            for (String string : this._rgLines) {
                StringUtil.writeUnicodeString(littleEndianOutput, string);
            }
        }
        if (this._bsels != null) {
            for (boolean bl : this._bsels) {
                littleEndianOutput.writeByte(bl ? 1 : 0);
            }
        }
    }

    public Object clone() {
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("[ftLbsData]\n");
        stringBuffer.append("    .unknownShort1 =").append(HexDump.shortToHex(this._cbFContinued)).append("\n");
        stringBuffer.append("    .formula        = ").append('\n');
        if (this._linkPtg != null) {
            stringBuffer.append(this._linkPtg.toString()).append(this._linkPtg.getRVAType()).append('\n');
        }
        stringBuffer.append("    .nEntryCount   =").append(HexDump.shortToHex(this._cLines)).append("\n");
        stringBuffer.append("    .selEntryIx    =").append(HexDump.shortToHex(this._iSel)).append("\n");
        stringBuffer.append("    .style         =").append(HexDump.shortToHex(this._flags)).append("\n");
        stringBuffer.append("    .unknownShort10=").append(HexDump.shortToHex(this._idEdit)).append("\n");
        if (this._dropData != null) {
            stringBuffer.append('\n').append(this._dropData.toString());
        }
        stringBuffer.append("[/ftLbsData]\n");
        return stringBuffer.toString();
    }

    public Ptg getFormula() {
        return this._linkPtg;
    }

    public int getNumberOfItems() {
        return this._cLines;
    }

    public static class LbsDropData {
        public static final int STYLE_COMBO_DROPDOWN = 0;
        public static final int STYLE_COMBO_EDIT_DROPDOWN = 1;
        public static final int STYLE_COMBO_SIMPLE_DROPDOWN = 2;
        private int _wStyle;
        private int _cLine;
        private int _dxMin;
        private String _str;
        private Byte _unused;

        public LbsDropData() {
            this._str = "";
            this._unused = 0;
        }

        public LbsDropData(LittleEndianInput littleEndianInput) {
            this._wStyle = littleEndianInput.readUShort();
            this._cLine = littleEndianInput.readUShort();
            this._dxMin = littleEndianInput.readUShort();
            this._str = StringUtil.readUnicodeString(littleEndianInput);
            if (StringUtil.getEncodedSize(this._str) % 2 != 0) {
                this._unused = littleEndianInput.readByte();
            }
        }

        public void setStyle(int n) {
            this._wStyle = n;
        }

        public void setNumLines(int n) {
            this._cLine = n;
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeShort(this._wStyle);
            littleEndianOutput.writeShort(this._cLine);
            littleEndianOutput.writeShort(this._dxMin);
            StringUtil.writeUnicodeString(littleEndianOutput, this._str);
            if (this._unused != null) {
                littleEndianOutput.writeByte(this._unused.byteValue());
            }
        }

        public int getDataSize() {
            int n = 6;
            n += StringUtil.getEncodedSize(this._str);
            if (this._unused != null) {
                ++n;
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[LbsDropData]\n");
            stringBuffer.append("  ._wStyle:  ").append(this._wStyle).append('\n');
            stringBuffer.append("  ._cLine:  ").append(this._cLine).append('\n');
            stringBuffer.append("  ._dxMin:  ").append(this._dxMin).append('\n');
            stringBuffer.append("  ._str:  ").append(this._str).append('\n');
            if (this._unused != null) {
                stringBuffer.append("  ._unused:  ").append(this._unused).append('\n');
            }
            stringBuffer.append("[/LbsDropData]\n");
            return stringBuffer.toString();
        }
    }
}

