/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;
import java.util.Arrays;
import java.util.Locale;

public final class HeaderFooterRecord
extends StandardRecord {
    private static final byte[] BLANK_GUID = new byte[16];
    public static final short sid = 2204;
    private byte[] _rawData;

    public HeaderFooterRecord(byte[] byArray) {
        this._rawData = byArray;
    }

    public HeaderFooterRecord(RecordInputStream recordInputStream) {
        this._rawData = recordInputStream.readRemainder();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.write(this._rawData);
    }

    protected int getDataSize() {
        return this._rawData.length;
    }

    public short getSid() {
        return 2204;
    }

    public byte[] getGuid() {
        byte[] byArray = new byte[16];
        System.arraycopy(this._rawData, 12, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean isCurrentSheet() {
        return Arrays.equals(this.getGuid(), BLANK_GUID);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append("HEADERFOOTER").append("] (0x");
        stringBuffer.append(Integer.toHexString(2204).toUpperCase(Locale.ROOT) + ")\n");
        stringBuffer.append("  rawData=").append(HexDump.toHex(this._rawData)).append("\n");
        stringBuffer.append("[/").append("HEADERFOOTER").append("]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        return this.cloneViaReserialise();
    }
}

