/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.SubRecord;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class FtPioGrbitSubRecord
extends SubRecord {
    public static final short sid = 8;
    public static final short length = 2;
    public static final int AUTO_PICT_BIT = 1;
    public static final int DDE_BIT = 2;
    public static final int PRINT_CALC_BIT = 4;
    public static final int ICON_BIT = 8;
    public static final int CTL_BIT = 16;
    public static final int PRSTM_BIT = 32;
    public static final int CAMERA_BIT = 128;
    public static final int DEFAULT_SIZE_BIT = 256;
    public static final int AUTO_LOAD_BIT = 512;
    private short flags = 0;

    public FtPioGrbitSubRecord() {
    }

    public FtPioGrbitSubRecord(LittleEndianInput littleEndianInput, int n) {
        if (n != 2) {
            throw new RecordFormatException("Unexpected size (" + n + ")");
        }
        this.flags = littleEndianInput.readShort();
    }

    public void setFlagByBit(int n, boolean bl) {
        this.flags = bl ? (short)(this.flags | n) : (short)(this.flags & (0xFFFF ^ n));
    }

    public boolean getFlagByBit(int n) {
        return (this.flags & n) != 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FtPioGrbit ]\n");
        stringBuffer.append("  size     = ").append(2).append("\n");
        stringBuffer.append("  flags    = ").append(HexDump.toHex(this.flags)).append("\n");
        stringBuffer.append("[/FtPioGrbit ]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(8);
        littleEndianOutput.writeShort(2);
        littleEndianOutput.writeShort(this.flags);
    }

    protected int getDataSize() {
        return 2;
    }

    public short getSid() {
        return 8;
    }

    public Object clone() {
        FtPioGrbitSubRecord ftPioGrbitSubRecord = new FtPioGrbitSubRecord();
        ftPioGrbitSubRecord.flags = this.flags;
        return ftPioGrbitSubRecord;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short s) {
        this.flags = s;
    }
}

