/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.CellRecord;
import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.ss.formula.Formula;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class FormulaRecord
extends CellRecord {
    public static final short sid = 6;
    private static int FIXED_SIZE = 14;
    private static final BitField alwaysCalc = BitFieldFactory.getInstance(1);
    private static final BitField calcOnLoad = BitFieldFactory.getInstance(2);
    private static final BitField sharedFormula = BitFieldFactory.getInstance(8);
    private double field_4_value;
    private short field_5_options;
    private int field_6_zero;
    private Formula field_8_parsed_expr;
    private SpecialCachedValue specialCachedValue;

    public FormulaRecord() {
        this.field_8_parsed_expr = Formula.create(Ptg.EMPTY_PTG_ARRAY);
    }

    public FormulaRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        RecordInputStream recordInputStream2 = recordInputStream;
        long l = recordInputStream2.readLong();
        this.field_5_options = recordInputStream2.readShort();
        this.specialCachedValue = SpecialCachedValue.create(l);
        if (this.specialCachedValue == null) {
            this.field_4_value = Double.longBitsToDouble(l);
        }
        this.field_6_zero = recordInputStream2.readInt();
        short s = recordInputStream2.readShort();
        int n = recordInputStream2.available();
        this.field_8_parsed_expr = Formula.read(s, recordInputStream2, n);
    }

    public void setValue(double d) {
        this.field_4_value = d;
        this.specialCachedValue = null;
    }

    public void setCachedResultTypeEmptyString() {
        this.specialCachedValue = SpecialCachedValue.createCachedEmptyValue();
    }

    public void setCachedResultTypeString() {
        this.specialCachedValue = SpecialCachedValue.createForString();
    }

    public void setCachedResultErrorCode(int n) {
        this.specialCachedValue = SpecialCachedValue.createCachedErrorCode(n);
    }

    public void setCachedResultBoolean(boolean bl) {
        this.specialCachedValue = SpecialCachedValue.createCachedBoolean(bl);
    }

    public boolean hasCachedResultString() {
        if (this.specialCachedValue == null) {
            return false;
        }
        return this.specialCachedValue.getTypeCode() == 0;
    }

    public int getCachedResultType() {
        if (this.specialCachedValue == null) {
            return 0;
        }
        return this.specialCachedValue.getValueType();
    }

    public boolean getCachedBooleanValue() {
        return this.specialCachedValue.getBooleanValue();
    }

    public int getCachedErrorValue() {
        return this.specialCachedValue.getErrorValue();
    }

    public void setOptions(short s) {
        this.field_5_options = s;
    }

    public double getValue() {
        return this.field_4_value;
    }

    public short getOptions() {
        return this.field_5_options;
    }

    public boolean isSharedFormula() {
        return sharedFormula.isSet(this.field_5_options);
    }

    public void setSharedFormula(boolean bl) {
        this.field_5_options = sharedFormula.setShortBoolean(this.field_5_options, bl);
    }

    public boolean isAlwaysCalc() {
        return alwaysCalc.isSet(this.field_5_options);
    }

    public void setAlwaysCalc(boolean bl) {
        this.field_5_options = alwaysCalc.setShortBoolean(this.field_5_options, bl);
    }

    public boolean isCalcOnLoad() {
        return calcOnLoad.isSet(this.field_5_options);
    }

    public void setCalcOnLoad(boolean bl) {
        this.field_5_options = calcOnLoad.setShortBoolean(this.field_5_options, bl);
    }

    public Ptg[] getParsedExpression() {
        return this.field_8_parsed_expr.getTokens();
    }

    public Formula getFormula() {
        return this.field_8_parsed_expr;
    }

    public void setParsedExpression(Ptg[] ptgArray) {
        this.field_8_parsed_expr = Formula.create(ptgArray);
    }

    public short getSid() {
        return 6;
    }

    protected int getValueDataSize() {
        return FIXED_SIZE + this.field_8_parsed_expr.getEncodedSize();
    }

    protected void serializeValue(LittleEndianOutput littleEndianOutput) {
        if (this.specialCachedValue == null) {
            littleEndianOutput.writeDouble(this.field_4_value);
        } else {
            this.specialCachedValue.serialize(littleEndianOutput);
        }
        littleEndianOutput.writeShort(this.getOptions());
        littleEndianOutput.writeInt(this.field_6_zero);
        this.field_8_parsed_expr.serialize(littleEndianOutput);
    }

    protected String getRecordName() {
        return "FORMULA";
    }

    protected void appendValueText(StringBuilder stringBuilder) {
        stringBuilder.append("  .value\t = ");
        if (this.specialCachedValue == null) {
            stringBuilder.append(this.field_4_value).append("\n");
        } else {
            stringBuilder.append(this.specialCachedValue.formatDebugString()).append("\n");
        }
        stringBuilder.append("  .options   = ").append(HexDump.shortToHex(this.getOptions())).append("\n");
        stringBuilder.append("    .alwaysCalc= ").append(this.isAlwaysCalc()).append("\n");
        stringBuilder.append("    .calcOnLoad= ").append(this.isCalcOnLoad()).append("\n");
        stringBuilder.append("    .shared    = ").append(this.isSharedFormula()).append("\n");
        stringBuilder.append("  .zero      = ").append(HexDump.intToHex(this.field_6_zero)).append("\n");
        Ptg[] ptgArray = this.field_8_parsed_expr.getTokens();
        for (int i = 0; i < ptgArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append("    Ptg[").append(i).append("]=");
            Ptg ptg = ptgArray[i];
            stringBuilder.append(ptg.toString()).append(ptg.getRVAType());
        }
    }

    public Object clone() {
        FormulaRecord formulaRecord = new FormulaRecord();
        this.copyBaseFields(formulaRecord);
        formulaRecord.field_4_value = this.field_4_value;
        formulaRecord.field_5_options = this.field_5_options;
        formulaRecord.field_6_zero = this.field_6_zero;
        formulaRecord.field_8_parsed_expr = this.field_8_parsed_expr;
        formulaRecord.specialCachedValue = this.specialCachedValue;
        return formulaRecord;
    }

    static final class SpecialCachedValue {
        private static final long BIT_MARKER = -281474976710656L;
        private static final int VARIABLE_DATA_LENGTH = 6;
        private static final int DATA_INDEX = 2;
        public static final int STRING = 0;
        public static final int BOOLEAN = 1;
        public static final int ERROR_CODE = 2;
        public static final int EMPTY = 3;
        private final byte[] _variableData;

        private SpecialCachedValue(byte[] byArray) {
            this._variableData = byArray;
        }

        public int getTypeCode() {
            return this._variableData[0];
        }

        public static SpecialCachedValue create(long l) {
            if ((0xFFFF000000000000L & l) != -281474976710656L) {
                return null;
            }
            byte[] byArray = new byte[6];
            long l2 = l;
            for (int i = 0; i < 6; ++i) {
                byArray[i] = (byte)l2;
                l2 >>= 8;
            }
            switch (byArray[0]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new RecordFormatException("Bad special value code (" + byArray[0] + ")");
                }
            }
            return new SpecialCachedValue(byArray);
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.write(this._variableData);
            littleEndianOutput.writeShort(65535);
        }

        public String formatDebugString() {
            return this.formatValue() + ' ' + HexDump.toHex(this._variableData);
        }

        private String formatValue() {
            int n = this.getTypeCode();
            switch (n) {
                case 0: {
                    return "<string>";
                }
                case 1: {
                    return this.getDataValue() == 0 ? "FALSE" : "TRUE";
                }
                case 2: {
                    return ErrorEval.getText(this.getDataValue());
                }
                case 3: {
                    return "<empty>";
                }
            }
            return "#error(type=" + n + ")#";
        }

        private int getDataValue() {
            return this._variableData[2];
        }

        public static SpecialCachedValue createCachedEmptyValue() {
            return SpecialCachedValue.create(3, 0);
        }

        public static SpecialCachedValue createForString() {
            return SpecialCachedValue.create(0, 0);
        }

        public static SpecialCachedValue createCachedBoolean(boolean bl) {
            return SpecialCachedValue.create(1, bl ? 1 : 0);
        }

        public static SpecialCachedValue createCachedErrorCode(int n) {
            return SpecialCachedValue.create(2, n);
        }

        private static SpecialCachedValue create(int n, int n2) {
            byte[] byArray = new byte[]{(byte)n, 0, (byte)n2, 0, 0, 0};
            return new SpecialCachedValue(byArray);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append('[').append(this.formatValue()).append(']');
            return stringBuffer.toString();
        }

        public int getValueType() {
            int n = this.getTypeCode();
            switch (n) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 5;
                }
                case 3: {
                    return 1;
                }
            }
            throw new IllegalStateException("Unexpected type id (" + n + ")");
        }

        public boolean getBooleanValue() {
            if (this.getTypeCode() != 1) {
                throw new IllegalStateException("Not a boolean cached value - " + this.formatValue());
            }
            return this.getDataValue() != 0;
        }

        public int getErrorValue() {
            if (this.getTypeCode() != 2) {
                throw new IllegalStateException("Not an error cached value - " + this.formatValue());
            }
            return this.getDataValue();
        }
    }
}

