/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.StringUtil;

public final class FontRecord
extends StandardRecord {
    public static final short sid = 49;
    public static final short SS_NONE = 0;
    public static final short SS_SUPER = 1;
    public static final short SS_SUB = 2;
    public static final byte U_NONE = 0;
    public static final byte U_SINGLE = 1;
    public static final byte U_DOUBLE = 2;
    public static final byte U_SINGLE_ACCOUNTING = 33;
    public static final byte U_DOUBLE_ACCOUNTING = 34;
    private short field_1_font_height;
    private short field_2_attributes;
    private static final BitField italic = BitFieldFactory.getInstance(2);
    private static final BitField strikeout = BitFieldFactory.getInstance(8);
    private static final BitField macoutline = BitFieldFactory.getInstance(16);
    private static final BitField macshadow = BitFieldFactory.getInstance(32);
    private short field_3_color_palette_index;
    private short field_4_bold_weight;
    private short field_5_super_sub_script;
    private byte field_6_underline;
    private byte field_7_family;
    private byte field_8_charset;
    private byte field_9_zero = 0;
    private String field_11_font_name;

    public FontRecord() {
    }

    public FontRecord(RecordInputStream recordInputStream) {
        this.field_1_font_height = recordInputStream.readShort();
        this.field_2_attributes = recordInputStream.readShort();
        this.field_3_color_palette_index = recordInputStream.readShort();
        this.field_4_bold_weight = recordInputStream.readShort();
        this.field_5_super_sub_script = recordInputStream.readShort();
        this.field_6_underline = recordInputStream.readByte();
        this.field_7_family = recordInputStream.readByte();
        this.field_8_charset = recordInputStream.readByte();
        this.field_9_zero = recordInputStream.readByte();
        int n = recordInputStream.readUByte();
        int n2 = recordInputStream.readUByte();
        this.field_11_font_name = n > 0 ? (n2 == 0 ? recordInputStream.readCompressedUnicode(n) : recordInputStream.readUnicodeLEString(n)) : "";
    }

    public void setFontHeight(short s) {
        this.field_1_font_height = s;
    }

    public void setAttributes(short s) {
        this.field_2_attributes = s;
    }

    public void setItalic(boolean bl) {
        this.field_2_attributes = italic.setShortBoolean(this.field_2_attributes, bl);
    }

    public void setStrikeout(boolean bl) {
        this.field_2_attributes = strikeout.setShortBoolean(this.field_2_attributes, bl);
    }

    public void setMacoutline(boolean bl) {
        this.field_2_attributes = macoutline.setShortBoolean(this.field_2_attributes, bl);
    }

    public void setMacshadow(boolean bl) {
        this.field_2_attributes = macshadow.setShortBoolean(this.field_2_attributes, bl);
    }

    public void setColorPaletteIndex(short s) {
        this.field_3_color_palette_index = s;
    }

    public void setBoldWeight(short s) {
        this.field_4_bold_weight = s;
    }

    public void setSuperSubScript(short s) {
        this.field_5_super_sub_script = s;
    }

    public void setUnderline(byte by) {
        this.field_6_underline = by;
    }

    public void setFamily(byte by) {
        this.field_7_family = by;
    }

    public void setCharset(byte by) {
        this.field_8_charset = by;
    }

    public void setFontName(String string) {
        this.field_11_font_name = string;
    }

    public short getFontHeight() {
        return this.field_1_font_height;
    }

    public short getAttributes() {
        return this.field_2_attributes;
    }

    public boolean isItalic() {
        return italic.isSet(this.field_2_attributes);
    }

    public boolean isStruckout() {
        return strikeout.isSet(this.field_2_attributes);
    }

    public boolean isMacoutlined() {
        return macoutline.isSet(this.field_2_attributes);
    }

    public boolean isMacshadowed() {
        return macshadow.isSet(this.field_2_attributes);
    }

    public short getColorPaletteIndex() {
        return this.field_3_color_palette_index;
    }

    public short getBoldWeight() {
        return this.field_4_bold_weight;
    }

    public short getSuperSubScript() {
        return this.field_5_super_sub_script;
    }

    public byte getUnderline() {
        return this.field_6_underline;
    }

    public byte getFamily() {
        return this.field_7_family;
    }

    public byte getCharset() {
        return this.field_8_charset;
    }

    public String getFontName() {
        return this.field_11_font_name;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FONT]\n");
        stringBuffer.append("    .fontheight    = ").append(HexDump.shortToHex(this.getFontHeight())).append("\n");
        stringBuffer.append("    .attributes    = ").append(HexDump.shortToHex(this.getAttributes())).append("\n");
        stringBuffer.append("       .italic     = ").append(this.isItalic()).append("\n");
        stringBuffer.append("       .strikout   = ").append(this.isStruckout()).append("\n");
        stringBuffer.append("       .macoutlined= ").append(this.isMacoutlined()).append("\n");
        stringBuffer.append("       .macshadowed= ").append(this.isMacshadowed()).append("\n");
        stringBuffer.append("    .colorpalette  = ").append(HexDump.shortToHex(this.getColorPaletteIndex())).append("\n");
        stringBuffer.append("    .boldweight    = ").append(HexDump.shortToHex(this.getBoldWeight())).append("\n");
        stringBuffer.append("    .supersubscript= ").append(HexDump.shortToHex(this.getSuperSubScript())).append("\n");
        stringBuffer.append("    .underline     = ").append(HexDump.byteToHex(this.getUnderline())).append("\n");
        stringBuffer.append("    .family        = ").append(HexDump.byteToHex(this.getFamily())).append("\n");
        stringBuffer.append("    .charset       = ").append(HexDump.byteToHex(this.getCharset())).append("\n");
        stringBuffer.append("    .fontname      = ").append(this.getFontName()).append("\n");
        stringBuffer.append("[/FONT]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getFontHeight());
        littleEndianOutput.writeShort(this.getAttributes());
        littleEndianOutput.writeShort(this.getColorPaletteIndex());
        littleEndianOutput.writeShort(this.getBoldWeight());
        littleEndianOutput.writeShort(this.getSuperSubScript());
        littleEndianOutput.writeByte(this.getUnderline());
        littleEndianOutput.writeByte(this.getFamily());
        littleEndianOutput.writeByte(this.getCharset());
        littleEndianOutput.writeByte(this.field_9_zero);
        int n = this.field_11_font_name.length();
        littleEndianOutput.writeByte(n);
        boolean bl = StringUtil.hasMultibyte(this.field_11_font_name);
        littleEndianOutput.writeByte(bl ? 1 : 0);
        if (n > 0) {
            if (bl) {
                StringUtil.putUnicodeLE(this.field_11_font_name, littleEndianOutput);
            } else {
                StringUtil.putCompressedUnicode(this.field_11_font_name, littleEndianOutput);
            }
        }
    }

    protected int getDataSize() {
        int n = 16;
        int n2 = this.field_11_font_name.length();
        if (n2 < 1) {
            return n;
        }
        boolean bl = StringUtil.hasMultibyte(this.field_11_font_name);
        return n + n2 * (bl ? 2 : 1);
    }

    public short getSid() {
        return 49;
    }

    public void cloneStyleFrom(FontRecord fontRecord) {
        this.field_1_font_height = fontRecord.field_1_font_height;
        this.field_2_attributes = fontRecord.field_2_attributes;
        this.field_3_color_palette_index = fontRecord.field_3_color_palette_index;
        this.field_4_bold_weight = fontRecord.field_4_bold_weight;
        this.field_5_super_sub_script = fontRecord.field_5_super_sub_script;
        this.field_6_underline = fontRecord.field_6_underline;
        this.field_7_family = fontRecord.field_7_family;
        this.field_8_charset = fontRecord.field_8_charset;
        this.field_9_zero = fontRecord.field_9_zero;
        this.field_11_font_name = fontRecord.field_11_font_name;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.field_11_font_name == null ? 0 : this.field_11_font_name.hashCode());
        n = 31 * n + this.field_1_font_height;
        n = 31 * n + this.field_2_attributes;
        n = 31 * n + this.field_3_color_palette_index;
        n = 31 * n + this.field_4_bold_weight;
        n = 31 * n + this.field_5_super_sub_script;
        n = 31 * n + this.field_6_underline;
        n = 31 * n + this.field_7_family;
        n = 31 * n + this.field_8_charset;
        n = 31 * n + this.field_9_zero;
        return n;
    }

    public boolean sameProperties(FontRecord fontRecord) {
        return this.field_1_font_height == fontRecord.field_1_font_height && this.field_2_attributes == fontRecord.field_2_attributes && this.field_3_color_palette_index == fontRecord.field_3_color_palette_index && this.field_4_bold_weight == fontRecord.field_4_bold_weight && this.field_5_super_sub_script == fontRecord.field_5_super_sub_script && this.field_6_underline == fontRecord.field_6_underline && this.field_7_family == fontRecord.field_7_family && this.field_8_charset == fontRecord.field_8_charset && this.field_9_zero == fontRecord.field_9_zero && FontRecord.stringEquals(this.field_11_font_name, fontRecord.field_11_font_name);
    }

    public boolean equals(Object object) {
        return object instanceof FontRecord ? this.sameProperties((FontRecord)object) : false;
    }

    private static boolean stringEquals(String string, String string2) {
        return string == string2 || string != null && string.equals(string2);
    }
}

