/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class DrawingSelectionRecord
extends StandardRecord {
    public static final short sid = 237;
    private OfficeArtRecordHeader _header;
    private int _cpsp;
    private int _dgslk;
    private int _spidFocus;
    private int[] _shapeIds;

    public DrawingSelectionRecord(RecordInputStream recordInputStream) {
        this._header = new OfficeArtRecordHeader(recordInputStream);
        this._cpsp = recordInputStream.readInt();
        this._dgslk = recordInputStream.readInt();
        this._spidFocus = recordInputStream.readInt();
        int n = recordInputStream.available() / 4;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = recordInputStream.readInt();
        }
        this._shapeIds = nArray;
    }

    public short getSid() {
        return 237;
    }

    protected int getDataSize() {
        return 20 + this._shapeIds.length * 4;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        this._header.serialize(littleEndianOutput);
        littleEndianOutput.writeInt(this._cpsp);
        littleEndianOutput.writeInt(this._dgslk);
        littleEndianOutput.writeInt(this._spidFocus);
        for (int i = 0; i < this._shapeIds.length; ++i) {
            littleEndianOutput.writeInt(this._shapeIds[i]);
        }
    }

    public Object clone() {
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[MSODRAWINGSELECTION]\n");
        stringBuffer.append("    .rh       =(").append(this._header.debugFormatAsString()).append(")\n");
        stringBuffer.append("    .cpsp     =").append(HexDump.intToHex(this._cpsp)).append('\n');
        stringBuffer.append("    .dgslk    =").append(HexDump.intToHex(this._dgslk)).append('\n');
        stringBuffer.append("    .spidFocus=").append(HexDump.intToHex(this._spidFocus)).append('\n');
        stringBuffer.append("    .shapeIds =(");
        for (int i = 0; i < this._shapeIds.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(HexDump.intToHex(this._shapeIds[i]));
        }
        stringBuffer.append(")\n");
        stringBuffer.append("[/MSODRAWINGSELECTION]\n");
        return stringBuffer.toString();
    }

    private static final class OfficeArtRecordHeader {
        public static final int ENCODED_SIZE = 8;
        private final int _verAndInstance;
        private final int _type;
        private final int _length;

        public OfficeArtRecordHeader(LittleEndianInput littleEndianInput) {
            this._verAndInstance = littleEndianInput.readUShort();
            this._type = littleEndianInput.readUShort();
            this._length = littleEndianInput.readInt();
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeShort(this._verAndInstance);
            littleEndianOutput.writeShort(this._type);
            littleEndianOutput.writeInt(this._length);
        }

        public String debugFormatAsString() {
            StringBuffer stringBuffer = new StringBuffer(32);
            stringBuffer.append("ver+inst=").append(HexDump.shortToHex(this._verAndInstance));
            stringBuffer.append(" type=").append(HexDump.shortToHex(this._type));
            stringBuffer.append(" len=").append(HexDump.intToHex(this._length));
            return stringBuffer.toString();
        }
    }
}

