/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.hssf.record.common.UnicodeString;
import ai2.org.apache.poi.ss.formula.Formula;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.CellRangeAddressList;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.StringUtil;

public final class DVRecord
extends StandardRecord {
    public static final short sid = 446;
    private static final UnicodeString NULL_TEXT_STRING = new UnicodeString("\u0000");
    private int _option_flags;
    private UnicodeString _promptTitle;
    private UnicodeString _errorTitle;
    private UnicodeString _promptText;
    private UnicodeString _errorText;
    private short _not_used_1 = (short)16352;
    private Formula _formula1;
    private short _not_used_2 = 0;
    private Formula _formula2;
    private CellRangeAddressList _regions;
    private static final BitField opt_data_type = new BitField(15);
    private static final BitField opt_error_style = new BitField(112);
    private static final BitField opt_string_list_formula = new BitField(128);
    private static final BitField opt_empty_cell_allowed = new BitField(256);
    private static final BitField opt_suppress_dropdown_arrow = new BitField(512);
    private static final BitField opt_show_prompt_on_cell_selected = new BitField(262144);
    private static final BitField opt_show_error_on_invalid_value = new BitField(524288);
    private static final BitField opt_condition_operator = new BitField(0x700000);

    public DVRecord(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, String string2, boolean bl5, String string3, String string4, Ptg[] ptgArray, Ptg[] ptgArray2, CellRangeAddressList cellRangeAddressList) {
        int n4 = 0;
        n4 = opt_data_type.setValue(n4, n);
        n4 = opt_condition_operator.setValue(n4, n2);
        n4 = opt_error_style.setValue(n4, n3);
        n4 = opt_empty_cell_allowed.setBoolean(n4, bl);
        n4 = opt_suppress_dropdown_arrow.setBoolean(n4, bl2);
        n4 = opt_string_list_formula.setBoolean(n4, bl3);
        n4 = opt_show_prompt_on_cell_selected.setBoolean(n4, bl4);
        this._option_flags = n4 = opt_show_error_on_invalid_value.setBoolean(n4, bl5);
        this._promptTitle = DVRecord.resolveTitleText(string);
        this._promptText = DVRecord.resolveTitleText(string2);
        this._errorTitle = DVRecord.resolveTitleText(string3);
        this._errorText = DVRecord.resolveTitleText(string4);
        this._formula1 = Formula.create(ptgArray);
        this._formula2 = Formula.create(ptgArray2);
        this._regions = cellRangeAddressList;
    }

    public DVRecord(RecordInputStream recordInputStream) {
        this._option_flags = recordInputStream.readInt();
        this._promptTitle = DVRecord.readUnicodeString(recordInputStream);
        this._errorTitle = DVRecord.readUnicodeString(recordInputStream);
        this._promptText = DVRecord.readUnicodeString(recordInputStream);
        this._errorText = DVRecord.readUnicodeString(recordInputStream);
        int n = recordInputStream.readUShort();
        this._not_used_1 = recordInputStream.readShort();
        this._formula1 = Formula.read(n, recordInputStream);
        int n2 = recordInputStream.readUShort();
        this._not_used_2 = recordInputStream.readShort();
        this._formula2 = Formula.read(n2, recordInputStream);
        this._regions = new CellRangeAddressList(recordInputStream);
    }

    public int getDataType() {
        return opt_data_type.getValue(this._option_flags);
    }

    public int getErrorStyle() {
        return opt_error_style.getValue(this._option_flags);
    }

    public boolean getListExplicitFormula() {
        return opt_string_list_formula.isSet(this._option_flags);
    }

    public boolean getEmptyCellAllowed() {
        return opt_empty_cell_allowed.isSet(this._option_flags);
    }

    public boolean getSuppressDropdownArrow() {
        return opt_suppress_dropdown_arrow.isSet(this._option_flags);
    }

    public boolean getShowPromptOnCellSelected() {
        return opt_show_prompt_on_cell_selected.isSet(this._option_flags);
    }

    public boolean getShowErrorOnInvalidValue() {
        return opt_show_error_on_invalid_value.isSet(this._option_flags);
    }

    public int getConditionOperator() {
        return opt_condition_operator.getValue(this._option_flags);
    }

    public String getPromptTitle() {
        return DVRecord.resolveTitleString(this._promptTitle);
    }

    public String getErrorTitle() {
        return DVRecord.resolveTitleString(this._errorTitle);
    }

    public String getPromptText() {
        return DVRecord.resolveTitleString(this._promptText);
    }

    public String getErrorText() {
        return DVRecord.resolveTitleString(this._errorText);
    }

    public Ptg[] getFormula1() {
        return Formula.getTokens(this._formula1);
    }

    public Ptg[] getFormula2() {
        return Formula.getTokens(this._formula2);
    }

    public CellRangeAddressList getCellRangeAddress() {
        return this._regions;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DV]\n");
        stringBuffer.append(" options=").append(Integer.toHexString(this._option_flags));
        stringBuffer.append(" title-prompt=").append(DVRecord.formatTextTitle(this._promptTitle));
        stringBuffer.append(" title-error=").append(DVRecord.formatTextTitle(this._errorTitle));
        stringBuffer.append(" text-prompt=").append(DVRecord.formatTextTitle(this._promptText));
        stringBuffer.append(" text-error=").append(DVRecord.formatTextTitle(this._errorText));
        stringBuffer.append("\n");
        DVRecord.appendFormula(stringBuffer, "Formula 1:", this._formula1);
        DVRecord.appendFormula(stringBuffer, "Formula 2:", this._formula2);
        stringBuffer.append("Regions: ");
        int n = this._regions.countRanges();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            CellRangeAddress cellRangeAddress = this._regions.getCellRangeAddress(i);
            stringBuffer.append('(').append(cellRangeAddress.getFirstRow()).append(',').append(cellRangeAddress.getLastRow());
            stringBuffer.append(',').append(cellRangeAddress.getFirstColumn()).append(',').append(cellRangeAddress.getLastColumn()).append(')');
        }
        stringBuffer.append("\n");
        stringBuffer.append("[/DV]");
        return stringBuffer.toString();
    }

    private static String formatTextTitle(UnicodeString unicodeString) {
        String string = unicodeString.getString();
        if (string.length() == 1 && string.charAt(0) == '\u0000') {
            return "'\\0'";
        }
        return string;
    }

    private static void appendFormula(StringBuffer stringBuffer, String string, Formula formula) {
        stringBuffer.append(string);
        if (formula == null) {
            stringBuffer.append("<empty>\n");
            return;
        }
        Ptg[] ptgArray = formula.getTokens();
        stringBuffer.append('\n');
        for (int i = 0; i < ptgArray.length; ++i) {
            stringBuffer.append('\t').append(ptgArray[i].toString()).append('\n');
        }
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this._option_flags);
        DVRecord.serializeUnicodeString(this._promptTitle, littleEndianOutput);
        DVRecord.serializeUnicodeString(this._errorTitle, littleEndianOutput);
        DVRecord.serializeUnicodeString(this._promptText, littleEndianOutput);
        DVRecord.serializeUnicodeString(this._errorText, littleEndianOutput);
        littleEndianOutput.writeShort(this._formula1.getEncodedTokenSize());
        littleEndianOutput.writeShort(this._not_used_1);
        this._formula1.serializeTokens(littleEndianOutput);
        littleEndianOutput.writeShort(this._formula2.getEncodedTokenSize());
        littleEndianOutput.writeShort(this._not_used_2);
        this._formula2.serializeTokens(littleEndianOutput);
        this._regions.serialize(littleEndianOutput);
    }

    private static UnicodeString resolveTitleText(String string) {
        if (string == null || string.length() < 1) {
            return NULL_TEXT_STRING;
        }
        return new UnicodeString(string);
    }

    private static String resolveTitleString(UnicodeString unicodeString) {
        if (unicodeString == null || unicodeString.equals(NULL_TEXT_STRING)) {
            return null;
        }
        return unicodeString.getString();
    }

    private static UnicodeString readUnicodeString(RecordInputStream recordInputStream) {
        return new UnicodeString(recordInputStream);
    }

    private static void serializeUnicodeString(UnicodeString unicodeString, LittleEndianOutput littleEndianOutput) {
        StringUtil.writeUnicodeString(littleEndianOutput, unicodeString.getString());
    }

    private static int getUnicodeStringSize(UnicodeString unicodeString) {
        String string = unicodeString.getString();
        return 3 + string.length() * (StringUtil.hasMultibyte(string) ? 2 : 1);
    }

    protected int getDataSize() {
        int n = 12;
        n += DVRecord.getUnicodeStringSize(this._promptTitle);
        n += DVRecord.getUnicodeStringSize(this._errorTitle);
        n += DVRecord.getUnicodeStringSize(this._promptText);
        n += DVRecord.getUnicodeStringSize(this._errorText);
        n += this._formula1.getEncodedTokenSize();
        n += this._formula2.getEncodedTokenSize();
        return n += this._regions.getSize();
    }

    public short getSid() {
        return 446;
    }

    public Object clone() {
        return this.cloneViaReserialise();
    }
}

