/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.StringUtil;
import java.util.Arrays;

public class DConRefRecord
extends StandardRecord {
    public static final short sid = 81;
    private int firstRow;
    private int lastRow;
    private int firstCol;
    private int lastCol;
    private int charCount;
    private int charType;
    private byte[] path;
    private byte[] _unused;

    public DConRefRecord(byte[] byArray) {
        int n = 0;
        if (LittleEndian.getShort(byArray, n) != 81) {
            throw new RecordFormatException("incompatible sid.");
        }
        n += 2;
        this.firstRow = LittleEndian.getUShort(byArray, n += 2);
        this.lastRow = LittleEndian.getUShort(byArray, n += 2);
        this.firstCol = LittleEndian.getUByte(byArray, n += 2);
        this.lastCol = LittleEndian.getUByte(byArray, ++n);
        this.charCount = LittleEndian.getUShort(byArray, ++n);
        n += 2;
        if (this.charCount < 2) {
            throw new RecordFormatException("Character count must be >= 2");
        }
        this.charType = LittleEndian.getUByte(byArray, n);
        int n2 = this.charCount * ((this.charType & 1) + 1);
        this.path = LittleEndian.getByteArray(byArray, ++n, n2);
        n += n2;
        if (this.path[0] == 2) {
            this._unused = LittleEndian.getByteArray(byArray, n, this.charType + 1);
        }
    }

    public DConRefRecord(RecordInputStream recordInputStream) {
        if (recordInputStream.getSid() != 81) {
            throw new RecordFormatException("Wrong sid: " + recordInputStream.getSid());
        }
        this.firstRow = recordInputStream.readUShort();
        this.lastRow = recordInputStream.readUShort();
        this.firstCol = recordInputStream.readUByte();
        this.lastCol = recordInputStream.readUByte();
        this.charCount = recordInputStream.readUShort();
        this.charType = recordInputStream.readUByte() & 1;
        int n = this.charCount * (this.charType + 1);
        this.path = new byte[n];
        recordInputStream.readFully(this.path);
        if (this.path[0] == 2) {
            this._unused = recordInputStream.readRemainder();
        }
    }

    protected int getDataSize() {
        int n = 9 + this.path.length;
        if (this.path[0] == 2) {
            n += this._unused.length;
        }
        return n;
    }

    protected void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.firstRow);
        littleEndianOutput.writeShort(this.lastRow);
        littleEndianOutput.writeByte(this.firstCol);
        littleEndianOutput.writeByte(this.lastCol);
        littleEndianOutput.writeShort(this.charCount);
        littleEndianOutput.writeByte(this.charType);
        littleEndianOutput.write(this.path);
        if (this.path[0] == 2) {
            littleEndianOutput.write(this._unused);
        }
    }

    public short getSid() {
        return 81;
    }

    public int getFirstColumn() {
        return this.firstCol;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public int getLastColumn() {
        return this.lastCol;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[DCONREF]\n");
        stringBuilder.append("    .ref\n");
        stringBuilder.append("        .firstrow   = ").append(this.firstRow).append("\n");
        stringBuilder.append("        .lastrow    = ").append(this.lastRow).append("\n");
        stringBuilder.append("        .firstcol   = ").append(this.firstCol).append("\n");
        stringBuilder.append("        .lastcol    = ").append(this.lastCol).append("\n");
        stringBuilder.append("    .cch            = ").append(this.charCount).append("\n");
        stringBuilder.append("    .stFile\n");
        stringBuilder.append("        .h          = ").append(this.charType).append("\n");
        stringBuilder.append("        .rgb        = ").append(this.getReadablePath()).append("\n");
        stringBuilder.append("[/DCONREF]\n");
        return stringBuilder.toString();
    }

    public byte[] getPath() {
        return Arrays.copyOf(this.path, this.path.length);
    }

    public String getReadablePath() {
        if (this.path != null) {
            int n;
            for (n = 1; this.path[n] < 32 && n < this.path.length; ++n) {
            }
            String string = new String(Arrays.copyOfRange(this.path, n, this.path.length), StringUtil.UTF8);
            string = string.replaceAll("\u0003", "/");
            return string;
        }
        return null;
    }

    public boolean isExternalRef() {
        return this.path[0] == 1;
    }
}

