/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.CFRuleBase;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.ss.formula.Formula;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.util.LittleEndianOutput;
import java.util.Arrays;

public final class CFRuleRecord
extends CFRuleBase {
    public static final short sid = 433;

    private CFRuleRecord(byte by, byte by2) {
        super(by, by2);
        this.setDefaults();
    }

    private CFRuleRecord(byte by, byte by2, Ptg[] ptgArray, Ptg[] ptgArray2) {
        super(by, by2, ptgArray, ptgArray2);
        this.setDefaults();
    }

    private void setDefaults() {
        this.formatting_options = modificationBits.setValue(this.formatting_options, -1);
        this.formatting_options = fmtBlockBits.setValue(this.formatting_options, 0);
        this.formatting_options = undocumented.clear(this.formatting_options);
        this.formatting_not_used = (short)-32766;
        this._fontFormatting = null;
        this._borderFormatting = null;
        this._patternFormatting = null;
    }

    public static CFRuleRecord create(HSSFSheet hSSFSheet, String string) {
        Ptg[] ptgArray = CFRuleRecord.parseFormula(string, hSSFSheet);
        return new CFRuleRecord(2, 0, ptgArray, null);
    }

    public static CFRuleRecord create(HSSFSheet hSSFSheet, byte by, String string, String string2) {
        Ptg[] ptgArray = CFRuleRecord.parseFormula(string, hSSFSheet);
        Ptg[] ptgArray2 = CFRuleRecord.parseFormula(string2, hSSFSheet);
        return new CFRuleRecord(1, by, ptgArray, ptgArray2);
    }

    public CFRuleRecord(RecordInputStream recordInputStream) {
        this.setConditionType(recordInputStream.readByte());
        this.setComparisonOperation(recordInputStream.readByte());
        int n = recordInputStream.readUShort();
        int n2 = recordInputStream.readUShort();
        this.readFormatOptions(recordInputStream);
        this.setFormula1(Formula.read(n, recordInputStream));
        this.setFormula2(Formula.read(n2, recordInputStream));
    }

    public short getSid() {
        return 433;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        int n = CFRuleRecord.getFormulaSize(this.getFormula1());
        int n2 = CFRuleRecord.getFormulaSize(this.getFormula2());
        littleEndianOutput.writeByte(this.getConditionType());
        littleEndianOutput.writeByte(this.getComparisonOperation());
        littleEndianOutput.writeShort(n);
        littleEndianOutput.writeShort(n2);
        this.serializeFormattingBlock(littleEndianOutput);
        this.getFormula1().serializeTokens(littleEndianOutput);
        this.getFormula2().serializeTokens(littleEndianOutput);
    }

    protected int getDataSize() {
        return 6 + this.getFormattingBlockSize() + CFRuleRecord.getFormulaSize(this.getFormula1()) + CFRuleRecord.getFormulaSize(this.getFormula2());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CFRULE]\n");
        stringBuffer.append("    .condition_type   =").append(this.getConditionType()).append("\n");
        stringBuffer.append("    OPTION FLAGS=0x").append(Integer.toHexString(this.getOptions())).append("\n");
        if (this.containsFontFormattingBlock()) {
            stringBuffer.append(this._fontFormatting.toString()).append("\n");
        }
        if (this.containsBorderFormattingBlock()) {
            stringBuffer.append(this._borderFormatting.toString()).append("\n");
        }
        if (this.containsPatternFormattingBlock()) {
            stringBuffer.append(this._patternFormatting.toString()).append("\n");
        }
        stringBuffer.append("    Formula 1 =").append(Arrays.toString(this.getFormula1().getTokens())).append("\n");
        stringBuffer.append("    Formula 2 =").append(Arrays.toString(this.getFormula2().getTokens())).append("\n");
        stringBuffer.append("[/CFRULE]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        CFRuleRecord cFRuleRecord = new CFRuleRecord(this.getConditionType(), this.getComparisonOperation());
        super.copyTo(cFRuleRecord);
        return cFRuleRecord;
    }
}

