/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.hssf.record.cf.CellRangeUtil;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.CellRangeAddressList;
import ai2.org.apache.poi.util.LittleEndianOutput;

public abstract class CFHeaderBase
extends StandardRecord {
    private int field_1_numcf;
    private int field_2_need_recalculation_and_id;
    private CellRangeAddress field_3_enclosing_cell_range;
    private CellRangeAddressList field_4_cell_ranges;

    protected CFHeaderBase() {
    }

    protected CFHeaderBase(CellRangeAddress[] cellRangeAddressArray, int n) {
        CellRangeAddress[] cellRangeAddressArray2 = cellRangeAddressArray;
        CellRangeAddress[] cellRangeAddressArray3 = CellRangeUtil.mergeCellRanges(cellRangeAddressArray2);
        this.setCellRanges(cellRangeAddressArray3);
        this.field_1_numcf = n;
    }

    protected void createEmpty() {
        this.field_3_enclosing_cell_range = new CellRangeAddress(0, 0, 0, 0);
        this.field_4_cell_ranges = new CellRangeAddressList();
    }

    protected void read(RecordInputStream recordInputStream) {
        this.field_1_numcf = recordInputStream.readShort();
        this.field_2_need_recalculation_and_id = recordInputStream.readShort();
        this.field_3_enclosing_cell_range = new CellRangeAddress(recordInputStream);
        this.field_4_cell_ranges = new CellRangeAddressList(recordInputStream);
    }

    public int getNumberOfConditionalFormats() {
        return this.field_1_numcf;
    }

    public void setNumberOfConditionalFormats(int n) {
        this.field_1_numcf = n;
    }

    public boolean getNeedRecalculation() {
        return this.field_2_need_recalculation_and_id % 2 == 1;
    }

    public void setNeedRecalculation(boolean bl) {
        if (bl == this.getNeedRecalculation()) {
            return;
        }
        this.field_2_need_recalculation_and_id = bl ? ++this.field_2_need_recalculation_and_id : --this.field_2_need_recalculation_and_id;
    }

    public int getID() {
        return this.field_2_need_recalculation_and_id >> 1;
    }

    public void setID(int n) {
        boolean bl = this.getNeedRecalculation();
        this.field_2_need_recalculation_and_id = n << 1;
        if (bl) {
            ++this.field_2_need_recalculation_and_id;
        }
    }

    public CellRangeAddress getEnclosingCellRange() {
        return this.field_3_enclosing_cell_range;
    }

    public void setEnclosingCellRange(CellRangeAddress cellRangeAddress) {
        this.field_3_enclosing_cell_range = cellRangeAddress;
    }

    public void setCellRanges(CellRangeAddress[] cellRangeAddressArray) {
        if (cellRangeAddressArray == null) {
            throw new IllegalArgumentException("cellRanges must not be null");
        }
        CellRangeAddressList cellRangeAddressList = new CellRangeAddressList();
        CellRangeAddress cellRangeAddress = null;
        for (int i = 0; i < cellRangeAddressArray.length; ++i) {
            CellRangeAddress cellRangeAddress2 = cellRangeAddressArray[i];
            cellRangeAddress = CellRangeUtil.createEnclosingCellRange(cellRangeAddress2, cellRangeAddress);
            cellRangeAddressList.addCellRangeAddress(cellRangeAddress2);
        }
        this.field_3_enclosing_cell_range = cellRangeAddress;
        this.field_4_cell_ranges = cellRangeAddressList;
    }

    public CellRangeAddress[] getCellRanges() {
        return this.field_4_cell_ranges.getCellRangeAddresses();
    }

    protected abstract String getRecordName();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(this.getRecordName()).append("]\n");
        stringBuffer.append("\t.numCF             = ").append(this.getNumberOfConditionalFormats()).append("\n");
        stringBuffer.append("\t.needRecalc        = ").append(this.getNeedRecalculation()).append("\n");
        stringBuffer.append("\t.id                = ").append(this.getID()).append("\n");
        stringBuffer.append("\t.enclosingCellRange= ").append(this.getEnclosingCellRange()).append("\n");
        stringBuffer.append("\t.cfranges=[");
        for (int i = 0; i < this.field_4_cell_ranges.countRanges(); ++i) {
            stringBuffer.append(i == 0 ? "" : ",").append(this.field_4_cell_ranges.getCellRangeAddress(i).toString());
        }
        stringBuffer.append("]\n");
        stringBuffer.append("[/").append(this.getRecordName()).append("]\n");
        return stringBuffer.toString();
    }

    protected int getDataSize() {
        return 12 + this.field_4_cell_ranges.getSize();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_numcf);
        littleEndianOutput.writeShort(this.field_2_need_recalculation_and_id);
        this.field_3_enclosing_cell_range.serialize(littleEndianOutput);
        this.field_4_cell_ranges.serialize(littleEndianOutput);
    }

    protected void copyTo(CFHeaderBase cFHeaderBase) {
        cFHeaderBase.field_1_numcf = this.field_1_numcf;
        cFHeaderBase.field_2_need_recalculation_and_id = this.field_2_need_recalculation_and_id;
        cFHeaderBase.field_3_enclosing_cell_range = this.field_3_enclosing_cell_range.copy();
        cFHeaderBase.field_4_cell_ranges = this.field_4_cell_ranges.copy();
    }
}

