/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.SharedValueRecordBase;
import ai2.org.apache.poi.hssf.util.CellRangeAddress8Bit;
import ai2.org.apache.poi.ss.formula.Formula;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class ArrayRecord
extends SharedValueRecordBase {
    public static final short sid = 545;
    private static final int OPT_ALWAYS_RECALCULATE = 1;
    private static final int OPT_CALCULATE_ON_OPEN = 2;
    private int _options;
    private int _field3notUsed;
    private Formula _formula;

    public ArrayRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        this._options = recordInputStream.readUShort();
        this._field3notUsed = recordInputStream.readInt();
        int n = recordInputStream.readUShort();
        int n2 = recordInputStream.available();
        this._formula = Formula.read(n, recordInputStream, n2);
    }

    public ArrayRecord(Formula formula, CellRangeAddress8Bit cellRangeAddress8Bit) {
        super(cellRangeAddress8Bit);
        this._options = 0;
        this._field3notUsed = 0;
        this._formula = formula;
    }

    public boolean isAlwaysRecalculate() {
        return (this._options & 1) != 0;
    }

    public boolean isCalculateOnOpen() {
        return (this._options & 2) != 0;
    }

    public Ptg[] getFormulaTokens() {
        return this._formula.getTokens();
    }

    protected int getExtraDataSize() {
        return 6 + this._formula.getEncodedSize();
    }

    protected void serializeExtraData(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._options);
        littleEndianOutput.writeInt(this._field3notUsed);
        this._formula.serialize(littleEndianOutput);
    }

    public short getSid() {
        return 545;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(" [ARRAY]\n");
        stringBuffer.append(" range=").append(this.getRange().toString()).append("\n");
        stringBuffer.append(" options=").append(HexDump.shortToHex(this._options)).append("\n");
        stringBuffer.append(" notUsed=").append(HexDump.intToHex(this._field3notUsed)).append("\n");
        stringBuffer.append(" formula:").append("\n");
        Ptg[] ptgArray = this._formula.getTokens();
        for (int i = 0; i < ptgArray.length; ++i) {
            Ptg ptg = ptgArray[i];
            stringBuffer.append(ptg.toString()).append(ptg.getRVAType()).append("\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        ArrayRecord arrayRecord = new ArrayRecord(this._formula.copy(), this.getRange());
        arrayRecord._options = this._options;
        arrayRecord._field3notUsed = this._field3notUsed;
        return arrayRecord;
    }
}

