/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.NullEscherSerializationListener;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.util.LazilyConcatenatedByteArray;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEscherHolderRecord
extends Record {
    private static boolean DESERIALISE;
    private List<EscherRecord> escherRecords;
    private LazilyConcatenatedByteArray rawDataContainer = new LazilyConcatenatedByteArray();

    public AbstractEscherHolderRecord() {
        this.escherRecords = new ArrayList<EscherRecord>();
    }

    public AbstractEscherHolderRecord(RecordInputStream recordInputStream) {
        this.escherRecords = new ArrayList<EscherRecord>();
        if (!DESERIALISE) {
            this.rawDataContainer.concatenate(recordInputStream.readRemainder());
        } else {
            byte[] byArray = recordInputStream.readAllContinuedRemainder();
            this.convertToEscherRecords(0, byArray.length, byArray);
        }
    }

    protected void convertRawBytesToEscherRecords() {
        if (!DESERIALISE) {
            byte[] byArray = this.getRawData();
            this.convertToEscherRecords(0, byArray.length, byArray);
        }
    }

    private void convertToEscherRecords(int n, int n2, byte[] byArray) {
        int n3;
        this.escherRecords.clear();
        DefaultEscherRecordFactory defaultEscherRecordFactory = new DefaultEscherRecordFactory();
        for (int i = n; i < n + n2; i += n3) {
            EscherRecord escherRecord = defaultEscherRecordFactory.createRecord(byArray, i);
            n3 = escherRecord.fillFields(byArray, i, defaultEscherRecordFactory);
            this.escherRecords.add(escherRecord);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append('[' + this.getRecordName() + ']' + string);
        if (this.escherRecords.size() == 0) {
            stringBuffer.append("No Escher Records Decoded" + string);
        }
        for (EscherRecord escherRecord : this.escherRecords) {
            stringBuffer.append(escherRecord.toString());
        }
        stringBuffer.append("[/" + this.getRecordName() + ']' + string);
        return stringBuffer.toString();
    }

    protected abstract String getRecordName();

    @Override
    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, this.getSid());
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        byte[] byArray2 = this.getRawData();
        if (this.escherRecords.size() == 0 && byArray2 != null) {
            LittleEndian.putShort(byArray, 0 + n, this.getSid());
            LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
            System.arraycopy(byArray2, 0, byArray, 4 + n, byArray2.length);
            return byArray2.length + 4;
        }
        LittleEndian.putShort(byArray, 0 + n, this.getSid());
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        int n2 = n + 4;
        for (EscherRecord escherRecord : this.escherRecords) {
            n2 += escherRecord.serialize(n2, byArray, new NullEscherSerializationListener());
        }
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        byte[] byArray = this.getRawData();
        if (this.escherRecords.size() == 0 && byArray != null) {
            return byArray.length;
        }
        int n = 0;
        for (EscherRecord escherRecord : this.escherRecords) {
            n += escherRecord.getRecordSize();
        }
        return n;
    }

    @Override
    public abstract short getSid();

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    public void addEscherRecord(int n, EscherRecord escherRecord) {
        this.escherRecords.add(n, escherRecord);
    }

    public boolean addEscherRecord(EscherRecord escherRecord) {
        return this.escherRecords.add(escherRecord);
    }

    public List<EscherRecord> getEscherRecords() {
        return this.escherRecords;
    }

    public void clearEscherRecords() {
        this.escherRecords.clear();
    }

    public EscherContainerRecord getEscherContainer() {
        for (EscherRecord escherRecord : this.escherRecords) {
            if (!(escherRecord instanceof EscherContainerRecord)) continue;
            return (EscherContainerRecord)escherRecord;
        }
        return null;
    }

    public EscherRecord findFirstWithId(short s) {
        return this.findFirstWithId(s, this.getEscherRecords());
    }

    private EscherRecord findFirstWithId(short s, List<EscherRecord> list) {
        for (EscherRecord escherRecord : list) {
            if (escherRecord.getRecordId() != s) continue;
            return escherRecord;
        }
        for (EscherRecord escherRecord : list) {
            EscherRecord escherRecord2;
            if (!escherRecord.isContainerRecord() || (escherRecord2 = this.findFirstWithId(s, escherRecord.getChildRecords())) == null) continue;
            return escherRecord2;
        }
        return null;
    }

    public EscherRecord getEscherRecord(int n) {
        return this.escherRecords.get(n);
    }

    public void join(AbstractEscherHolderRecord abstractEscherHolderRecord) {
        this.rawDataContainer.concatenate(abstractEscherHolderRecord.getRawData());
    }

    public void processContinueRecord(byte[] byArray) {
        this.rawDataContainer.concatenate(byArray);
    }

    public byte[] getRawData() {
        return this.rawDataContainer.toArray();
    }

    public void setRawData(byte[] byArray) {
        this.rawDataContainer.clear();
        this.rawDataContainer.concatenate(byArray);
    }

    public void decode() {
        if (null == this.escherRecords || 0 == this.escherRecords.size()) {
            byte[] byArray = this.getRawData();
            this.convertToEscherRecords(0, byArray.length, byArray);
        }
    }

    static {
        try {
            DESERIALISE = System.getProperty("poi.deserialize.escher") != null;
        }
        catch (SecurityException securityException) {
            DESERIALISE = false;
        }
    }
}

