/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.model;

import ai2.org.apache.poi.ddf.AbstractEscherOptRecord;
import ai2.org.apache.poi.ddf.EscherBSERecord;
import ai2.org.apache.poi.ddf.EscherBoolProperty;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherDgRecord;
import ai2.org.apache.poi.ddf.EscherDggRecord;
import ai2.org.apache.poi.ddf.EscherOptRecord;
import ai2.org.apache.poi.ddf.EscherRGBProperty;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.ddf.EscherSplitMenuColorsRecord;
import ai2.org.apache.poi.hssf.model.DrawingManager2;
import ai2.org.apache.poi.hssf.model.InternalSheet;
import ai2.org.apache.poi.hssf.model.LinkTable;
import ai2.org.apache.poi.hssf.model.WorkbookRecordList;
import ai2.org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import ai2.org.apache.poi.hssf.record.BOFRecord;
import ai2.org.apache.poi.hssf.record.BackupRecord;
import ai2.org.apache.poi.hssf.record.BookBoolRecord;
import ai2.org.apache.poi.hssf.record.BoundSheetRecord;
import ai2.org.apache.poi.hssf.record.CodepageRecord;
import ai2.org.apache.poi.hssf.record.CountryRecord;
import ai2.org.apache.poi.hssf.record.DSFRecord;
import ai2.org.apache.poi.hssf.record.DateWindow1904Record;
import ai2.org.apache.poi.hssf.record.DrawingGroupRecord;
import ai2.org.apache.poi.hssf.record.EOFRecord;
import ai2.org.apache.poi.hssf.record.EscherAggregate;
import ai2.org.apache.poi.hssf.record.ExtSSTRecord;
import ai2.org.apache.poi.hssf.record.ExtendedFormatRecord;
import ai2.org.apache.poi.hssf.record.FileSharingRecord;
import ai2.org.apache.poi.hssf.record.FnGroupCountRecord;
import ai2.org.apache.poi.hssf.record.FontRecord;
import ai2.org.apache.poi.hssf.record.FormatRecord;
import ai2.org.apache.poi.hssf.record.HideObjRecord;
import ai2.org.apache.poi.hssf.record.HyperlinkRecord;
import ai2.org.apache.poi.hssf.record.InterfaceEndRecord;
import ai2.org.apache.poi.hssf.record.InterfaceHdrRecord;
import ai2.org.apache.poi.hssf.record.MMSRecord;
import ai2.org.apache.poi.hssf.record.NameCommentRecord;
import ai2.org.apache.poi.hssf.record.NameRecord;
import ai2.org.apache.poi.hssf.record.PaletteRecord;
import ai2.org.apache.poi.hssf.record.PasswordRecord;
import ai2.org.apache.poi.hssf.record.PasswordRev4Record;
import ai2.org.apache.poi.hssf.record.PrecisionRecord;
import ai2.org.apache.poi.hssf.record.ProtectRecord;
import ai2.org.apache.poi.hssf.record.ProtectionRev4Record;
import ai2.org.apache.poi.hssf.record.RecalcIdRecord;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RefreshAllRecord;
import ai2.org.apache.poi.hssf.record.SSTRecord;
import ai2.org.apache.poi.hssf.record.StyleRecord;
import ai2.org.apache.poi.hssf.record.TabIdRecord;
import ai2.org.apache.poi.hssf.record.UseSelFSRecord;
import ai2.org.apache.poi.hssf.record.WindowOneRecord;
import ai2.org.apache.poi.hssf.record.WindowProtectRecord;
import ai2.org.apache.poi.hssf.record.WriteAccessRecord;
import ai2.org.apache.poi.hssf.record.WriteProtectRecord;
import ai2.org.apache.poi.hssf.record.common.UnicodeString;
import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.ss.formula.EvaluationWorkbook;
import ai2.org.apache.poi.ss.formula.FormulaShifter;
import ai2.org.apache.poi.ss.formula.ptg.Area3DPtg;
import ai2.org.apache.poi.ss.formula.ptg.NameXPtg;
import ai2.org.apache.poi.ss.formula.ptg.OperandPtg;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.formula.ptg.Ref3DPtg;
import ai2.org.apache.poi.ss.formula.udf.UDFFinder;
import ai2.org.apache.poi.ss.usermodel.BuiltinFormats;
import ai2.org.apache.poi.ss.usermodel.Workbook;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class InternalWorkbook {
    private static final int MAX_SENSITIVE_SHEET_NAME_LEN = 31;
    private static final POILogger log = POILogFactory.getLogger(InternalWorkbook.class);
    private static final int DEBUG = 1;
    private static final short CODEPAGE = 1200;
    private final WorkbookRecordList records = new WorkbookRecordList();
    protected SSTRecord sst;
    private LinkTable linkTable;
    private final List<BoundSheetRecord> boundsheets = new ArrayList<BoundSheetRecord>();
    private final List<FormatRecord> formats = new ArrayList<FormatRecord>();
    private final List<HyperlinkRecord> hyperlinks = new ArrayList<HyperlinkRecord>();
    private int numxfs = 0;
    private int numfonts = 0;
    private int maxformatid = -1;
    private boolean uses1904datewindowing = false;
    private DrawingManager2 drawingManager;
    private List<EscherBSERecord> escherBSERecords = new ArrayList<EscherBSERecord>();
    private WindowOneRecord windowOne;
    private FileSharingRecord fileShare;
    private WriteAccessRecord writeAccess;
    private WriteProtectRecord writeProtect;
    private final Map<String, NameCommentRecord> commentRecords = new LinkedHashMap<String, NameCommentRecord>();

    private InternalWorkbook() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static InternalWorkbook createWorkbook(List<Record> list) {
        Record record;
        int n;
        if (log.check(1)) {
            log.log(1, "Workbook (readfile) created with reclen=", list.size());
        }
        InternalWorkbook internalWorkbook = new InternalWorkbook();
        ArrayList<Record> arrayList = new ArrayList<Record>(list.size() / 3);
        internalWorkbook.records.setRecords(arrayList);
        block22: for (n = 0; n < list.size(); ++n) {
            record = list.get(n);
            if (record.getSid() == 10) {
                arrayList.add(record);
                if (!log.check(1)) break;
                log.log(1, new Object[]{"found workbook eof record at " + n});
                break;
            }
            switch (record.getSid()) {
                case 133: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found boundsheet record at " + n});
                    }
                    internalWorkbook.boundsheets.add((BoundSheetRecord)record);
                    internalWorkbook.records.setBspos(n);
                    break;
                }
                case 252: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found sst record at " + n});
                    }
                    internalWorkbook.sst = (SSTRecord)record;
                    break;
                }
                case 49: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found font record at " + n});
                    }
                    internalWorkbook.records.setFontpos(n);
                    ++internalWorkbook.numfonts;
                    break;
                }
                case 224: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found XF record at " + n});
                    }
                    internalWorkbook.records.setXfpos(n);
                    ++internalWorkbook.numxfs;
                    break;
                }
                case 317: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found tabid record at " + n});
                    }
                    internalWorkbook.records.setTabpos(n);
                    break;
                }
                case 18: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found protect record at " + n});
                    }
                    internalWorkbook.records.setProtpos(n);
                    break;
                }
                case 64: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found backup record at " + n});
                    }
                    internalWorkbook.records.setBackuppos(n);
                    break;
                }
                case 23: {
                    throw new RuntimeException("Extern sheet is part of LinkTable");
                }
                case 24: 
                case 430: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found SupBook record at " + n});
                    }
                    internalWorkbook.linkTable = new LinkTable(list, n, internalWorkbook.records, internalWorkbook.commentRecords);
                    n += internalWorkbook.linkTable.getRecordCount() - 1;
                    continue block22;
                }
                case 1054: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found format record at " + n});
                    }
                    internalWorkbook.formats.add((FormatRecord)record);
                    internalWorkbook.maxformatid = internalWorkbook.maxformatid >= ((FormatRecord)record).getIndexCode() ? internalWorkbook.maxformatid : ((FormatRecord)record).getIndexCode();
                    break;
                }
                case 34: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found datewindow1904 record at " + n});
                    }
                    internalWorkbook.uses1904datewindowing = ((DateWindow1904Record)record).getWindowing() == 1;
                    break;
                }
                case 146: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found palette record at " + n});
                    }
                    internalWorkbook.records.setPalettepos(n);
                    break;
                }
                case 61: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found WindowOneRecord at " + n});
                    }
                    internalWorkbook.windowOne = (WindowOneRecord)record;
                    break;
                }
                case 92: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found WriteAccess at " + n});
                    }
                    internalWorkbook.writeAccess = (WriteAccessRecord)record;
                    break;
                }
                case 134: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found WriteProtect at " + n});
                    }
                    internalWorkbook.writeProtect = (WriteProtectRecord)record;
                    break;
                }
                case 91: {
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found FileSharing at " + n});
                    }
                    internalWorkbook.fileShare = (FileSharingRecord)record;
                    break;
                }
                case 2196: {
                    NameCommentRecord nameCommentRecord = (NameCommentRecord)record;
                    if (log.check(1)) {
                        log.log(1, new Object[]{"found NameComment at " + n});
                    }
                    internalWorkbook.commentRecords.put(nameCommentRecord.getNameText(), nameCommentRecord);
                }
            }
            arrayList.add(record);
        }
        while (n < list.size()) {
            record = list.get(n);
            switch (record.getSid()) {
                case 440: {
                    internalWorkbook.hyperlinks.add((HyperlinkRecord)record);
                    break;
                }
            }
            ++n;
        }
        if (internalWorkbook.windowOne == null) {
            internalWorkbook.windowOne = InternalWorkbook.createWindowOne();
        }
        if (log.check(1)) {
            log.log(1, new Object[]{"exit create workbook from existing file function"});
        }
        return internalWorkbook;
    }

    public static InternalWorkbook createWorkbook() {
        int n;
        int n2;
        if (log.check(1)) {
            log.log(1, new Object[]{"creating new workbook from scratch"});
        }
        InternalWorkbook internalWorkbook = new InternalWorkbook();
        ArrayList<Record> arrayList = new ArrayList<Record>(30);
        internalWorkbook.records.setRecords(arrayList);
        List<FormatRecord> list = internalWorkbook.formats;
        arrayList.add(InternalWorkbook.createBOF());
        arrayList.add(new InterfaceHdrRecord(1200));
        arrayList.add(InternalWorkbook.createMMS());
        arrayList.add(InterfaceEndRecord.instance);
        arrayList.add(InternalWorkbook.createWriteAccess());
        arrayList.add(InternalWorkbook.createCodepage());
        arrayList.add(InternalWorkbook.createDSF());
        arrayList.add(InternalWorkbook.createTabId());
        internalWorkbook.records.setTabpos(arrayList.size() - 1);
        arrayList.add(InternalWorkbook.createFnGroupCount());
        arrayList.add(InternalWorkbook.createWindowProtect());
        arrayList.add(InternalWorkbook.createProtect());
        internalWorkbook.records.setProtpos(arrayList.size() - 1);
        arrayList.add(InternalWorkbook.createPassword());
        arrayList.add(InternalWorkbook.createProtectionRev4());
        arrayList.add(InternalWorkbook.createPasswordRev4());
        internalWorkbook.windowOne = InternalWorkbook.createWindowOne();
        arrayList.add(internalWorkbook.windowOne);
        arrayList.add(InternalWorkbook.createBackup());
        internalWorkbook.records.setBackuppos(arrayList.size() - 1);
        arrayList.add(InternalWorkbook.createHideObj());
        arrayList.add(InternalWorkbook.createDateWindow1904());
        arrayList.add(InternalWorkbook.createPrecision());
        arrayList.add(InternalWorkbook.createRefreshAll());
        arrayList.add(InternalWorkbook.createBookBool());
        arrayList.add(InternalWorkbook.createFont());
        arrayList.add(InternalWorkbook.createFont());
        arrayList.add(InternalWorkbook.createFont());
        arrayList.add(InternalWorkbook.createFont());
        internalWorkbook.records.setFontpos(arrayList.size() - 1);
        internalWorkbook.numfonts = 4;
        for (n2 = 0; n2 <= 7; ++n2) {
            FormatRecord formatRecord = InternalWorkbook.createFormat(n2);
            internalWorkbook.maxformatid = internalWorkbook.maxformatid >= formatRecord.getIndexCode() ? internalWorkbook.maxformatid : formatRecord.getIndexCode();
            list.add(formatRecord);
            arrayList.add(formatRecord);
        }
        for (n2 = 0; n2 < 21; ++n2) {
            arrayList.add(InternalWorkbook.createExtendedFormat(n2));
            ++internalWorkbook.numxfs;
        }
        internalWorkbook.records.setXfpos(arrayList.size() - 1);
        for (n2 = 0; n2 < 6; ++n2) {
            arrayList.add(InternalWorkbook.createStyle(n2));
        }
        arrayList.add(InternalWorkbook.createUseSelFS());
        n2 = 1;
        for (n = 0; n < n2; ++n) {
            BoundSheetRecord boundSheetRecord = InternalWorkbook.createBoundSheet(n);
            arrayList.add(boundSheetRecord);
            internalWorkbook.boundsheets.add(boundSheetRecord);
            internalWorkbook.records.setBspos(arrayList.size() - 1);
        }
        arrayList.add(InternalWorkbook.createCountry());
        for (n = 0; n < n2; ++n) {
            internalWorkbook.getOrCreateLinkTable().checkExternSheet(n);
        }
        internalWorkbook.sst = new SSTRecord();
        arrayList.add(internalWorkbook.sst);
        arrayList.add(InternalWorkbook.createExtendedSST());
        arrayList.add(EOFRecord.instance);
        if (log.check(1)) {
            log.log(1, new Object[]{"exit create new workbook from scratch"});
        }
        return internalWorkbook;
    }

    public NameRecord getSpecificBuiltinRecord(byte by, int n) {
        return this.getOrCreateLinkTable().getSpecificBuiltinRecord(by, n);
    }

    public void removeBuiltinRecord(byte by, int n) {
        this.linkTable.removeBuiltinRecord(by, n);
    }

    public int getNumRecords() {
        return this.records.size();
    }

    public FontRecord getFontRecordAt(int n) {
        int n2 = n;
        if (n2 > 4) {
            --n2;
        }
        if (n2 > this.numfonts - 1) {
            throw new ArrayIndexOutOfBoundsException("There are only " + this.numfonts + " font records, you asked for " + n);
        }
        FontRecord fontRecord = (FontRecord)this.records.get(this.records.getFontpos() - (this.numfonts - 1) + n2);
        return fontRecord;
    }

    public int getFontIndex(FontRecord fontRecord) {
        for (int i = 0; i <= this.numfonts; ++i) {
            FontRecord fontRecord2 = (FontRecord)this.records.get(this.records.getFontpos() - (this.numfonts - 1) + i);
            if (fontRecord2 != fontRecord) continue;
            if (i > 3) {
                return i + 1;
            }
            return i;
        }
        throw new IllegalArgumentException("Could not find that font!");
    }

    public FontRecord createNewFont() {
        FontRecord fontRecord = InternalWorkbook.createFont();
        this.records.add(this.records.getFontpos() + 1, fontRecord);
        this.records.setFontpos(this.records.getFontpos() + 1);
        ++this.numfonts;
        return fontRecord;
    }

    public void removeFontRecord(FontRecord fontRecord) {
        this.records.remove(fontRecord);
        --this.numfonts;
    }

    public int getNumberOfFontRecords() {
        return this.numfonts;
    }

    public void setSheetBof(int n, int n2) {
        if (log.check(1)) {
            log.log(1, "setting bof for sheetnum =", n, " at pos=", n2);
        }
        this.checkSheets(n);
        this.getBoundSheetRec(n).setPositionOfBof(n2);
    }

    private BoundSheetRecord getBoundSheetRec(int n) {
        return this.boundsheets.get(n);
    }

    public BackupRecord getBackupRecord() {
        return (BackupRecord)this.records.get(this.records.getBackuppos());
    }

    public void setSheetName(int n, String string) {
        this.checkSheets(n);
        if (string.length() > 31) {
            string = string.substring(0, 31);
        }
        BoundSheetRecord boundSheetRecord = this.boundsheets.get(n);
        boundSheetRecord.setSheetname(string);
    }

    public boolean doesContainsSheetName(String string, int n) {
        String string2 = string;
        if (string2.length() > 31) {
            string2 = string2.substring(0, 31);
        }
        for (int i = 0; i < this.boundsheets.size(); ++i) {
            BoundSheetRecord boundSheetRecord = this.getBoundSheetRec(i);
            if (n == i) continue;
            String string3 = boundSheetRecord.getSheetname();
            if (string3.length() > 31) {
                string3 = string3.substring(0, 31);
            }
            if (!string2.equalsIgnoreCase(string3)) continue;
            return true;
        }
        return false;
    }

    public void setSheetOrder(String string, int n) {
        int n2 = this.getSheetIndex(string);
        this.boundsheets.add(n, this.boundsheets.remove(n2));
        int n3 = this.records.getBspos() - (this.boundsheets.size() - 1);
        Record record = this.records.get(n3 + n2);
        this.records.remove(n3 + n2);
        this.records.add(n3 + n, record);
    }

    public String getSheetName(int n) {
        return this.getBoundSheetRec(n).getSheetname();
    }

    public boolean isSheetHidden(int n) {
        return this.getBoundSheetRec(n).isHidden();
    }

    public boolean isSheetVeryHidden(int n) {
        return this.getBoundSheetRec(n).isVeryHidden();
    }

    public void setSheetHidden(int n, boolean bl) {
        this.getBoundSheetRec(n).setHidden(bl);
    }

    public void setSheetHidden(int n, int n2) {
        BoundSheetRecord boundSheetRecord = this.getBoundSheetRec(n);
        boolean bl = false;
        boolean bl2 = false;
        if (n2 != 0) {
            if (n2 == 1) {
                bl = true;
            } else if (n2 == 2) {
                bl2 = true;
            } else {
                throw new IllegalArgumentException("Invalid hidden flag " + n2 + " given, must be 0, 1 or 2");
            }
        }
        boundSheetRecord.setHidden(bl);
        boundSheetRecord.setVeryHidden(bl2);
    }

    public int getSheetIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.boundsheets.size(); ++i) {
            String string2 = this.getSheetName(i);
            if (!string2.equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    private void checkSheets(int n) {
        if (this.boundsheets.size() <= n) {
            if (this.boundsheets.size() + 1 <= n) {
                throw new RuntimeException("Sheet number out of bounds!");
            }
            BoundSheetRecord boundSheetRecord = InternalWorkbook.createBoundSheet(n);
            this.records.add(this.records.getBspos() + 1, boundSheetRecord);
            this.records.setBspos(this.records.getBspos() + 1);
            this.boundsheets.add(boundSheetRecord);
            this.getOrCreateLinkTable().checkExternSheet(n);
            this.fixTabIdRecord();
        }
    }

    public void removeSheet(int n) {
        int n2;
        if (this.boundsheets.size() > n) {
            this.records.remove(this.records.getBspos() - (this.boundsheets.size() - 1) + n);
            this.boundsheets.remove(n);
            this.fixTabIdRecord();
        }
        int n3 = n + 1;
        for (n2 = 0; n2 < this.getNumNames(); ++n2) {
            NameRecord nameRecord = this.getNameRecord(n2);
            if (nameRecord.getSheetNumber() == n3) {
                nameRecord.setSheetNumber(0);
                continue;
            }
            if (nameRecord.getSheetNumber() <= n3) continue;
            nameRecord.setSheetNumber(nameRecord.getSheetNumber() - 1);
        }
        if (this.linkTable != null) {
            for (n2 = n + 1; n2 < this.getNumSheets() + 1; ++n2) {
                this.linkTable.removeSheet(n2);
            }
        }
    }

    private int fixTabIdRecord() {
        TabIdRecord tabIdRecord = (TabIdRecord)this.records.get(this.records.getTabpos());
        int n = tabIdRecord.getRecordSize();
        short[] sArray = new short[this.boundsheets.size()];
        for (int n2 = 0; n2 < sArray.length; n2 = (int)((short)(n2 + 1))) {
            sArray[n2] = n2;
        }
        tabIdRecord.setTabIdArray(sArray);
        return tabIdRecord.getRecordSize() - n;
    }

    public int getNumSheets() {
        if (log.check(1)) {
            log.log(1, "getNumSheets=", this.boundsheets.size());
        }
        return this.boundsheets.size();
    }

    public int getNumExFormats() {
        if (log.check(1)) {
            log.log(1, "getXF=", this.numxfs);
        }
        return this.numxfs;
    }

    public ExtendedFormatRecord getExFormatAt(int n) {
        int n2 = this.records.getXfpos() - (this.numxfs - 1);
        ExtendedFormatRecord extendedFormatRecord = (ExtendedFormatRecord)this.records.get(n2 += n);
        return extendedFormatRecord;
    }

    public void removeExFormatRecord(ExtendedFormatRecord extendedFormatRecord) {
        this.records.remove(extendedFormatRecord);
        --this.numxfs;
    }

    public void removeExFormatRecord(int n) {
        int n2 = this.records.getXfpos() - (this.numxfs - 1) + n;
        this.records.remove(n2);
        --this.numxfs;
    }

    public ExtendedFormatRecord createCellXF() {
        ExtendedFormatRecord extendedFormatRecord = InternalWorkbook.createExtendedFormat();
        this.records.add(this.records.getXfpos() + 1, extendedFormatRecord);
        this.records.setXfpos(this.records.getXfpos() + 1);
        ++this.numxfs;
        return extendedFormatRecord;
    }

    public StyleRecord getStyleRecord(int n) {
        for (int i = this.records.getXfpos(); i < this.records.size(); ++i) {
            StyleRecord styleRecord;
            Record record = this.records.get(i);
            if (record instanceof ExtendedFormatRecord || !(record instanceof StyleRecord) || (styleRecord = (StyleRecord)record).getXFIndex() != n) continue;
            return styleRecord;
        }
        return null;
    }

    public StyleRecord createStyleRecord(int n) {
        StyleRecord styleRecord = new StyleRecord();
        styleRecord.setXFIndex(n);
        int n2 = -1;
        for (int i = this.records.getXfpos(); i < this.records.size() && n2 == -1; ++i) {
            Record record = this.records.get(i);
            if (record instanceof ExtendedFormatRecord || record instanceof StyleRecord) continue;
            n2 = i;
        }
        if (n2 == -1) {
            throw new IllegalStateException("No XF Records found!");
        }
        this.records.add(n2, styleRecord);
        return styleRecord;
    }

    public int addSSTString(UnicodeString unicodeString) {
        if (log.check(1)) {
            log.log(1, "insert to sst string='", unicodeString);
        }
        if (this.sst == null) {
            this.insertSST();
        }
        return this.sst.addString(unicodeString);
    }

    public UnicodeString getSSTString(int n) {
        if (this.sst == null) {
            this.insertSST();
        }
        UnicodeString unicodeString = this.sst.getString(n);
        if (log.check(1)) {
            log.log(1, "Returning SST for index=", n, " String= ", unicodeString);
        }
        return unicodeString;
    }

    public void insertSST() {
        if (log.check(1)) {
            log.log(1, new Object[]{"creating new SST via insertSST!"});
        }
        this.sst = new SSTRecord();
        this.records.add(this.records.size() - 1, InternalWorkbook.createExtendedSST());
        this.records.add(this.records.size() - 2, this.sst);
    }

    public int serialize(int n, byte[] byArray) {
        if (log.check(1)) {
            log.log(1, new Object[]{"Serializing Workbook with offsets"});
        }
        int n2 = 0;
        SSTRecord sSTRecord = null;
        int n3 = 0;
        boolean bl = false;
        for (int i = 0; i < this.records.size(); ++i) {
            Record record = this.records.get(i);
            int n4 = 0;
            if (record instanceof SSTRecord) {
                sSTRecord = (SSTRecord)record;
                n3 = n2;
            }
            if (record.getSid() == 255 && sSTRecord != null) {
                record = sSTRecord.createExtSSTRecord(n3 + n);
            }
            if (record instanceof BoundSheetRecord) {
                if (!bl) {
                    for (int j = 0; j < this.boundsheets.size(); ++j) {
                        n4 += this.getBoundSheetRec(j).serialize(n2 + n + n4, byArray);
                    }
                    bl = true;
                }
            } else {
                n4 = record.serialize(n2 + n, byArray);
            }
            n2 += n4;
        }
        if (log.check(1)) {
            log.log(1, new Object[]{"Exiting serialize workbook"});
        }
        return n2;
    }

    public void preSerialize() {
        if (this.records.getTabpos() > 0) {
            TabIdRecord tabIdRecord = (TabIdRecord)this.records.get(this.records.getTabpos());
            if (tabIdRecord._tabids.length < this.boundsheets.size()) {
                this.fixTabIdRecord();
            }
        }
    }

    public int getSize() {
        int n = 0;
        SSTRecord sSTRecord = null;
        for (int i = 0; i < this.records.size(); ++i) {
            Record record = this.records.get(i);
            if (record instanceof SSTRecord) {
                sSTRecord = (SSTRecord)record;
            }
            if (record.getSid() == 255 && sSTRecord != null) {
                n += sSTRecord.calcExtSSTRecordSize();
                continue;
            }
            n += record.getRecordSize();
        }
        return n;
    }

    private static BOFRecord createBOF() {
        BOFRecord bOFRecord = new BOFRecord();
        bOFRecord.setVersion(1536);
        bOFRecord.setType(5);
        bOFRecord.setBuild(4307);
        bOFRecord.setBuildYear(1996);
        bOFRecord.setHistoryBitMask(65);
        bOFRecord.setRequiredVersion(6);
        return bOFRecord;
    }

    private static MMSRecord createMMS() {
        MMSRecord mMSRecord = new MMSRecord();
        mMSRecord.setAddMenuCount((byte)0);
        mMSRecord.setDelMenuCount((byte)0);
        return mMSRecord;
    }

    private static WriteAccessRecord createWriteAccess() {
        WriteAccessRecord writeAccessRecord = new WriteAccessRecord();
        String string = "POI";
        try {
            String string2 = System.getProperty("user.name");
            if (string2 == null) {
                string2 = string;
            }
            writeAccessRecord.setUsername(string2);
        }
        catch (AccessControlException accessControlException) {
            writeAccessRecord.setUsername(string);
        }
        return writeAccessRecord;
    }

    private static CodepageRecord createCodepage() {
        CodepageRecord codepageRecord = new CodepageRecord();
        codepageRecord.setCodepage((short)1200);
        return codepageRecord;
    }

    private static DSFRecord createDSF() {
        return new DSFRecord(false);
    }

    private static TabIdRecord createTabId() {
        return new TabIdRecord();
    }

    private static FnGroupCountRecord createFnGroupCount() {
        FnGroupCountRecord fnGroupCountRecord = new FnGroupCountRecord();
        fnGroupCountRecord.setCount((short)14);
        return fnGroupCountRecord;
    }

    private static WindowProtectRecord createWindowProtect() {
        return new WindowProtectRecord(false);
    }

    private static ProtectRecord createProtect() {
        return new ProtectRecord(false);
    }

    private static PasswordRecord createPassword() {
        return new PasswordRecord(0);
    }

    private static ProtectionRev4Record createProtectionRev4() {
        return new ProtectionRev4Record(false);
    }

    private static PasswordRev4Record createPasswordRev4() {
        return new PasswordRev4Record(0);
    }

    private static WindowOneRecord createWindowOne() {
        WindowOneRecord windowOneRecord = new WindowOneRecord();
        windowOneRecord.setHorizontalHold((short)360);
        windowOneRecord.setVerticalHold((short)270);
        windowOneRecord.setWidth((short)14940);
        windowOneRecord.setHeight((short)9150);
        windowOneRecord.setOptions((short)56);
        windowOneRecord.setActiveSheetIndex(0);
        windowOneRecord.setFirstVisibleTab(0);
        windowOneRecord.setNumSelectedTabs((short)1);
        windowOneRecord.setTabWidthRatio((short)600);
        return windowOneRecord;
    }

    private static BackupRecord createBackup() {
        BackupRecord backupRecord = new BackupRecord();
        backupRecord.setBackup((short)0);
        return backupRecord;
    }

    private static HideObjRecord createHideObj() {
        HideObjRecord hideObjRecord = new HideObjRecord();
        hideObjRecord.setHideObj((short)0);
        return hideObjRecord;
    }

    private static DateWindow1904Record createDateWindow1904() {
        DateWindow1904Record dateWindow1904Record = new DateWindow1904Record();
        dateWindow1904Record.setWindowing((short)0);
        return dateWindow1904Record;
    }

    private static PrecisionRecord createPrecision() {
        PrecisionRecord precisionRecord = new PrecisionRecord();
        precisionRecord.setFullPrecision(true);
        return precisionRecord;
    }

    private static RefreshAllRecord createRefreshAll() {
        return new RefreshAllRecord(false);
    }

    private static BookBoolRecord createBookBool() {
        BookBoolRecord bookBoolRecord = new BookBoolRecord();
        bookBoolRecord.setSaveLinkValues((short)0);
        return bookBoolRecord;
    }

    private static FontRecord createFont() {
        FontRecord fontRecord = new FontRecord();
        fontRecord.setFontHeight((short)200);
        fontRecord.setAttributes((short)0);
        fontRecord.setColorPaletteIndex((short)Short.MAX_VALUE);
        fontRecord.setBoldWeight((short)400);
        fontRecord.setFontName("Arial");
        return fontRecord;
    }

    private static FormatRecord createFormat(int n) {
        switch (n) {
            case 0: {
                return new FormatRecord(5, BuiltinFormats.getBuiltinFormat(5));
            }
            case 1: {
                return new FormatRecord(6, BuiltinFormats.getBuiltinFormat(6));
            }
            case 2: {
                return new FormatRecord(7, BuiltinFormats.getBuiltinFormat(7));
            }
            case 3: {
                return new FormatRecord(8, BuiltinFormats.getBuiltinFormat(8));
            }
            case 4: {
                return new FormatRecord(42, BuiltinFormats.getBuiltinFormat(42));
            }
            case 5: {
                return new FormatRecord(41, BuiltinFormats.getBuiltinFormat(41));
            }
            case 6: {
                return new FormatRecord(44, BuiltinFormats.getBuiltinFormat(44));
            }
            case 7: {
                return new FormatRecord(43, BuiltinFormats.getBuiltinFormat(43));
            }
        }
        throw new IllegalArgumentException("Unexpected id " + n);
    }

    private static ExtendedFormatRecord createExtendedFormat(int n) {
        ExtendedFormatRecord extendedFormatRecord = new ExtendedFormatRecord();
        switch (n) {
            case 0: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)0);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 1: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 2: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 3: {
                extendedFormatRecord.setFontIndex((short)2);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 4: {
                extendedFormatRecord.setFontIndex((short)2);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 5: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 6: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 7: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 8: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 9: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 10: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 11: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 12: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 13: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 14: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 15: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)1);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)0);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 16: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)43);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-2048);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 17: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)41);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-2048);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 18: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)44);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-2048);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 19: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)42);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-2048);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 20: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)9);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-2048);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 21: {
                extendedFormatRecord.setFontIndex((short)5);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)1);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)2048);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 22: {
                extendedFormatRecord.setFontIndex((short)6);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)1);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)23552);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 23: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)49);
                extendedFormatRecord.setCellOptions((short)1);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)23552);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 24: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)8);
                extendedFormatRecord.setCellOptions((short)1);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)23552);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 25: {
                extendedFormatRecord.setFontIndex((short)6);
                extendedFormatRecord.setFormatIndex((short)8);
                extendedFormatRecord.setCellOptions((short)1);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)23552);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
            }
        }
        return extendedFormatRecord;
    }

    private static ExtendedFormatRecord createExtendedFormat() {
        ExtendedFormatRecord extendedFormatRecord = new ExtendedFormatRecord();
        extendedFormatRecord.setFontIndex((short)0);
        extendedFormatRecord.setFormatIndex((short)0);
        extendedFormatRecord.setCellOptions((short)1);
        extendedFormatRecord.setAlignmentOptions((short)32);
        extendedFormatRecord.setIndentionOptions((short)0);
        extendedFormatRecord.setBorderOptions((short)0);
        extendedFormatRecord.setPaletteOptions((short)0);
        extendedFormatRecord.setAdtlPaletteOptions((short)0);
        extendedFormatRecord.setFillPaletteOptions((short)8384);
        extendedFormatRecord.setTopBorderPaletteIdx((short)8);
        extendedFormatRecord.setBottomBorderPaletteIdx((short)8);
        extendedFormatRecord.setLeftBorderPaletteIdx((short)8);
        extendedFormatRecord.setRightBorderPaletteIdx((short)8);
        return extendedFormatRecord;
    }

    private static StyleRecord createStyle(int n) {
        StyleRecord styleRecord = new StyleRecord();
        switch (n) {
            case 0: {
                styleRecord.setXFIndex(16);
                styleRecord.setBuiltinStyle(3);
                styleRecord.setOutlineStyleLevel(-1);
                break;
            }
            case 1: {
                styleRecord.setXFIndex(17);
                styleRecord.setBuiltinStyle(6);
                styleRecord.setOutlineStyleLevel(-1);
                break;
            }
            case 2: {
                styleRecord.setXFIndex(18);
                styleRecord.setBuiltinStyle(4);
                styleRecord.setOutlineStyleLevel(-1);
                break;
            }
            case 3: {
                styleRecord.setXFIndex(19);
                styleRecord.setBuiltinStyle(7);
                styleRecord.setOutlineStyleLevel(-1);
                break;
            }
            case 4: {
                styleRecord.setXFIndex(0);
                styleRecord.setBuiltinStyle(0);
                styleRecord.setOutlineStyleLevel(-1);
                break;
            }
            case 5: {
                styleRecord.setXFIndex(20);
                styleRecord.setBuiltinStyle(5);
                styleRecord.setOutlineStyleLevel(-1);
            }
        }
        return styleRecord;
    }

    private static PaletteRecord createPalette() {
        return new PaletteRecord();
    }

    private static UseSelFSRecord createUseSelFS() {
        return new UseSelFSRecord(false);
    }

    private static BoundSheetRecord createBoundSheet(int n) {
        return new BoundSheetRecord("Sheet" + (n + 1));
    }

    private static CountryRecord createCountry() {
        CountryRecord countryRecord = new CountryRecord();
        countryRecord.setDefaultCountry((short)1);
        if (LocaleUtil.getUserLocale().toString().equals("ru_RU")) {
            countryRecord.setCurrentCountry((short)7);
        } else {
            countryRecord.setCurrentCountry((short)1);
        }
        return countryRecord;
    }

    private static ExtSSTRecord createExtendedSST() {
        ExtSSTRecord extSSTRecord = new ExtSSTRecord();
        extSSTRecord.setNumStringsPerBucket((short)8);
        return extSSTRecord;
    }

    private LinkTable getOrCreateLinkTable() {
        if (this.linkTable == null) {
            this.linkTable = new LinkTable((short)this.getNumSheets(), this.records);
        }
        return this.linkTable;
    }

    public int linkExternalWorkbook(String string, Workbook workbook) {
        return this.getOrCreateLinkTable().linkExternalWorkbook(string, workbook);
    }

    public String findSheetFirstNameFromExternSheet(int n) {
        int n2 = this.linkTable.getFirstInternalSheetIndexForExtIndex(n);
        return this.findSheetNameFromIndex(n2);
    }

    public String findSheetLastNameFromExternSheet(int n) {
        int n2 = this.linkTable.getLastInternalSheetIndexForExtIndex(n);
        return this.findSheetNameFromIndex(n2);
    }

    private String findSheetNameFromIndex(int n) {
        if (n < 0) {
            return "";
        }
        if (n >= this.boundsheets.size()) {
            return "";
        }
        return this.getSheetName(n);
    }

    public EvaluationWorkbook.ExternalSheet getExternalSheet(int n) {
        String[] stringArray = this.linkTable.getExternalBookAndSheetName(n);
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 2) {
            return new EvaluationWorkbook.ExternalSheet(stringArray[0], stringArray[1]);
        }
        return new EvaluationWorkbook.ExternalSheetRange(stringArray[0], stringArray[1], stringArray[2]);
    }

    public EvaluationWorkbook.ExternalName getExternalName(int n, int n2) {
        String string = this.linkTable.resolveNameXText(n, n2, this);
        if (string == null) {
            return null;
        }
        int n3 = this.linkTable.resolveNameXIx(n, n2);
        return new EvaluationWorkbook.ExternalName(string, n2, n3);
    }

    public int getFirstSheetIndexFromExternSheetIndex(int n) {
        return this.linkTable.getFirstInternalSheetIndexForExtIndex(n);
    }

    public int getLastSheetIndexFromExternSheetIndex(int n) {
        return this.linkTable.getLastInternalSheetIndexForExtIndex(n);
    }

    public short checkExternSheet(int n) {
        return (short)this.getOrCreateLinkTable().checkExternSheet(n);
    }

    public short checkExternSheet(int n, int n2) {
        return (short)this.getOrCreateLinkTable().checkExternSheet(n, n2);
    }

    public int getExternalSheetIndex(String string, String string2) {
        return this.getOrCreateLinkTable().getExternalSheetIndex(string, string2, string2);
    }

    public int getExternalSheetIndex(String string, String string2, String string3) {
        return this.getOrCreateLinkTable().getExternalSheetIndex(string, string2, string3);
    }

    public int getNumNames() {
        if (this.linkTable == null) {
            return 0;
        }
        return this.linkTable.getNumNames();
    }

    public NameRecord getNameRecord(int n) {
        return this.linkTable.getNameRecord(n);
    }

    public NameCommentRecord getNameCommentRecord(NameRecord nameRecord) {
        return this.commentRecords.get(nameRecord.getNameText());
    }

    public NameRecord createName() {
        return this.addName(new NameRecord());
    }

    public NameRecord addName(NameRecord nameRecord) {
        LinkTable linkTable = this.getOrCreateLinkTable();
        linkTable.addName(nameRecord);
        return nameRecord;
    }

    public NameRecord createBuiltInName(byte by, int n) {
        if (n < 0 || n + 1 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Sheet number [" + n + "]is not valid ");
        }
        NameRecord nameRecord = new NameRecord(by, n);
        if (this.linkTable.nameAlreadyExists(nameRecord)) {
            throw new RuntimeException("Builtin (" + by + ") already exists for sheet (" + n + ")");
        }
        this.addName(nameRecord);
        return nameRecord;
    }

    public void removeName(int n) {
        if (this.linkTable.getNumNames() > n) {
            int n2 = this.findFirstRecordLocBySid((short)24);
            this.records.remove(n2 + n);
            this.linkTable.removeName(n);
        }
    }

    public void updateNameCommentRecordCache(NameCommentRecord nameCommentRecord) {
        if (this.commentRecords.containsValue(nameCommentRecord)) {
            for (Map.Entry<String, NameCommentRecord> entry : this.commentRecords.entrySet()) {
                if (!entry.getValue().equals(nameCommentRecord)) continue;
                this.commentRecords.remove(entry.getKey());
                break;
            }
        }
        this.commentRecords.put(nameCommentRecord.getNameText(), nameCommentRecord);
    }

    public short getFormat(String string, boolean bl) {
        for (FormatRecord formatRecord : this.formats) {
            if (!formatRecord.getFormatString().equals(string)) continue;
            return (short)formatRecord.getIndexCode();
        }
        if (bl) {
            return (short)this.createFormat(string);
        }
        return -1;
    }

    public List<FormatRecord> getFormats() {
        return this.formats;
    }

    public int createFormat(String string) {
        this.maxformatid = this.maxformatid >= 164 ? this.maxformatid + 1 : 164;
        FormatRecord formatRecord = new FormatRecord(this.maxformatid, string);
        for (int i = 0; i < this.records.size() && this.records.get(i).getSid() != 1054; ++i) {
        }
        this.formats.add(formatRecord);
        this.records.add(i += this.formats.size(), formatRecord);
        return this.maxformatid;
    }

    public Record findFirstRecordBySid(short s) {
        for (Record record : this.records) {
            if (record.getSid() != s) continue;
            return record;
        }
        return null;
    }

    public int findFirstRecordLocBySid(short s) {
        int n = 0;
        for (Record record : this.records) {
            if (record.getSid() == s) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Record findNextRecordBySid(short s, int n) {
        int n2 = 0;
        for (Record record : this.records) {
            if (record.getSid() != s || n2++ != n) continue;
            return record;
        }
        return null;
    }

    public List<HyperlinkRecord> getHyperlinks() {
        return this.hyperlinks;
    }

    public List<Record> getRecords() {
        return this.records.getRecords();
    }

    public boolean isUsing1904DateWindowing() {
        return this.uses1904datewindowing;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PaletteRecord getCustomPalette() {
        int n = this.records.getPalettepos();
        if (n != -1) {
            Record record = this.records.get(n);
            if (!(record instanceof PaletteRecord)) throw new RuntimeException("InternalError: Expected PaletteRecord but got a '" + record + "'");
            return (PaletteRecord)record;
        }
        PaletteRecord paletteRecord = InternalWorkbook.createPalette();
        this.records.add(1, paletteRecord);
        this.records.setPalettepos(1);
        return paletteRecord;
    }

    public DrawingManager2 findDrawingGroup() {
        EscherContainerRecord escherContainerRecord;
        Object object;
        if (this.drawingManager != null) {
            return this.drawingManager;
        }
        for (Record record : this.records) {
            if (!(record instanceof DrawingGroupRecord)) continue;
            object = (DrawingGroupRecord)record;
            ((DrawingGroupRecord)object).processChildRecords();
            escherContainerRecord = ((AbstractEscherHolderRecord)object).getEscherContainer();
            if (escherContainerRecord == null) continue;
            Iterator<EscherRecord> iterator = null;
            EscherRecord escherRecord = null;
            Iterator<EscherRecord> iterator2 = escherContainerRecord.getChildIterator();
            while (iterator2.hasNext()) {
                EscherRecord escherRecord2 = iterator2.next();
                if (escherRecord2 instanceof EscherDggRecord) {
                    iterator = (EscherDggRecord)escherRecord2;
                    continue;
                }
                if (escherRecord2.getRecordId() != -4095) continue;
                escherRecord = (EscherContainerRecord)escherRecord2;
            }
            if (iterator == null) continue;
            this.drawingManager = new DrawingManager2((EscherDggRecord)((Object)iterator));
            if (escherRecord != null) {
                for (EscherRecord escherRecord2 : ((EscherContainerRecord)escherRecord).getChildRecords()) {
                    if (!(escherRecord2 instanceof EscherBSERecord)) continue;
                    this.escherBSERecords.add((EscherBSERecord)escherRecord2);
                }
            }
            return this.drawingManager;
        }
        int n = this.findFirstRecordLocBySid((short)235);
        if (n != -1) {
            Record record;
            record = (DrawingGroupRecord)this.records.get(n);
            object = null;
            escherContainerRecord = null;
            for (EscherRecord escherRecord : ((AbstractEscherHolderRecord)record).getEscherRecords()) {
                if (escherRecord instanceof EscherDggRecord) {
                    object = (EscherDggRecord)escherRecord;
                    continue;
                }
                if (escherRecord.getRecordId() != -4095) continue;
                escherContainerRecord = (EscherContainerRecord)escherRecord;
            }
            if (object != null) {
                this.drawingManager = new DrawingManager2((EscherDggRecord)object);
                if (escherContainerRecord != null) {
                    for (EscherRecord escherRecord : escherContainerRecord.getChildRecords()) {
                        if (!(escherRecord instanceof EscherBSERecord)) continue;
                        this.escherBSERecords.add((EscherBSERecord)escherRecord);
                    }
                }
            }
        }
        return this.drawingManager;
    }

    public void createDrawingGroup() {
        if (this.drawingManager == null) {
            EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
            EscherDggRecord escherDggRecord = new EscherDggRecord();
            EscherOptRecord escherOptRecord = new EscherOptRecord();
            EscherSplitMenuColorsRecord escherSplitMenuColorsRecord = new EscherSplitMenuColorsRecord();
            escherContainerRecord.setRecordId((short)-4096);
            escherContainerRecord.setOptions((short)15);
            escherDggRecord.setRecordId((short)-4090);
            escherDggRecord.setOptions((short)0);
            escherDggRecord.setShapeIdMax(1024);
            escherDggRecord.setNumShapesSaved(0);
            escherDggRecord.setDrawingsSaved(0);
            escherDggRecord.setFileIdClusters(new EscherDggRecord.FileIdCluster[0]);
            this.drawingManager = new DrawingManager2(escherDggRecord);
            EscherContainerRecord escherContainerRecord2 = null;
            if (this.escherBSERecords.size() > 0) {
                escherContainerRecord2 = new EscherContainerRecord();
                escherContainerRecord2.setRecordId((short)-4095);
                escherContainerRecord2.setOptions((short)(this.escherBSERecords.size() << 4 | 0xF));
                for (EscherRecord object2 : this.escherBSERecords) {
                    escherContainerRecord2.addChildRecord(object2);
                }
            }
            escherOptRecord.setRecordId((short)-4085);
            escherOptRecord.setOptions((short)51);
            escherOptRecord.addEscherProperty(new EscherBoolProperty(191, 524296));
            escherOptRecord.addEscherProperty(new EscherRGBProperty(385, 134217793));
            escherOptRecord.addEscherProperty(new EscherRGBProperty(448, 0x8000040));
            escherSplitMenuColorsRecord.setRecordId((short)-3810);
            escherSplitMenuColorsRecord.setOptions((short)64);
            escherSplitMenuColorsRecord.setColor1(0x800000D);
            escherSplitMenuColorsRecord.setColor2(0x800000C);
            escherSplitMenuColorsRecord.setColor3(134217751);
            escherSplitMenuColorsRecord.setColor4(268435703);
            escherContainerRecord.addChildRecord(escherDggRecord);
            if (escherContainerRecord2 != null) {
                escherContainerRecord.addChildRecord(escherContainerRecord2);
            }
            escherContainerRecord.addChildRecord(escherOptRecord);
            escherContainerRecord.addChildRecord(escherSplitMenuColorsRecord);
            int n = this.findFirstRecordLocBySid((short)235);
            if (n == -1) {
                DrawingGroupRecord drawingGroupRecord = new DrawingGroupRecord();
                drawingGroupRecord.addEscherRecord(escherContainerRecord);
                int n2 = this.findFirstRecordLocBySid((short)140);
                this.getRecords().add(n2 + 1, drawingGroupRecord);
            } else {
                DrawingGroupRecord drawingGroupRecord = new DrawingGroupRecord();
                drawingGroupRecord.addEscherRecord(escherContainerRecord);
                this.getRecords().set(n, drawingGroupRecord);
            }
        }
    }

    public WindowOneRecord getWindowOne() {
        return this.windowOne;
    }

    public EscherBSERecord getBSERecord(int n) {
        return this.escherBSERecords.get(n - 1);
    }

    public int addBSERecord(EscherBSERecord escherBSERecord) {
        EscherContainerRecord escherContainerRecord;
        this.createDrawingGroup();
        this.escherBSERecords.add(escherBSERecord);
        int n = this.findFirstRecordLocBySid((short)235);
        DrawingGroupRecord drawingGroupRecord = (DrawingGroupRecord)this.getRecords().get(n);
        EscherContainerRecord escherContainerRecord2 = (EscherContainerRecord)drawingGroupRecord.getEscherRecord(0);
        if (escherContainerRecord2.getChild(1).getRecordId() == -4095) {
            escherContainerRecord = (EscherContainerRecord)escherContainerRecord2.getChild(1);
        } else {
            escherContainerRecord = new EscherContainerRecord();
            escherContainerRecord.setRecordId((short)-4095);
            List<EscherRecord> list = escherContainerRecord2.getChildRecords();
            list.add(1, escherContainerRecord);
            escherContainerRecord2.setChildRecords(list);
        }
        escherContainerRecord.setOptions((short)(this.escherBSERecords.size() << 4 | 0xF));
        escherContainerRecord.addChildRecord(escherBSERecord);
        return this.escherBSERecords.size();
    }

    public DrawingManager2 getDrawingManager() {
        return this.drawingManager;
    }

    public WriteProtectRecord getWriteProtect() {
        if (this.writeProtect == null) {
            this.writeProtect = new WriteProtectRecord();
            int n = 0;
            for (n = 0; n < this.records.size() && !(this.records.get(n) instanceof BOFRecord); ++n) {
            }
            this.records.add(n + 1, this.writeProtect);
        }
        return this.writeProtect;
    }

    public WriteAccessRecord getWriteAccess() {
        if (this.writeAccess == null) {
            this.writeAccess = InternalWorkbook.createWriteAccess();
            int n = 0;
            for (n = 0; n < this.records.size() && !(this.records.get(n) instanceof InterfaceEndRecord); ++n) {
            }
            this.records.add(n + 1, this.writeAccess);
        }
        return this.writeAccess;
    }

    public FileSharingRecord getFileSharing() {
        if (this.fileShare == null) {
            this.fileShare = new FileSharingRecord();
            int n = 0;
            for (n = 0; n < this.records.size() && !(this.records.get(n) instanceof WriteAccessRecord); ++n) {
            }
            this.records.add(n + 1, this.fileShare);
        }
        return this.fileShare;
    }

    public boolean isWriteProtected() {
        if (this.fileShare == null) {
            return false;
        }
        FileSharingRecord fileSharingRecord = this.getFileSharing();
        return fileSharingRecord.getReadOnly() == 1;
    }

    public void writeProtectWorkbook(String string, String string2) {
        FileSharingRecord fileSharingRecord = this.getFileSharing();
        WriteAccessRecord writeAccessRecord = this.getWriteAccess();
        this.getWriteProtect();
        fileSharingRecord.setReadOnly((short)1);
        fileSharingRecord.setPassword((short)CryptoFunctions.createXorVerifier1(string));
        fileSharingRecord.setUsername(string2);
        writeAccessRecord.setUsername(string2);
    }

    public void unwriteProtectWorkbook() {
        this.records.remove(this.fileShare);
        this.records.remove(this.writeProtect);
        this.fileShare = null;
        this.writeProtect = null;
    }

    public String resolveNameXText(int n, int n2) {
        return this.linkTable.resolveNameXText(n, n2, this);
    }

    public NameXPtg getNameXPtg(String string, int n, UDFFinder uDFFinder) {
        LinkTable linkTable = this.getOrCreateLinkTable();
        NameXPtg nameXPtg = linkTable.getNameXPtg(string, n);
        if (nameXPtg == null && uDFFinder.findFunction(string) != null) {
            nameXPtg = linkTable.addNameXPtg(string);
        }
        return nameXPtg;
    }

    public NameXPtg getNameXPtg(String string, UDFFinder uDFFinder) {
        return this.getNameXPtg(string, -1, uDFFinder);
    }

    public void cloneDrawings(InternalSheet internalSheet) {
        this.findDrawingGroup();
        if (this.drawingManager == null) {
            return;
        }
        int n = internalSheet.aggregateDrawingRecords(this.drawingManager, false);
        if (n != -1) {
            EscherAggregate escherAggregate = (EscherAggregate)internalSheet.findFirstRecordBySid((short)9876);
            EscherContainerRecord escherContainerRecord = escherAggregate.getEscherContainer();
            if (escherContainerRecord == null) {
                return;
            }
            EscherDggRecord escherDggRecord = this.drawingManager.getDgg();
            short s = this.drawingManager.findNewDrawingGroupId();
            escherDggRecord.addCluster(s, 0);
            escherDggRecord.setDrawingsSaved(escherDggRecord.getDrawingsSaved() + 1);
            EscherDgRecord escherDgRecord = null;
            Iterator<EscherRecord> iterator = escherContainerRecord.getChildIterator();
            while (iterator.hasNext()) {
                EscherRecord escherRecord = iterator.next();
                if (escherRecord instanceof EscherDgRecord) {
                    escherDgRecord = (EscherDgRecord)escherRecord;
                    escherDgRecord.setOptions((short)(s << 4));
                    continue;
                }
                if (!(escherRecord instanceof EscherContainerRecord)) continue;
                EscherContainerRecord escherContainerRecord2 = (EscherContainerRecord)escherRecord;
                for (EscherContainerRecord escherContainerRecord3 : escherContainerRecord2.getChildRecords()) {
                    for (EscherRecord escherRecord2 : escherContainerRecord3.getChildRecords()) {
                        EscherSimpleProperty escherSimpleProperty;
                        EscherRecord escherRecord3;
                        short s2 = escherRecord2.getRecordId();
                        if (s2 == -4086) {
                            escherRecord3 = (EscherSpRecord)escherRecord2;
                            int n2 = this.drawingManager.allocateShapeId(s, escherDgRecord);
                            escherDgRecord.setNumShapes(escherDgRecord.getNumShapes() - 1);
                            ((EscherSpRecord)escherRecord3).setShapeId(n2);
                            continue;
                        }
                        if (s2 != -4085 || (escherSimpleProperty = (EscherSimpleProperty)((AbstractEscherOptRecord)(escherRecord3 = (EscherOptRecord)escherRecord2)).lookup(260)) == null) continue;
                        int n3 = escherSimpleProperty.getPropertyValue();
                        EscherBSERecord escherBSERecord = this.getBSERecord(n3);
                        escherBSERecord.setRef(escherBSERecord.getRef() + 1);
                    }
                }
            }
        }
    }

    public NameRecord cloneFilter(int n, int n2) {
        NameRecord nameRecord = this.getNameRecord(n);
        short s = this.checkExternSheet(n2);
        Ptg[] ptgArray = nameRecord.getNameDefinition();
        for (int i = 0; i < ptgArray.length; ++i) {
            OperandPtg operandPtg;
            Ptg ptg = ptgArray[i];
            if (ptg instanceof Area3DPtg) {
                operandPtg = (Area3DPtg)((OperandPtg)ptg).copy();
                ((Area3DPtg)operandPtg).setExternSheetIndex(s);
                ptgArray[i] = operandPtg;
                continue;
            }
            if (!(ptg instanceof Ref3DPtg)) continue;
            operandPtg = (Ref3DPtg)((OperandPtg)ptg).copy();
            ((Ref3DPtg)operandPtg).setExternSheetIndex(s);
            ptgArray[i] = operandPtg;
        }
        NameRecord nameRecord2 = this.createBuiltInName((byte)13, n2 + 1);
        nameRecord2.setNameDefinition(ptgArray);
        nameRecord2.setHidden(true);
        return nameRecord2;
    }

    public void updateNamesAfterCellShift(FormulaShifter formulaShifter) {
        for (int i = 0; i < this.getNumNames(); ++i) {
            NameRecord nameRecord = this.getNameRecord(i);
            Ptg[] ptgArray = nameRecord.getNameDefinition();
            if (!formulaShifter.adjustFormula(ptgArray, nameRecord.getSheetNumber())) continue;
            nameRecord.setNameDefinition(ptgArray);
        }
    }

    public RecalcIdRecord getRecalcId() {
        RecalcIdRecord recalcIdRecord = (RecalcIdRecord)this.findFirstRecordBySid((short)449);
        if (recalcIdRecord == null) {
            recalcIdRecord = new RecalcIdRecord();
            int n = this.findFirstRecordLocBySid((short)140);
            this.records.add(n + 1, recalcIdRecord);
        }
        return recalcIdRecord;
    }

    public boolean changeExternalReference(String string, String string2) {
        return this.linkTable.changeExternalReference(string, string2);
    }
}

