/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.eventusermodel;

import ai2.org.apache.poi.hssf.eventusermodel.HSSFListener;
import ai2.org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import ai2.org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import ai2.org.apache.poi.hssf.eventusermodel.dummyrecord.MissingRowDummyRecord;
import ai2.org.apache.poi.hssf.record.BOFRecord;
import ai2.org.apache.poi.hssf.record.CellValueRecordInterface;
import ai2.org.apache.poi.hssf.record.MulBlankRecord;
import ai2.org.apache.poi.hssf.record.MulRKRecord;
import ai2.org.apache.poi.hssf.record.NoteRecord;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RecordFactory;
import ai2.org.apache.poi.hssf.record.RowRecord;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.hssf.record.StringRecord;

public final class MissingRecordAwareHSSFListener
implements HSSFListener {
    private HSSFListener childListener;
    private int lastRowRow;
    private int lastCellRow;
    private int lastCellColumn;

    public MissingRecordAwareHSSFListener(HSSFListener hSSFListener) {
        this.resetCounts();
        this.childListener = hSSFListener;
    }

    public void processRecord(Record record) {
        int n;
        int n2;
        Object object;
        StandardRecord[] standardRecordArray = null;
        if (record instanceof CellValueRecordInterface) {
            object = (CellValueRecordInterface)((Object)record);
            n2 = object.getRow();
            n = object.getColumn();
        } else {
            if (record instanceof StringRecord) {
                this.childListener.processRecord(record);
                return;
            }
            n2 = -1;
            n = -1;
            switch (record.getSid()) {
                case 2057: {
                    object = (BOFRecord)record;
                    if (((BOFRecord)object).getType() != 5 && ((BOFRecord)object).getType() != 16) break;
                    this.resetCounts();
                    break;
                }
                case 520: {
                    RowRecord rowRecord = (RowRecord)record;
                    if (this.lastRowRow + 1 < rowRecord.getRowNumber()) {
                        for (int i = this.lastRowRow + 1; i < rowRecord.getRowNumber(); ++i) {
                            MissingRowDummyRecord record2 = new MissingRowDummyRecord(i);
                            this.childListener.processRecord(record2);
                        }
                    }
                    this.lastRowRow = rowRecord.getRowNumber();
                    this.lastCellColumn = -1;
                    break;
                }
                case 1212: {
                    this.childListener.processRecord(record);
                    return;
                }
                case 190: {
                    MulBlankRecord mulBlankRecord = (MulBlankRecord)record;
                    standardRecordArray = RecordFactory.convertBlankRecords(mulBlankRecord);
                    break;
                }
                case 189: {
                    MulRKRecord mulRKRecord = (MulRKRecord)record;
                    standardRecordArray = RecordFactory.convertRKRecords(mulRKRecord);
                    break;
                }
                case 28: {
                    NoteRecord noteRecord = (NoteRecord)record;
                    n2 = noteRecord.getRow();
                    n = noteRecord.getColumn();
                }
            }
        }
        if (standardRecordArray != null && standardRecordArray.length > 0) {
            n2 = standardRecordArray[0].getRow();
            n = standardRecordArray[0].getColumn();
        }
        if (n2 != this.lastCellRow && n2 > 0) {
            if (this.lastCellRow == -1) {
                this.lastCellRow = 0;
            }
            for (int i = this.lastCellRow; i < n2; ++i) {
                int n3 = -1;
                if (i == this.lastCellRow) {
                    n3 = this.lastCellColumn;
                }
                this.childListener.processRecord(new LastCellOfRowDummyRecord(i, n3));
            }
        }
        if (this.lastCellRow != -1 && this.lastCellColumn != -1 && n2 == -1) {
            this.childListener.processRecord(new LastCellOfRowDummyRecord(this.lastCellRow, this.lastCellColumn));
            this.lastCellRow = -1;
            this.lastCellColumn = -1;
        }
        if (n2 != this.lastCellRow) {
            this.lastCellColumn = -1;
        }
        if (this.lastCellColumn != n - 1) {
            for (int i = this.lastCellColumn + 1; i < n; ++i) {
                this.childListener.processRecord(new MissingCellDummyRecord(n2, i));
            }
        }
        if (standardRecordArray != null && standardRecordArray.length > 0) {
            n = standardRecordArray[standardRecordArray.length - 1].getColumn();
        }
        if (n != -1) {
            this.lastCellColumn = n;
            this.lastCellRow = n2;
        }
        if (standardRecordArray != null && standardRecordArray.length > 0) {
            for (StandardRecord standardRecord : standardRecordArray) {
                this.childListener.processRecord(standardRecord);
            }
        } else {
            this.childListener.processRecord(record);
        }
    }

    private void resetCounts() {
        this.lastRowRow = -1;
        this.lastCellRow = -1;
        this.lastCellColumn = -1;
    }
}

