/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.eventusermodel;

import ai2.org.apache.poi.hssf.eventusermodel.HSSFListener;
import ai2.org.apache.poi.hssf.record.CellValueRecordInterface;
import ai2.org.apache.poi.hssf.record.ExtendedFormatRecord;
import ai2.org.apache.poi.hssf.record.FormatRecord;
import ai2.org.apache.poi.hssf.record.FormulaRecord;
import ai2.org.apache.poi.hssf.record.NumberRecord;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.hssf.usermodel.HSSFDataFormat;
import ai2.org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FormatTrackingHSSFListener
implements HSSFListener {
    private static POILogger logger = POILogFactory.getLogger(FormatTrackingHSSFListener.class);
    private final HSSFListener _childListener;
    private final HSSFDataFormatter _formatter;
    private final NumberFormat _defaultFormat;
    private final Map<Integer, FormatRecord> _customFormatRecords = new Hashtable<Integer, FormatRecord>();
    private final List<ExtendedFormatRecord> _xfRecords = new ArrayList<ExtendedFormatRecord>();

    public FormatTrackingHSSFListener(HSSFListener hSSFListener) {
        this(hSSFListener, LocaleUtil.getUserLocale());
    }

    public FormatTrackingHSSFListener(HSSFListener hSSFListener, Locale locale) {
        this._childListener = hSSFListener;
        this._formatter = new HSSFDataFormatter(locale);
        this._defaultFormat = NumberFormat.getInstance(locale);
    }

    protected int getNumberOfCustomFormats() {
        return this._customFormatRecords.size();
    }

    protected int getNumberOfExtendedFormats() {
        return this._xfRecords.size();
    }

    public void processRecord(Record record) {
        this.processRecordInternally(record);
        this._childListener.processRecord(record);
    }

    public void processRecordInternally(Record record) {
        StandardRecord standardRecord;
        if (record instanceof FormatRecord) {
            standardRecord = (FormatRecord)record;
            this._customFormatRecords.put(standardRecord.getIndexCode(), (FormatRecord)standardRecord);
        }
        if (record instanceof ExtendedFormatRecord) {
            standardRecord = (ExtendedFormatRecord)record;
            this._xfRecords.add((ExtendedFormatRecord)standardRecord);
        }
    }

    public String formatNumberDateCell(CellValueRecordInterface cellValueRecordInterface) {
        double d;
        if (cellValueRecordInterface instanceof NumberRecord) {
            d = ((NumberRecord)cellValueRecordInterface).getValue();
        } else if (cellValueRecordInterface instanceof FormulaRecord) {
            d = ((FormulaRecord)cellValueRecordInterface).getValue();
        } else {
            throw new IllegalArgumentException("Unsupported CellValue Record passed in " + cellValueRecordInterface);
        }
        int n = this.getFormatIndex(cellValueRecordInterface);
        String string = this.getFormatString(cellValueRecordInterface);
        if (string == null) {
            return this._defaultFormat.format(d);
        }
        return this._formatter.formatRawCellContents(d, n, string);
    }

    public String getFormatString(int n) {
        String string = null;
        if (n >= HSSFDataFormat.getNumberOfBuiltinBuiltinFormats()) {
            FormatRecord formatRecord = this._customFormatRecords.get(n);
            if (formatRecord == null) {
                logger.log(7, new Object[]{"Requested format at index " + n + ", but it wasn't found"});
            } else {
                string = formatRecord.getFormatString();
            }
        } else {
            string = HSSFDataFormat.getBuiltinFormat((short)n);
        }
        return string;
    }

    public String getFormatString(CellValueRecordInterface cellValueRecordInterface) {
        int n = this.getFormatIndex(cellValueRecordInterface);
        if (n == -1) {
            return null;
        }
        return this.getFormatString(n);
    }

    public int getFormatIndex(CellValueRecordInterface cellValueRecordInterface) {
        ExtendedFormatRecord extendedFormatRecord = this._xfRecords.get(cellValueRecordInterface.getXFIndex());
        if (extendedFormatRecord == null) {
            logger.log(7, new Object[]{"Cell " + cellValueRecordInterface.getRow() + "," + cellValueRecordInterface.getColumn() + " uses XF with index " + cellValueRecordInterface.getXFIndex() + ", but we don't have that"});
            return -1;
        }
        return extendedFormatRecord.getFormatIndex();
    }
}

