/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.eventusermodel;

import ai2.org.apache.poi.hssf.eventusermodel.HSSFListener;
import ai2.org.apache.poi.hssf.model.InternalWorkbook;
import ai2.org.apache.poi.hssf.record.BoundSheetRecord;
import ai2.org.apache.poi.hssf.record.EOFRecord;
import ai2.org.apache.poi.hssf.record.ExternSheetRecord;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.SSTRecord;
import ai2.org.apache.poi.hssf.record.SupBookRecord;
import ai2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import java.util.ArrayList;
import java.util.List;

public class EventWorkbookBuilder {
    public static InternalWorkbook createStubWorkbook(ExternSheetRecord[] externSheetRecordArray, BoundSheetRecord[] boundSheetRecordArray, SSTRecord sSTRecord) {
        int n;
        ArrayList<Record> arrayList = new ArrayList<Record>();
        if (boundSheetRecordArray != null) {
            for (n = 0; n < boundSheetRecordArray.length; ++n) {
                arrayList.add(boundSheetRecordArray[n]);
            }
        }
        if (sSTRecord != null) {
            arrayList.add(sSTRecord);
        }
        if (externSheetRecordArray != null) {
            arrayList.add(SupBookRecord.createInternalReferences((short)externSheetRecordArray.length));
            for (n = 0; n < externSheetRecordArray.length; ++n) {
                arrayList.add(externSheetRecordArray[n]);
            }
        }
        arrayList.add(EOFRecord.instance);
        return InternalWorkbook.createWorkbook(arrayList);
    }

    public static InternalWorkbook createStubWorkbook(ExternSheetRecord[] externSheetRecordArray, BoundSheetRecord[] boundSheetRecordArray) {
        return EventWorkbookBuilder.createStubWorkbook(externSheetRecordArray, boundSheetRecordArray, null);
    }

    public static class SheetRecordCollectingListener
    implements HSSFListener {
        private HSSFListener childListener;
        private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
        private List<ExternSheetRecord> externSheetRecords = new ArrayList<ExternSheetRecord>();
        private SSTRecord sstRecord = null;

        public SheetRecordCollectingListener(HSSFListener hSSFListener) {
            this.childListener = hSSFListener;
        }

        public BoundSheetRecord[] getBoundSheetRecords() {
            return this.boundSheetRecords.toArray(new BoundSheetRecord[this.boundSheetRecords.size()]);
        }

        public ExternSheetRecord[] getExternSheetRecords() {
            return this.externSheetRecords.toArray(new ExternSheetRecord[this.externSheetRecords.size()]);
        }

        public SSTRecord getSSTRecord() {
            return this.sstRecord;
        }

        public HSSFWorkbook getStubHSSFWorkbook() {
            HSSFWorkbook hSSFWorkbook = HSSFWorkbook.create(this.getStubWorkbook());
            for (BoundSheetRecord boundSheetRecord : this.boundSheetRecords) {
                hSSFWorkbook.createSheet(boundSheetRecord.getSheetname());
            }
            return hSSFWorkbook;
        }

        public InternalWorkbook getStubWorkbook() {
            return EventWorkbookBuilder.createStubWorkbook(this.getExternSheetRecords(), this.getBoundSheetRecords(), this.getSSTRecord());
        }

        public void processRecord(Record record) {
            this.processRecordInternally(record);
            this.childListener.processRecord(record);
        }

        public void processRecordInternally(Record record) {
            if (record instanceof BoundSheetRecord) {
                this.boundSheetRecords.add((BoundSheetRecord)record);
            } else if (record instanceof ExternSheetRecord) {
                this.externSheetRecords.add((ExternSheetRecord)record);
            } else if (record instanceof SSTRecord) {
                this.sstRecord = (SSTRecord)record;
            }
        }
    }
}

