/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.eventmodel;

import ai2.org.apache.poi.hssf.eventmodel.ERFListener;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RecordFactory;
import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import java.io.InputStream;
import java.util.Arrays;

public final class EventRecordFactory {
    private final ERFListener _listener;
    private final short[] _sids;

    public EventRecordFactory(ERFListener eRFListener, short[] sArray) {
        this._listener = eRFListener;
        if (sArray == null) {
            this._sids = null;
        } else {
            this._sids = (short[])sArray.clone();
            Arrays.sort(this._sids);
        }
    }

    private boolean isSidIncluded(short s) {
        if (this._sids == null) {
            return true;
        }
        return Arrays.binarySearch(this._sids, s) >= 0;
    }

    private boolean processRecord(Record record) {
        if (!this.isSidIncluded(record.getSid())) {
            return true;
        }
        return this._listener.processRecord(record);
    }

    public void processRecords(InputStream inputStream) throws RecordFormatException {
        Record record = null;
        RecordInputStream recordInputStream = new RecordInputStream(inputStream);
        while (recordInputStream.hasNextRecord()) {
            recordInputStream.nextRecord();
            Record[] recordArray = RecordFactory.createRecord(recordInputStream);
            if (recordArray.length > 1) {
                for (int i = 0; i < recordArray.length; ++i) {
                    if (record != null && !this.processRecord(record)) {
                        return;
                    }
                    record = recordArray[i];
                }
                continue;
            }
            Record record2 = recordArray[0];
            if (record2 == null) continue;
            if (record != null && !this.processRecord(record)) {
                return;
            }
            record = record2;
        }
        if (record != null) {
            this.processRecord(record);
        }
    }
}

