/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.converter;

import ai2.org.apache.poi.hpsf.SummaryInformation;
import ai2.org.apache.poi.hssf.converter.AbstractExcelConverter;
import ai2.org.apache.poi.hssf.converter.ExcelToHtmlUtils;
import ai2.org.apache.poi.hssf.usermodel.HSSFCell;
import ai2.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import ai2.org.apache.poi.hssf.usermodel.HSSFFont;
import ai2.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import ai2.org.apache.poi.hssf.usermodel.HSSFRow;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai2.org.apache.poi.hssf.util.HSSFColor;
import ai2.org.apache.poi.hwpf.converter.HtmlDocumentFacade;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.XMLHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ExcelToHtmlConverter
extends AbstractExcelConverter {
    private static final POILogger logger = POILogFactory.getLogger(ExcelToHtmlConverter.class);
    private String cssClassContainerCell = null;
    private String cssClassContainerDiv = null;
    private String cssClassPrefixCell = "c";
    private String cssClassPrefixDiv = "d";
    private String cssClassPrefixRow = "r";
    private String cssClassPrefixTable = "t";
    private Map<Short, String> excelStyleToClass = new LinkedHashMap<Short, String>();
    private final HtmlDocumentFacade htmlDocumentFacade;
    private boolean useDivsToSpan = false;

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Usage: ExcelToHtmlConverter <inputFile.xls> <saveTo.html>");
            return;
        }
        System.out.println("Converting " + stringArray[0]);
        System.out.println("Saving output to " + stringArray[1]);
        try {
            Document document = ExcelToHtmlConverter.process(new File(stringArray[0]));
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(new File(stringArray[1]));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("method", "html");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Document process(File file) throws Exception {
        HSSFWorkbook hSSFWorkbook = ExcelToHtmlUtils.loadXls(file);
        ExcelToHtmlConverter excelToHtmlConverter = new ExcelToHtmlConverter(XMLHelper.getDocumentBuilderFactory().newDocumentBuilder().newDocument());
        excelToHtmlConverter.processWorkbook(hSSFWorkbook);
        Document document = excelToHtmlConverter.getDocument();
        hSSFWorkbook.close();
        return document;
    }

    public ExcelToHtmlConverter(Document document) {
        this.htmlDocumentFacade = new HtmlDocumentFacade(document);
    }

    public ExcelToHtmlConverter(HtmlDocumentFacade htmlDocumentFacade) {
        this.htmlDocumentFacade = htmlDocumentFacade;
    }

    protected String buildStyle(HSSFWorkbook hSSFWorkbook, HSSFCellStyle hSSFCellStyle) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("white-space:pre-wrap;");
        ExcelToHtmlUtils.appendAlign(stringBuilder, hSSFCellStyle.getAlignment());
        if (hSSFCellStyle.getFillPattern() != 0) {
            if (hSSFCellStyle.getFillPattern() == 1) {
                object = hSSFCellStyle.getFillForegroundColorColor();
                if (object != null) {
                    stringBuilder.append("background-color:" + ExcelToHtmlUtils.getColor((HSSFColor)object) + ";");
                }
            } else {
                object = hSSFCellStyle.getFillBackgroundColorColor();
                if (object != null) {
                    stringBuilder.append("background-color:" + ExcelToHtmlUtils.getColor((HSSFColor)object) + ";");
                }
            }
        }
        this.buildStyle_border(hSSFWorkbook, stringBuilder, "top", hSSFCellStyle.getBorderTop(), hSSFCellStyle.getTopBorderColor());
        this.buildStyle_border(hSSFWorkbook, stringBuilder, "right", hSSFCellStyle.getBorderRight(), hSSFCellStyle.getRightBorderColor());
        this.buildStyle_border(hSSFWorkbook, stringBuilder, "bottom", hSSFCellStyle.getBorderBottom(), hSSFCellStyle.getBottomBorderColor());
        this.buildStyle_border(hSSFWorkbook, stringBuilder, "left", hSSFCellStyle.getBorderLeft(), hSSFCellStyle.getLeftBorderColor());
        object = hSSFCellStyle.getFont(hSSFWorkbook);
        this.buildStyle_font(hSSFWorkbook, stringBuilder, (HSSFFont)object);
        return stringBuilder.toString();
    }

    private void buildStyle_border(HSSFWorkbook hSSFWorkbook, StringBuilder stringBuilder, String string, short s, short s2) {
        if (s == 0) {
            return;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(ExcelToHtmlUtils.getBorderWidth(s));
        stringBuilder2.append(' ');
        stringBuilder2.append(ExcelToHtmlUtils.getBorderStyle(s));
        HSSFColor hSSFColor = hSSFWorkbook.getCustomPalette().getColor(s2);
        if (hSSFColor != null) {
            stringBuilder2.append(' ');
            stringBuilder2.append(ExcelToHtmlUtils.getColor(hSSFColor));
        }
        stringBuilder.append("border-" + string + ":" + stringBuilder2 + ";");
    }

    void buildStyle_font(HSSFWorkbook hSSFWorkbook, StringBuilder stringBuilder, HSSFFont hSSFFont) {
        switch (hSSFFont.getBoldweight()) {
            case 700: {
                stringBuilder.append("font-weight:bold;");
                break;
            }
        }
        HSSFColor hSSFColor = hSSFWorkbook.getCustomPalette().getColor(hSSFFont.getColor());
        if (hSSFColor != null) {
            stringBuilder.append("color: " + ExcelToHtmlUtils.getColor(hSSFColor) + "; ");
        }
        if (hSSFFont.getFontHeightInPoints() != 0) {
            stringBuilder.append("font-size:" + hSSFFont.getFontHeightInPoints() + "pt;");
        }
        if (hSSFFont.getItalic()) {
            stringBuilder.append("font-style:italic;");
        }
    }

    public String getCssClassPrefixCell() {
        return this.cssClassPrefixCell;
    }

    public String getCssClassPrefixDiv() {
        return this.cssClassPrefixDiv;
    }

    public String getCssClassPrefixRow() {
        return this.cssClassPrefixRow;
    }

    public String getCssClassPrefixTable() {
        return this.cssClassPrefixTable;
    }

    public Document getDocument() {
        return this.htmlDocumentFacade.getDocument();
    }

    protected String getStyleClassName(HSSFWorkbook hSSFWorkbook, HSSFCellStyle hSSFCellStyle) {
        Short s = hSSFCellStyle.getIndex();
        String string = this.excelStyleToClass.get(s);
        if (string != null) {
            return string;
        }
        String string2 = this.buildStyle(hSSFWorkbook, hSSFCellStyle);
        String string3 = this.htmlDocumentFacade.getOrCreateCssClass(this.cssClassPrefixCell, string2);
        this.excelStyleToClass.put(s, string3);
        return string3;
    }

    public boolean isUseDivsToSpan() {
        return this.useDivsToSpan;
    }

    protected boolean processCell(HSSFCell hSSFCell, Element element, int n, int n2, float f) {
        Object object;
        Object object2;
        String string;
        HSSFCellStyle hSSFCellStyle = hSSFCell.getCellStyle();
        block0 : switch (hSSFCell.getCellType()) {
            case 1: {
                string = hSSFCell.getRichStringCellValue().getString();
                break;
            }
            case 2: {
                switch (hSSFCell.getCachedFormulaResultType()) {
                    case 1: {
                        HSSFRichTextString hSSFRichTextString = hSSFCell.getRichStringCellValue();
                        if (hSSFRichTextString != null && hSSFRichTextString.length() > 0) {
                            string = hSSFRichTextString.toString();
                            break block0;
                        }
                        string = "";
                        break block0;
                    }
                    case 0: {
                        HSSFCellStyle hSSFCellStyle2 = hSSFCellStyle;
                        if (hSSFCellStyle2 == null) {
                            string = String.valueOf(hSSFCell.getNumericCellValue());
                            break block0;
                        }
                        string = this._formatter.formatRawCellContents(hSSFCell.getNumericCellValue(), hSSFCellStyle2.getDataFormat(), hSSFCellStyle2.getDataFormatString());
                        break block0;
                    }
                    case 4: {
                        string = String.valueOf(hSSFCell.getBooleanCellValue());
                        break block0;
                    }
                    case 5: {
                        string = ErrorEval.getText(hSSFCell.getErrorCellValue());
                        break block0;
                    }
                }
                logger.log(5, new Object[]{"Unexpected cell cachedFormulaResultType (" + hSSFCell.getCachedFormulaResultType() + ")"});
                string = "";
                break;
            }
            case 3: {
                string = "";
                break;
            }
            case 0: {
                string = this._formatter.formatCellValue(hSSFCell);
                break;
            }
            case 4: {
                string = String.valueOf(hSSFCell.getBooleanCellValue());
                break;
            }
            case 5: {
                string = ErrorEval.getText(hSSFCell.getErrorCellValue());
                break;
            }
            default: {
                logger.log(5, new Object[]{"Unexpected cell type (" + hSSFCell.getCellType() + ")"});
                return true;
            }
        }
        boolean bl = ExcelToHtmlUtils.isEmpty(string);
        boolean bl2 = !bl && this.isUseDivsToSpan() && !hSSFCellStyle.getWrapText();
        short s = hSSFCellStyle.getIndex();
        if (s != 0) {
            object2 = hSSFCell.getRow().getSheet().getWorkbook();
            object = this.getStyleClassName((HSSFWorkbook)object2, hSSFCellStyle);
            if (bl2) {
                element.setAttribute("class", (String)object + " " + this.cssClassContainerCell);
            } else {
                element.setAttribute("class", (String)object);
            }
            if (bl) {
                string = "\u00a0";
            }
        }
        if (this.isOutputLeadingSpacesAsNonBreaking() && string.startsWith(" ")) {
            object2 = new StringBuilder();
            for (int i = 0; i < string.length() && string.charAt(i) == ' '; ++i) {
                ((StringBuilder)object2).append('\u00a0');
            }
            if (string.length() != ((StringBuilder)object2).length()) {
                ((StringBuilder)object2).append(string.substring(((StringBuilder)object2).length()));
            }
            string = ((StringBuilder)object2).toString();
        }
        object2 = this.htmlDocumentFacade.createText(string);
        if (bl2) {
            object = this.htmlDocumentFacade.createBlock();
            object.setAttribute("class", this.cssClassContainerDiv);
            Element element2 = this.htmlDocumentFacade.createBlock();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("position:absolute;min-width:");
            stringBuilder.append(n);
            stringBuilder.append("px;");
            if (n2 != Integer.MAX_VALUE) {
                stringBuilder.append("max-width:");
                stringBuilder.append(n2);
                stringBuilder.append("px;");
            }
            stringBuilder.append("overflow:hidden;max-height:");
            stringBuilder.append(f);
            stringBuilder.append("pt;white-space:nowrap;");
            ExcelToHtmlUtils.appendAlign(stringBuilder, hSSFCellStyle.getAlignment());
            this.htmlDocumentFacade.addStyleClass((Element)object, this.cssClassPrefixDiv, stringBuilder.toString());
            element2.appendChild((Node)object2);
            object.appendChild(element2);
            element.appendChild((Node)object);
        } else {
            element.appendChild((Node)object2);
        }
        return ExcelToHtmlUtils.isEmpty(string) && s == 0;
    }

    protected void processColumnHeaders(HSSFSheet hSSFSheet, int n, Element element) {
        Element element2 = this.htmlDocumentFacade.createTableHeader();
        element.appendChild(element2);
        Element element3 = this.htmlDocumentFacade.createTableRow();
        if (this.isOutputRowNumbers()) {
            element3.appendChild(this.htmlDocumentFacade.createTableHeaderCell());
        }
        for (int i = 0; i < n; ++i) {
            if (!this.isOutputHiddenColumns() && hSSFSheet.isColumnHidden(i)) continue;
            Element element4 = this.htmlDocumentFacade.createTableHeaderCell();
            String string = this.getColumnName(i);
            element4.appendChild(this.htmlDocumentFacade.createText(string));
            element3.appendChild(element4);
        }
        element2.appendChild(element3);
    }

    protected void processColumnWidths(HSSFSheet hSSFSheet, int n, Element element) {
        Element element2 = this.htmlDocumentFacade.createTableColumnGroup();
        if (this.isOutputRowNumbers()) {
            element2.appendChild(this.htmlDocumentFacade.createTableColumn());
        }
        for (int i = 0; i < n; ++i) {
            if (!this.isOutputHiddenColumns() && hSSFSheet.isColumnHidden(i)) continue;
            Element element3 = this.htmlDocumentFacade.createTableColumn();
            element3.setAttribute("width", String.valueOf(ExcelToHtmlConverter.getColumnWidth(hSSFSheet, i)));
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }

    protected void processDocumentInformation(SummaryInformation summaryInformation) {
        if (ExcelToHtmlUtils.isNotEmpty(summaryInformation.getTitle())) {
            this.htmlDocumentFacade.setTitle(summaryInformation.getTitle());
        }
        if (ExcelToHtmlUtils.isNotEmpty(summaryInformation.getAuthor())) {
            this.htmlDocumentFacade.addAuthor(summaryInformation.getAuthor());
        }
        if (ExcelToHtmlUtils.isNotEmpty(summaryInformation.getKeywords())) {
            this.htmlDocumentFacade.addKeywords(summaryInformation.getKeywords());
        }
        if (ExcelToHtmlUtils.isNotEmpty(summaryInformation.getComments())) {
            this.htmlDocumentFacade.addDescription(summaryInformation.getComments());
        }
    }

    protected int processRow(CellRangeAddress[][] cellRangeAddressArray, HSSFRow hSSFRow, Element element) {
        HSSFSheet hSSFSheet = hSSFRow.getSheet();
        int n = hSSFRow.getLastCellNum();
        if (n <= 0) {
            return 0;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(n);
        if (this.isOutputRowNumbers()) {
            Element element2 = this.htmlDocumentFacade.createTableHeaderCell();
            this.processRowNumber(hSSFRow, element2);
            arrayList.add(element2);
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            CellRangeAddress cellRangeAddress;
            if (!this.isOutputHiddenColumns() && hSSFSheet.isColumnHidden(i) || (cellRangeAddress = ExcelToHtmlUtils.getMergedRange(cellRangeAddressArray, hSSFRow.getRowNum(), i)) != null && (cellRangeAddress.getFirstColumn() != i || cellRangeAddress.getFirstRow() != hSSFRow.getRowNum())) continue;
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            int n4 = 0;
            if (this.isUseDivsToSpan()) {
                n4 = ExcelToHtmlConverter.getColumnWidth(hSSFSheet, i);
                boolean bl = false;
                for (n3 = i + 1; n3 < n; ++n3) {
                    if (!this.isOutputHiddenColumns() && hSSFSheet.isColumnHidden(n3)) continue;
                    if (hSSFRow.getCell(n3) != null && !this.isTextEmpty(hSSFRow.getCell(n3))) {
                        bl = true;
                        break;
                    }
                    n4 += ExcelToHtmlConverter.getColumnWidth(hSSFSheet, n3);
                }
                if (!bl) {
                    n4 = Integer.MAX_VALUE;
                }
            }
            Element element3 = this.htmlDocumentFacade.createTableCell();
            if (cellRangeAddress != null) {
                if (cellRangeAddress.getFirstColumn() != cellRangeAddress.getLastColumn()) {
                    element3.setAttribute("colspan", String.valueOf(cellRangeAddress.getLastColumn() - cellRangeAddress.getFirstColumn() + 1));
                }
                if (cellRangeAddress.getFirstRow() != cellRangeAddress.getLastRow()) {
                    element3.setAttribute("rowspan", String.valueOf(cellRangeAddress.getLastRow() - cellRangeAddress.getFirstRow() + 1));
                }
            }
            if ((n3 = hSSFCell != null ? (int)(this.processCell(hSSFCell, element3, ExcelToHtmlConverter.getColumnWidth(hSSFSheet, i), n4, (float)hSSFRow.getHeight() / 20.0f) ? 1 : 0) : 1) != 0) {
                arrayList.add(element3);
                continue;
            }
            for (Element element4 : arrayList) {
                element.appendChild(element4);
            }
            arrayList.clear();
            element.appendChild(element3);
            n2 = i;
        }
        return n2 + 1;
    }

    protected void processRowNumber(HSSFRow hSSFRow, Element element) {
        element.setAttribute("class", "rownumber");
        Text text = this.htmlDocumentFacade.createText(this.getRowName(hSSFRow));
        element.appendChild(text);
    }

    protected void processSheet(HSSFSheet hSSFSheet) {
        this.processSheetHeader(this.htmlDocumentFacade.getBody(), hSSFSheet);
        int n = hSSFSheet.getPhysicalNumberOfRows();
        if (n <= 0) {
            return;
        }
        Element element = this.htmlDocumentFacade.createTable();
        this.htmlDocumentFacade.addStyleClass(element, this.cssClassPrefixTable, "border-collapse:collapse;border-spacing:0;");
        Element element2 = this.htmlDocumentFacade.createTableBody();
        CellRangeAddress[][] cellRangeAddressArray = ExcelToHtmlUtils.buildMergedRangesMap(hSSFSheet);
        ArrayList<Element> arrayList = new ArrayList<Element>(n);
        int n2 = 1;
        for (int i = hSSFSheet.getFirstRowNum(); i <= hSSFSheet.getLastRowNum(); ++i) {
            HSSFRow hSSFRow = hSSFSheet.getRow(i);
            if (hSSFRow == null || !this.isOutputHiddenRows() && hSSFRow.getZeroHeight()) continue;
            Element element3 = this.htmlDocumentFacade.createTableRow();
            this.htmlDocumentFacade.addStyleClass(element3, this.cssClassPrefixRow, "height:" + (float)hSSFRow.getHeight() / 20.0f + "pt;");
            int n3 = this.processRow(cellRangeAddressArray, hSSFRow, element3);
            if (n3 == 0) {
                arrayList.add(element3);
            } else {
                if (!arrayList.isEmpty()) {
                    for (Element element4 : arrayList) {
                        element2.appendChild(element4);
                    }
                    arrayList.clear();
                }
                element2.appendChild(element3);
            }
            n2 = Math.max(n2, n3);
        }
        this.processColumnWidths(hSSFSheet, n2, element);
        if (this.isOutputColumnHeaders()) {
            this.processColumnHeaders(hSSFSheet, n2, element);
        }
        element.appendChild(element2);
        this.htmlDocumentFacade.getBody().appendChild(element);
    }

    protected void processSheetHeader(Element element, HSSFSheet hSSFSheet) {
        Element element2 = this.htmlDocumentFacade.createHeader2();
        element2.appendChild(this.htmlDocumentFacade.createText(hSSFSheet.getSheetName()));
        element.appendChild(element2);
    }

    public void processWorkbook(HSSFWorkbook hSSFWorkbook) {
        SummaryInformation summaryInformation = hSSFWorkbook.getSummaryInformation();
        if (summaryInformation != null) {
            this.processDocumentInformation(summaryInformation);
        }
        if (this.isUseDivsToSpan()) {
            this.cssClassContainerCell = this.htmlDocumentFacade.getOrCreateCssClass(this.cssClassPrefixCell, "padding:0;margin:0;align:left;vertical-align:top;");
            this.cssClassContainerDiv = this.htmlDocumentFacade.getOrCreateCssClass(this.cssClassPrefixDiv, "position:relative;");
        }
        for (int i = 0; i < hSSFWorkbook.getNumberOfSheets(); ++i) {
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(i);
            this.processSheet(hSSFSheet);
        }
        this.htmlDocumentFacade.updateStylesheet();
    }

    public void setCssClassPrefixCell(String string) {
        this.cssClassPrefixCell = string;
    }

    public void setCssClassPrefixDiv(String string) {
        this.cssClassPrefixDiv = string;
    }

    public void setCssClassPrefixRow(String string) {
        this.cssClassPrefixRow = string;
    }

    public void setCssClassPrefixTable(String string) {
        this.cssClassPrefixTable = string;
    }

    public void setUseDivsToSpan(boolean bl) {
        this.useDivsToSpan = bl;
    }
}

