/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf.parsers;

import ai2.org.apache.poi.hsmf.datatypes.AttachmentChunks;
import ai2.org.apache.poi.hsmf.datatypes.ByteChunk;
import ai2.org.apache.poi.hsmf.datatypes.Chunk;
import ai2.org.apache.poi.hsmf.datatypes.ChunkGroup;
import ai2.org.apache.poi.hsmf.datatypes.Chunks;
import ai2.org.apache.poi.hsmf.datatypes.DirectoryChunk;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import ai2.org.apache.poi.hsmf.datatypes.MessagePropertiesChunk;
import ai2.org.apache.poi.hsmf.datatypes.MessageSubmissionChunk;
import ai2.org.apache.poi.hsmf.datatypes.NameIdChunks;
import ai2.org.apache.poi.hsmf.datatypes.RecipientChunks;
import ai2.org.apache.poi.hsmf.datatypes.StoragePropertiesChunk;
import ai2.org.apache.poi.hsmf.datatypes.StringChunk;
import ai2.org.apache.poi.hsmf.datatypes.Types;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai2.org.apache.poi.poifs.filesystem.DocumentNode;
import ai2.org.apache.poi.poifs.filesystem.Entry;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.util.ArrayList;

public final class POIFSChunkParser {
    private static POILogger logger = POILogFactory.getLogger(POIFSChunkParser.class);

    public static ChunkGroup[] parse(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        return POIFSChunkParser.parse(nPOIFSFileSystem.getRoot());
    }

    public static ChunkGroup[] parse(DirectoryNode directoryNode) throws IOException {
        Chunks chunks = new Chunks();
        ArrayList<ChunkGroup> arrayList = new ArrayList<ChunkGroup>();
        arrayList.add(chunks);
        for (Entry object : directoryNode) {
            if (!(object instanceof DirectoryNode)) continue;
            DirectoryNode directoryNode2 = (DirectoryNode)object;
            ChunkGroup chunkGroup = null;
            if (directoryNode2.getName().startsWith("__attach_version1.0_#")) {
                chunkGroup = new AttachmentChunks(directoryNode2.getName());
            }
            if (directoryNode2.getName().startsWith("__nameid_version1.0")) {
                chunkGroup = new NameIdChunks();
            }
            if (directoryNode2.getName().startsWith("__recip_version1.0_#")) {
                chunkGroup = new RecipientChunks(directoryNode2.getName());
            }
            if (chunkGroup == null) continue;
            POIFSChunkParser.processChunks(directoryNode2, chunkGroup);
            arrayList.add(chunkGroup);
        }
        POIFSChunkParser.processChunks(directoryNode, chunks);
        for (ChunkGroup chunkGroup : arrayList) {
            chunkGroup.chunksComplete();
        }
        return arrayList.toArray(new ChunkGroup[arrayList.size()]);
    }

    protected static void processChunks(DirectoryNode directoryNode, ChunkGroup chunkGroup) {
        for (Entry entry : directoryNode) {
            if (entry instanceof DocumentNode) {
                POIFSChunkParser.process(entry, chunkGroup);
                continue;
            }
            if (!(entry instanceof DirectoryNode) || !entry.getName().endsWith(Types.DIRECTORY.asFileEnding())) continue;
            POIFSChunkParser.process(entry, chunkGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void process(Entry entry, ChunkGroup chunkGroup) {
        String string = entry.getName();
        Chunk chunk = null;
        if (string.equals("__properties_version1.0")) {
            chunk = chunkGroup instanceof Chunks ? new MessagePropertiesChunk(chunkGroup) : new StoragePropertiesChunk(chunkGroup);
        } else {
            if (string.length() < 9) {
                return;
            }
            if (string.indexOf(95) == -1) {
                return;
            }
            int n = string.lastIndexOf(95);
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            if (string2.equals("Olk10SideProps") || string2.equals("Olk10SideProps_")) {
                return;
            }
            if (n > string.length() - 8) {
                throw new IllegalArgumentException("Invalid chunk name " + string);
            }
            try {
                int n2 = Integer.parseInt(string3.substring(0, 4), 16);
                int n3 = Integer.parseInt(string3.substring(4, 8), 16);
                Types.MAPIType mAPIType = Types.getById(n3);
                if (mAPIType == null) {
                    mAPIType = Types.createCustom(n3);
                }
                if (n2 == MAPIProperty.MESSAGE_SUBMISSION_ID.id) {
                    chunk = new MessageSubmissionChunk(string2, n2, mAPIType);
                } else if (mAPIType == Types.BINARY) {
                    chunk = new ByteChunk(string2, n2, mAPIType);
                } else if (mAPIType == Types.DIRECTORY) {
                    if (entry instanceof DirectoryNode) {
                        chunk = new DirectoryChunk((DirectoryNode)entry, string2, n2, mAPIType);
                    }
                } else if (mAPIType == Types.ASCII_STRING || mAPIType == Types.UNICODE_STRING) {
                    chunk = new StringChunk(string2, n2, mAPIType);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        if (chunk != null) {
            if (entry instanceof DocumentNode) {
                DocumentInputStream documentInputStream = null;
                try {
                    documentInputStream = new DocumentInputStream((DocumentNode)entry);
                    ((Chunk)chunk).readValue(documentInputStream);
                    chunkGroup.record(chunk);
                }
                catch (IOException iOException) {
                    logger.log(7, new Object[]{"Error reading from part " + entry.getName() + " - " + iOException.toString()});
                }
                finally {
                    if (documentInputStream != null) {
                        documentInputStream.close();
                    }
                }
            } else {
                chunkGroup.record(chunk);
            }
        }
    }
}

