/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf.dev;

import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesLister {
    public void listByName(PrintStream printStream) {
        ArrayList<MAPIProperty> arrayList = new ArrayList<MAPIProperty>(MAPIProperty.getAll());
        Collections.sort(arrayList, new Comparator<MAPIProperty>(){

            @Override
            public int compare(MAPIProperty mAPIProperty, MAPIProperty mAPIProperty2) {
                return mAPIProperty.name.compareTo(mAPIProperty2.name);
            }
        });
        this.list(arrayList, printStream);
    }

    public void listById(PrintStream printStream) {
        ArrayList<MAPIProperty> arrayList = new ArrayList<MAPIProperty>(MAPIProperty.getAll());
        Collections.sort(arrayList, new Comparator<MAPIProperty>(){

            @Override
            public int compare(MAPIProperty mAPIProperty, MAPIProperty mAPIProperty2) {
                if (mAPIProperty.id < mAPIProperty2.id) {
                    return -1;
                }
                if (mAPIProperty.id > mAPIProperty2.id) {
                    return 1;
                }
                return 0;
            }
        });
        this.list(arrayList, printStream);
    }

    private void list(ArrayList<MAPIProperty> arrayList, PrintStream printStream) {
        for (MAPIProperty mAPIProperty : arrayList) {
            String string = Integer.toHexString(mAPIProperty.id);
            while (string.length() < 4) {
                string = "0" + string;
            }
            int n = mAPIProperty.usualType.getId();
            String string2 = Integer.toString(n);
            if (n > 0) {
                string2 = string2 + " / 0x" + Integer.toHexString(n);
            }
            printStream.println("0x" + string + " - " + mAPIProperty.name);
            printStream.println("   " + mAPIProperty.id + " - " + mAPIProperty.usualType.getName() + " (" + string2 + ") - " + mAPIProperty.mapiProperty);
        }
    }

    public static void main(String[] stringArray) {
        TypesLister typesLister = new TypesLister();
        typesLister.listByName(System.out);
        System.out.println();
        typesLister.listById(System.out);
    }
}

