/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf.dev;

import ai2.org.apache.poi.hsmf.datatypes.Chunk;
import ai2.org.apache.poi.hsmf.datatypes.ChunkGroup;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import ai2.org.apache.poi.hsmf.datatypes.PropertiesChunk;
import ai2.org.apache.poi.hsmf.datatypes.PropertyValue;
import ai2.org.apache.poi.hsmf.parsers.POIFSChunkParser;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class HSMFDump {
    private NPOIFSFileSystem fs;

    public HSMFDump(NPOIFSFileSystem nPOIFSFileSystem) {
        this.fs = nPOIFSFileSystem;
    }

    public void dump() throws IOException {
        this.dump(System.out);
    }

    public void dump(PrintStream printStream) throws IOException {
        ChunkGroup[] chunkGroupArray;
        for (ChunkGroup chunkGroup : chunkGroupArray = POIFSChunkParser.parse(this.fs)) {
            printStream.println(chunkGroup.getClass().getSimpleName());
            for (Chunk chunk : chunkGroup.getChunks()) {
                Object object;
                MAPIProperty mAPIProperty = MAPIProperty.get(chunk.getChunkId());
                if (chunk instanceof PropertiesChunk) {
                    object = (PropertiesChunk)chunk;
                    printStream.println("   Properties - " + ((PropertiesChunk)object).getProperties().size() + ":");
                    for (MAPIProperty mAPIProperty2 : ((PropertiesChunk)object).getProperties().keySet()) {
                        printStream.println("       * " + mAPIProperty2);
                        for (PropertyValue propertyValue : ((PropertiesChunk)object).getValues(mAPIProperty2)) {
                            printStream.println("        = " + propertyValue.toString());
                        }
                    }
                    continue;
                }
                object = mAPIProperty.id + " - " + mAPIProperty.name;
                if (mAPIProperty == MAPIProperty.UNKNOWN) {
                    object = chunk.getChunkId() + " - (unknown)";
                }
                printStream.println("   " + (String)object + " - " + chunk.getType().getName());
                printStream.println("       " + chunk.toString());
            }
            printStream.println();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        for (String string : stringArray) {
            NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(new File(string), true);
            HSMFDump hSMFDump = new HSMFDump(nPOIFSFileSystem);
            hSMFDump.dump();
            nPOIFSFileSystem.close();
        }
    }
}

