/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf.datatypes;

import ai2.org.apache.poi.hsmf.datatypes.ByteChunk;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LocaleUtil;
import java.math.BigInteger;
import java.util.Calendar;

public class PropertyValue {
    private MAPIProperty property;
    private long flags;
    protected byte[] data;

    public PropertyValue(MAPIProperty mAPIProperty, long l, byte[] byArray) {
        this.property = mAPIProperty;
        this.flags = l;
        this.data = byArray;
    }

    public MAPIProperty getProperty() {
        return this.property;
    }

    public long getFlags() {
        return this.flags;
    }

    public Object getValue() {
        return this.data;
    }

    public void setRawValue(byte[] byArray) {
        this.data = byArray;
    }

    public String toString() {
        Object object = this.getValue();
        if (object == null) {
            return "(No value available)";
        }
        if (object instanceof byte[]) {
            return ByteChunk.toDebugFriendlyString((byte[])object);
        }
        return object.toString();
    }

    public static class TimePropertyValue
    extends PropertyValue {
        private static final long OFFSET = 11644473600000L;

        public TimePropertyValue(MAPIProperty mAPIProperty, long l, byte[] byArray) {
            super(mAPIProperty, l, byArray);
        }

        public Calendar getValue() {
            long l = LittleEndian.getLong(this.data);
            l = l / 10L / 1000L - 11644473600000L;
            Calendar calendar = LocaleUtil.getLocaleCalendar();
            calendar.setTimeInMillis(l);
            return calendar;
        }

        public void setValue(Calendar calendar) {
            if (this.data.length != 8) {
                this.data = new byte[8];
            }
            long l = calendar.getTimeInMillis();
            l = (l + 11644473600000L) * 10L * 1000L;
            LittleEndian.putLong(this.data, 0, l);
        }
    }

    public static class CurrencyPropertyValue
    extends PropertyValue {
        private static final BigInteger SHIFT = BigInteger.valueOf(10000L);

        public CurrencyPropertyValue(MAPIProperty mAPIProperty, long l, byte[] byArray) {
            super(mAPIProperty, l, byArray);
        }

        public BigInteger getValue() {
            long l = LittleEndian.getLong(this.data);
            return BigInteger.valueOf(l).divide(SHIFT);
        }

        public void setValue(BigInteger bigInteger) {
            if (this.data.length != 8) {
                this.data = new byte[8];
            }
            long l = bigInteger.multiply(SHIFT).longValue();
            LittleEndian.putLong(this.data, 0, l);
        }
    }

    public static class DoublePropertyValue
    extends PropertyValue {
        public DoublePropertyValue(MAPIProperty mAPIProperty, long l, byte[] byArray) {
            super(mAPIProperty, l, byArray);
        }

        public Double getValue() {
            return LittleEndian.getDouble(this.data);
        }

        public void setValue(double d) {
            if (this.data.length != 8) {
                this.data = new byte[8];
            }
            LittleEndian.putDouble(this.data, 0, d);
        }
    }

    public static class FloatPropertyValue
    extends PropertyValue {
        public FloatPropertyValue(MAPIProperty mAPIProperty, long l, byte[] byArray) {
            super(mAPIProperty, l, byArray);
        }

        public Float getValue() {
            return Float.valueOf(LittleEndian.getFloat(this.data));
        }

        public void setValue(float f) {
            if (this.data.length != 4) {
                this.data = new byte[4];
            }
            LittleEndian.putFloat(this.data, 0, f);
        }
    }

    public static class LongLongPropertyValue
    extends PropertyValue {
        public LongLongPropertyValue(MAPIProperty mAPIProperty, long l, byte[] byArray) {
            super(mAPIProperty, l, byArray);
        }

        public Long getValue() {
            return LittleEndian.getLong(this.data);
        }

        public void setValue(long l) {
            if (this.data.length != 8) {
                this.data = new byte[8];
            }
            LittleEndian.putLong(this.data, 0, l);
        }
    }

    public static class LongPropertyValue
    extends PropertyValue {
        public LongPropertyValue(MAPIProperty mAPIProperty, long l, byte[] byArray) {
            super(mAPIProperty, l, byArray);
        }

        public Integer getValue() {
            return LittleEndian.getInt(this.data);
        }

        public void setValue(int n) {
            if (this.data.length != 4) {
                this.data = new byte[4];
            }
            LittleEndian.putInt(this.data, 0, n);
        }
    }

    public static class ShortPropertyValue
    extends PropertyValue {
        public ShortPropertyValue(MAPIProperty mAPIProperty, long l, byte[] byArray) {
            super(mAPIProperty, l, byArray);
        }

        public Short getValue() {
            return LittleEndian.getShort(this.data);
        }

        public void setValue(short s) {
            if (this.data.length != 2) {
                this.data = new byte[2];
            }
            LittleEndian.putShort(this.data, 0, s);
        }
    }

    public static class BooleanPropertyValue
    extends PropertyValue {
        public BooleanPropertyValue(MAPIProperty mAPIProperty, long l, byte[] byArray) {
            super(mAPIProperty, l, byArray);
        }

        public Boolean getValue() {
            short s = LittleEndian.getShort(this.data);
            return s > 0;
        }

        public void setValue(boolean bl) {
            if (this.data.length != 2) {
                this.data = new byte[2];
            }
            if (bl) {
                LittleEndian.putShort(this.data, 0, (short)1);
            }
        }
    }

    public static class NullPropertyValue
    extends PropertyValue {
        public NullPropertyValue(MAPIProperty mAPIProperty, long l, byte[] byArray) {
            super(mAPIProperty, l, byArray);
        }

        public Void getValue() {
            return null;
        }
    }
}

