/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf.datatypes;

import ai2.org.apache.poi.hsmf.datatypes.Chunk;
import ai2.org.apache.poi.hsmf.datatypes.ChunkBasedPropertyValue;
import ai2.org.apache.poi.hsmf.datatypes.ChunkGroup;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import ai2.org.apache.poi.hsmf.datatypes.PropertyValue;
import ai2.org.apache.poi.hsmf.datatypes.Types;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertiesChunk
extends Chunk {
    public static final String NAME = "__properties_version1.0";
    private POILogger logger = POILogFactory.getLogger(PropertiesChunk.class);
    private Map<MAPIProperty, PropertyValue> properties = new HashMap<MAPIProperty, PropertyValue>();
    private ChunkGroup parentGroup;

    protected PropertiesChunk(ChunkGroup chunkGroup) {
        super(NAME, -1, Types.UNKNOWN);
        this.parentGroup = chunkGroup;
    }

    @Override
    public String getEntryName() {
        return NAME;
    }

    public Map<MAPIProperty, PropertyValue> getRawProperties() {
        return this.properties;
    }

    public Map<MAPIProperty, List<PropertyValue>> getProperties() {
        HashMap<MAPIProperty, List<PropertyValue>> hashMap = new HashMap<MAPIProperty, List<PropertyValue>>(this.properties.size());
        for (MAPIProperty mAPIProperty : this.properties.keySet()) {
            hashMap.put(mAPIProperty, this.getValues(mAPIProperty));
        }
        return hashMap;
    }

    public List<PropertyValue> getValues(MAPIProperty mAPIProperty) {
        PropertyValue propertyValue = this.properties.get(mAPIProperty);
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof ChunkBasedPropertyValue) {
            return Collections.emptyList();
        }
        return Collections.singletonList(propertyValue);
    }

    public PropertyValue getRawValue(MAPIProperty mAPIProperty) {
        return this.properties.get(mAPIProperty);
    }

    protected void matchVariableSizedPropertiesToChunks() {
        HashMap<Integer, Chunk> hashMap = new HashMap<Integer, Chunk>();
        for (Chunk chunk : this.parentGroup.getChunks()) {
            hashMap.put(chunk.chunkId, chunk);
        }
        for (PropertyValue propertyValue : this.properties.values()) {
            Chunk chunk;
            if (!(propertyValue instanceof ChunkBasedPropertyValue)) continue;
            ChunkBasedPropertyValue chunkBasedPropertyValue = (ChunkBasedPropertyValue)propertyValue;
            chunk = (Chunk)hashMap.get(chunkBasedPropertyValue.getProperty().id);
            if (chunk != null) {
                chunkBasedPropertyValue.setValue(chunk);
                continue;
            }
            this.logger.log(5, new Object[]{"No chunk found matching Property " + chunkBasedPropertyValue});
        }
    }

    protected void readProperties(InputStream inputStream) throws IOException {
        boolean bl = true;
        while (bl) {
            try {
                Object object;
                int n = LittleEndian.readUShort(inputStream);
                int n2 = LittleEndian.readUShort(inputStream);
                long l = LittleEndian.readUInt(inputStream);
                Types.MAPIType mAPIType = Types.getById(n);
                MAPIProperty mAPIProperty = MAPIProperty.get(n2);
                if (mAPIProperty == MAPIProperty.UNKNOWN) {
                    mAPIProperty = MAPIProperty.createCustom(n2, mAPIType, "Unknown " + n2);
                }
                if (mAPIType == null) {
                    this.logger.log(5, "Invalid type found, expected ", mAPIProperty.usualType, " but got ", n, " for property ", mAPIProperty);
                    bl = false;
                    break;
                }
                if (!(mAPIProperty.usualType == mAPIType || mAPIType == Types.ASCII_STRING && mAPIProperty.usualType == Types.UNICODE_STRING || mAPIType == Types.UNICODE_STRING && mAPIProperty.usualType == Types.ASCII_STRING)) {
                    if (mAPIProperty.usualType == Types.UNKNOWN) {
                        this.logger.log(3, "Property definition for ", mAPIProperty, " is missing a type definition, found a value with type ", mAPIType);
                    } else {
                        this.logger.log(5, "Type mismatch, expected ", mAPIProperty.usualType, " but got ", mAPIType, " for property ", mAPIProperty);
                        bl = false;
                        break;
                    }
                }
                boolean bl2 = false;
                int n3 = mAPIType.getLength();
                if (!mAPIType.isFixedLength()) {
                    bl2 = true;
                    n3 = 8;
                }
                byte[] byArray = new byte[n3];
                IOUtils.readFully(inputStream, byArray);
                if (n3 < 8) {
                    object = new byte[8 - n3];
                    IOUtils.readFully(inputStream, (byte[])object);
                }
                object = null;
                object = bl2 ? (Object)new ChunkBasedPropertyValue(mAPIProperty, l, byArray) : (mAPIType == Types.NULL ? (Object)new PropertyValue.NullPropertyValue(mAPIProperty, l, byArray) : (mAPIType == Types.BOOLEAN ? (Object)new PropertyValue.BooleanPropertyValue(mAPIProperty, l, byArray) : (mAPIType == Types.SHORT ? (Object)new PropertyValue.ShortPropertyValue(mAPIProperty, l, byArray) : (mAPIType == Types.LONG ? (Object)new PropertyValue.LongPropertyValue(mAPIProperty, l, byArray) : (mAPIType == Types.LONG_LONG ? (Object)new PropertyValue.LongLongPropertyValue(mAPIProperty, l, byArray) : (mAPIType == Types.FLOAT ? (Object)new PropertyValue.FloatPropertyValue(mAPIProperty, l, byArray) : (mAPIType == Types.DOUBLE ? (Object)new PropertyValue.DoublePropertyValue(mAPIProperty, l, byArray) : (mAPIType == Types.CURRENCY ? (Object)new PropertyValue.CurrencyPropertyValue(mAPIProperty, l, byArray) : (mAPIType == Types.TIME ? (Object)new PropertyValue.TimePropertyValue(mAPIProperty, l, byArray) : (Object)new PropertyValue(mAPIProperty, l, byArray))))))))));
                if (this.properties.get(mAPIProperty) != null) {
                    this.logger.log(5, new Object[]{"Duplicate values found for " + mAPIProperty});
                }
                this.properties.put(mAPIProperty, (PropertyValue)object);
            }
            catch (LittleEndian.BufferUnderrunException bufferUnderrunException) {
                bl = false;
            }
        }
    }

    protected void writeProperties(OutputStream outputStream) throws IOException {
    }
}

