/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf.datatypes;

import ai2.org.apache.poi.hsmf.datatypes.Chunk;
import ai2.org.apache.poi.hsmf.datatypes.Types;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageSubmissionChunk
extends Chunk {
    private static POILogger logger = POILogFactory.getLogger(MessageSubmissionChunk.class);
    private String rawId;
    private Calendar date;
    private static final Pattern datePatern = Pattern.compile("(\\d\\d)(\\d\\d)(\\d\\d)(\\d\\d)(\\d\\d)(\\d\\d)Z?");

    public MessageSubmissionChunk(String string, int n, Types.MAPIType mAPIType) {
        super(string, n, mAPIType);
    }

    public MessageSubmissionChunk(int n, Types.MAPIType mAPIType) {
        super(n, mAPIType);
    }

    public void readValue(InputStream inputStream) throws IOException {
        String[] stringArray;
        byte[] byArray = IOUtils.toByteArray(inputStream);
        this.rawId = new String(byArray, Charset.forName("ASCII"));
        for (String string : stringArray = this.rawId.split(";")) {
            int n;
            if (!string.startsWith("l=")) continue;
            String string2 = null;
            int n2 = string.lastIndexOf(45);
            if (n2 != -1 && (n = string.lastIndexOf(45, n2 - 1)) != -1 && n2 > n) {
                string2 = string.substring(n + 1, n2);
            }
            if (string2 == null) continue;
            Matcher matcher = datePatern.matcher(string2);
            if (matcher.matches()) {
                int n3;
                this.date = LocaleUtil.getLocaleCalendar();
                this.date.set(1, n3 + ((n3 = Integer.parseInt(matcher.group(1))) > 80 ? 1900 : 2000));
                this.date.set(2, Integer.parseInt(matcher.group(2)) - 1);
                this.date.set(5, Integer.parseInt(matcher.group(3)));
                this.date.set(11, Integer.parseInt(matcher.group(4)));
                this.date.set(12, Integer.parseInt(matcher.group(5)));
                this.date.set(13, Integer.parseInt(matcher.group(6)));
                this.date.clear(14);
                continue;
            }
            logger.log(5, new Object[]{"Warning - unable to make sense of date " + string2});
        }
    }

    public void writeValue(OutputStream outputStream) throws IOException {
        byte[] byArray = this.rawId.getBytes(Charset.forName("ASCII"));
        outputStream.write(byArray);
    }

    public Calendar getAcceptedAtTime() {
        return this.date;
    }

    public String getSubmissionId() {
        return this.rawId;
    }
}

