/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf.datatypes;

import ai2.org.apache.poi.hsmf.datatypes.ChunkGroup;
import ai2.org.apache.poi.hsmf.datatypes.PropertiesChunk;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MessagePropertiesChunk
extends PropertiesChunk {
    private long nextRecipientId;
    private long nextAttachmentId;
    private long recipientCount;
    private long attachmentCount;

    public MessagePropertiesChunk(ChunkGroup chunkGroup) {
        super(chunkGroup);
    }

    public long getNextRecipientId() {
        return this.nextRecipientId;
    }

    public long getNextAttachmentId() {
        return this.nextAttachmentId;
    }

    public long getRecipientCount() {
        return this.recipientCount;
    }

    public long getAttachmentCount() {
        return this.attachmentCount;
    }

    public void readValue(InputStream inputStream) throws IOException {
        LittleEndian.readLong(inputStream);
        this.nextRecipientId = LittleEndian.readUInt(inputStream);
        this.nextAttachmentId = LittleEndian.readUInt(inputStream);
        this.recipientCount = LittleEndian.readUInt(inputStream);
        this.attachmentCount = LittleEndian.readUInt(inputStream);
        LittleEndian.readLong(inputStream);
        this.readProperties(inputStream);
    }

    public void writeValue(OutputStream outputStream) throws IOException {
        outputStream.write(new byte[8]);
        LittleEndian.putUInt(this.nextRecipientId, outputStream);
        LittleEndian.putUInt(this.nextAttachmentId, outputStream);
        LittleEndian.putUInt(this.recipientCount, outputStream);
        LittleEndian.putUInt(this.attachmentCount, outputStream);
        outputStream.write(new byte[8]);
        this.writeProperties(outputStream);
    }
}

