/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf.datatypes;

import ai2.org.apache.poi.hsmf.datatypes.ByteChunk;
import ai2.org.apache.poi.hsmf.datatypes.Chunk;
import ai2.org.apache.poi.hsmf.datatypes.ChunkGroupWithProperties;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import ai2.org.apache.poi.hsmf.datatypes.MessagePropertiesChunk;
import ai2.org.apache.poi.hsmf.datatypes.MessageSubmissionChunk;
import ai2.org.apache.poi.hsmf.datatypes.PropertyValue;
import ai2.org.apache.poi.hsmf.datatypes.StringChunk;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Chunks
implements ChunkGroupWithProperties {
    private static POILogger logger = POILogFactory.getLogger(Chunks.class);
    private Map<MAPIProperty, List<Chunk>> allChunks = new HashMap<MAPIProperty, List<Chunk>>();
    public StringChunk messageClass;
    public StringChunk textBodyChunk;
    public StringChunk htmlBodyChunkString;
    public ByteChunk htmlBodyChunkBinary;
    public ByteChunk rtfBodyChunk;
    public StringChunk subjectChunk;
    public StringChunk displayToChunk;
    public StringChunk displayFromChunk;
    public StringChunk displayCCChunk;
    public StringChunk displayBCCChunk;
    public StringChunk conversationTopic;
    public StringChunk sentByServerType;
    public StringChunk messageHeaders;
    public MessageSubmissionChunk submissionChunk;
    public StringChunk emailFromChunk;
    public StringChunk messageId;
    private MessagePropertiesChunk messageProperties;

    @Override
    public Map<MAPIProperty, List<PropertyValue>> getProperties() {
        if (this.messageProperties != null) {
            return this.messageProperties.getProperties();
        }
        return Collections.emptyMap();
    }

    public Map<MAPIProperty, PropertyValue> getRawProperties() {
        if (this.messageProperties != null) {
            return this.messageProperties.getRawProperties();
        }
        return Collections.emptyMap();
    }

    public Map<MAPIProperty, List<Chunk>> getAll() {
        return this.allChunks;
    }

    @Override
    public Chunk[] getChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>(this.allChunks.size());
        for (List<Chunk> list : this.allChunks.values()) {
            arrayList.addAll(list);
        }
        return arrayList.toArray(new Chunk[arrayList.size()]);
    }

    @Override
    public void record(Chunk chunk) {
        MAPIProperty mAPIProperty = MAPIProperty.get(chunk.getChunkId());
        if (mAPIProperty == MAPIProperty.MESSAGE_CLASS) {
            this.messageClass = (StringChunk)chunk;
        } else if (mAPIProperty == MAPIProperty.INTERNET_MESSAGE_ID) {
            this.messageId = (StringChunk)chunk;
        } else if (mAPIProperty == MAPIProperty.MESSAGE_SUBMISSION_ID) {
            this.submissionChunk = (MessageSubmissionChunk)chunk;
        } else if (mAPIProperty == MAPIProperty.RECEIVED_BY_ADDRTYPE) {
            this.sentByServerType = (StringChunk)chunk;
        } else if (mAPIProperty == MAPIProperty.TRANSPORT_MESSAGE_HEADERS) {
            this.messageHeaders = (StringChunk)chunk;
        } else if (mAPIProperty == MAPIProperty.CONVERSATION_TOPIC) {
            this.conversationTopic = (StringChunk)chunk;
        } else if (mAPIProperty == MAPIProperty.SUBJECT) {
            this.subjectChunk = (StringChunk)chunk;
        } else if (mAPIProperty != MAPIProperty.ORIGINAL_SUBJECT) {
            if (mAPIProperty == MAPIProperty.DISPLAY_TO) {
                this.displayToChunk = (StringChunk)chunk;
            } else if (mAPIProperty == MAPIProperty.DISPLAY_CC) {
                this.displayCCChunk = (StringChunk)chunk;
            } else if (mAPIProperty == MAPIProperty.DISPLAY_BCC) {
                this.displayBCCChunk = (StringChunk)chunk;
            } else if (mAPIProperty == MAPIProperty.SENDER_EMAIL_ADDRESS) {
                this.emailFromChunk = (StringChunk)chunk;
            } else if (mAPIProperty == MAPIProperty.SENDER_NAME) {
                this.displayFromChunk = (StringChunk)chunk;
            } else if (mAPIProperty == MAPIProperty.BODY) {
                this.textBodyChunk = (StringChunk)chunk;
            } else if (mAPIProperty == MAPIProperty.BODY_HTML) {
                if (chunk instanceof StringChunk) {
                    this.htmlBodyChunkString = (StringChunk)chunk;
                }
                if (chunk instanceof ByteChunk) {
                    this.htmlBodyChunkBinary = (ByteChunk)chunk;
                }
            } else if (mAPIProperty == MAPIProperty.RTF_COMPRESSED) {
                this.rtfBodyChunk = (ByteChunk)chunk;
            } else if (chunk instanceof MessagePropertiesChunk) {
                this.messageProperties = (MessagePropertiesChunk)chunk;
            }
        }
        if (this.allChunks.get(mAPIProperty) == null) {
            this.allChunks.put(mAPIProperty, new ArrayList());
        }
        this.allChunks.get(mAPIProperty).add(chunk);
    }

    @Override
    public void chunksComplete() {
        if (this.messageProperties != null) {
            this.messageProperties.matchVariableSizedPropertiesToChunks();
        } else {
            logger.log(5, new Object[]{"Message didn't contain a root list of properties!"});
        }
    }
}

