/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf.datatypes;

import ai2.org.apache.poi.hsmf.datatypes.Types;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

public abstract class Chunk {
    public static final String DEFAULT_NAME_PREFIX = "__substg1.0_";
    protected int chunkId;
    protected Types.MAPIType type;
    protected String namePrefix;

    protected Chunk(String string, int n, Types.MAPIType mAPIType) {
        this.namePrefix = string;
        this.chunkId = n;
        this.type = mAPIType;
    }

    protected Chunk(int n, Types.MAPIType mAPIType) {
        this(DEFAULT_NAME_PREFIX, n, mAPIType);
    }

    public int getChunkId() {
        return this.chunkId;
    }

    public Types.MAPIType getType() {
        return this.type;
    }

    public String getEntryName() {
        String string = this.type.asFileEnding();
        String string2 = Integer.toHexString(this.chunkId);
        while (string2.length() < 4) {
            string2 = "0" + string2;
        }
        return this.namePrefix + string2.toUpperCase(Locale.ROOT) + string.toUpperCase(Locale.ROOT);
    }

    public abstract void writeValue(OutputStream var1) throws IOException;

    public abstract void readValue(InputStream var1) throws IOException;
}

