/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf.datatypes;

import ai2.org.apache.poi.hsmf.datatypes.Chunk;
import ai2.org.apache.poi.hsmf.datatypes.StringChunk;
import ai2.org.apache.poi.hsmf.datatypes.Types;
import ai2.org.apache.poi.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteChunk
extends Chunk {
    private byte[] value;

    public ByteChunk(String string, int n, Types.MAPIType mAPIType) {
        super(string, n, mAPIType);
    }

    public ByteChunk(int n, Types.MAPIType mAPIType) {
        super(n, mAPIType);
    }

    public void readValue(InputStream inputStream) throws IOException {
        this.value = IOUtils.toByteArray(inputStream);
    }

    public void writeValue(OutputStream outputStream) throws IOException {
        outputStream.write(this.value);
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] byArray) {
        this.value = byArray;
    }

    public String toString() {
        return ByteChunk.toDebugFriendlyString(this.value);
    }

    protected static String toDebugFriendlyString(byte[] byArray) {
        if (byArray == null) {
            return "(Null Byte Array)";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Bytes len=").append(byArray.length);
        stringBuffer.append(" [");
        int n = Math.min(byArray.length, 16);
        if (byArray.length > 16) {
            n = 12;
        }
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(byArray[i]);
        }
        if (byArray.length > 16) {
            stringBuffer.append(",....");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getAs7bitString() {
        return StringChunk.parseAs7BitData(this.value);
    }
}

