/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.util;

import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LocaleUtil;
import java.util.Calendar;
import java.util.Date;

public final class SystemTimeUtils {
    public static Date getDate(byte[] byArray) {
        return SystemTimeUtils.getDate(byArray, 0);
    }

    public static Date getDate(byte[] byArray, int n) {
        Calendar calendar = LocaleUtil.getLocaleCalendar();
        calendar.set(1, LittleEndian.getShort(byArray, n));
        calendar.set(2, LittleEndian.getShort(byArray, n + 2) - 1);
        calendar.set(5, LittleEndian.getShort(byArray, n + 6));
        calendar.set(11, LittleEndian.getShort(byArray, n + 8));
        calendar.set(12, LittleEndian.getShort(byArray, n + 10));
        calendar.set(13, LittleEndian.getShort(byArray, n + 12));
        calendar.set(14, LittleEndian.getShort(byArray, n + 14));
        return calendar.getTime();
    }

    public static void storeDate(Date date, byte[] byArray) {
        SystemTimeUtils.storeDate(date, byArray, 0);
    }

    public static void storeDate(Date date, byte[] byArray, int n) {
        Calendar calendar = LocaleUtil.getLocaleCalendar();
        calendar.setTime(date);
        LittleEndian.putShort(byArray, n + 0, (short)calendar.get(1));
        LittleEndian.putShort(byArray, n + 2, (short)(calendar.get(2) + 1));
        LittleEndian.putShort(byArray, n + 4, (short)(calendar.get(7) - 1));
        LittleEndian.putShort(byArray, n + 6, (short)calendar.get(5));
        LittleEndian.putShort(byArray, n + 8, (short)calendar.get(11));
        LittleEndian.putShort(byArray, n + 10, (short)calendar.get(12));
        LittleEndian.putShort(byArray, n + 12, (short)calendar.get(13));
        LittleEndian.putShort(byArray, n + 14, (short)calendar.get(14));
    }
}

