/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.hslf.model.textproperties.BitMaskTextProp;
import ai2.org.apache.poi.hslf.model.textproperties.TextProp;
import ai2.org.apache.poi.hslf.model.textproperties.TextPropCollection;
import ai2.org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShow;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.sl.draw.DrawPaint;
import ai2.org.apache.poi.sl.usermodel.PaintStyle;
import ai2.org.apache.poi.sl.usermodel.TextRun;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.awt.Color;

public final class HSLFTextRun
implements TextRun {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    private HSLFTextParagraph parentParagraph;
    private String _runText = "";
    private String _fontFamily;
    private TextPropCollection characterStyle = new TextPropCollection(1, TextPropCollection.TextPropType.character);

    public HSLFTextRun(HSLFTextParagraph hSLFTextParagraph) {
        this.parentParagraph = hSLFTextParagraph;
    }

    public TextPropCollection getCharacterStyle() {
        return this.characterStyle;
    }

    public void setCharacterStyle(TextPropCollection textPropCollection) {
        assert (textPropCollection != null);
        this.characterStyle = textPropCollection;
    }

    public void updateSheet() {
        if (this._fontFamily != null) {
            this.setFontFamily(this._fontFamily);
            this._fontFamily = null;
        }
    }

    public int getLength() {
        return this._runText.length();
    }

    public String getRawText() {
        return this._runText;
    }

    public void setText(String string) {
        this._runText = HSLFTextParagraph.toInternalString(string);
    }

    private boolean isCharFlagsTextPropVal(int n) {
        return this.getFlag(n);
    }

    protected boolean getFlag(int n) {
        if (this.characterStyle == null) {
            return false;
        }
        BitMaskTextProp bitMaskTextProp = (BitMaskTextProp)this.characterStyle.findByName("char_flags");
        if (bitMaskTextProp == null) {
            int n2 = this.parentParagraph.getRunType();
            HSLFSheet hSLFSheet = this.parentParagraph.getSheet();
            if (hSLFSheet != null) {
                HSLFMasterSheet hSLFMasterSheet = hSLFSheet.getMasterSheet();
                if (hSLFMasterSheet != null) {
                    bitMaskTextProp = (BitMaskTextProp)hSLFMasterSheet.getStyleAttribute(n2, this.parentParagraph.getIndentLevel(), "char_flags", true);
                }
            } else {
                this.logger.log(5, new Object[]{"MasterSheet is not available"});
            }
        }
        return bitMaskTextProp == null ? false : bitMaskTextProp.getSubValue(n);
    }

    private void setCharFlagsTextPropVal(int n, boolean bl) {
        if (this.getFlag(n) != bl) {
            this.setFlag(n, bl);
            this.parentParagraph.setDirty();
        }
    }

    public void setCharTextPropVal(String string, Integer n) {
        HSLFTextParagraph.setPropVal(this.characterStyle, string, n);
        this.parentParagraph.setDirty();
    }

    public boolean isBold() {
        return this.isCharFlagsTextPropVal(0);
    }

    public void setBold(boolean bl) {
        this.setCharFlagsTextPropVal(0, bl);
    }

    public boolean isItalic() {
        return this.isCharFlagsTextPropVal(1);
    }

    public void setItalic(boolean bl) {
        this.setCharFlagsTextPropVal(1, bl);
    }

    public boolean isUnderlined() {
        return this.isCharFlagsTextPropVal(2);
    }

    public void setUnderlined(boolean bl) {
        this.setCharFlagsTextPropVal(2, bl);
    }

    public boolean isShadowed() {
        return this.isCharFlagsTextPropVal(4);
    }

    public void setShadowed(boolean bl) {
        this.setCharFlagsTextPropVal(4, bl);
    }

    public boolean isEmbossed() {
        return this.isCharFlagsTextPropVal(9);
    }

    public void setEmbossed(boolean bl) {
        this.setCharFlagsTextPropVal(9, bl);
    }

    public boolean isStrikethrough() {
        return this.isCharFlagsTextPropVal(8);
    }

    public void setStrikethrough(boolean bl) {
        this.setCharFlagsTextPropVal(8, bl);
    }

    public int getSuperscript() {
        TextProp textProp = HSLFTextParagraph.getPropVal(this.characterStyle, "superscript", this.parentParagraph);
        return textProp == null ? 0 : textProp.getValue();
    }

    public void setSuperscript(int n) {
        this.setCharTextPropVal("superscript", n);
    }

    public Double getFontSize() {
        TextProp textProp = HSLFTextParagraph.getPropVal(this.characterStyle, "font.size", this.parentParagraph);
        return textProp == null ? null : Double.valueOf(textProp.getValue());
    }

    public void setFontSize(Double d) {
        Integer n = d == null ? null : Integer.valueOf(d.intValue());
        this.setCharTextPropVal("font.size", n);
    }

    public int getFontIndex() {
        TextProp textProp = HSLFTextParagraph.getPropVal(this.characterStyle, "font.index", this.parentParagraph);
        return textProp == null ? -1 : textProp.getValue();
    }

    public void setFontIndex(int n) {
        this.setCharTextPropVal("font.index", n);
    }

    public void setFontFamily(String string) {
        HSLFSlideShow hSLFSlideShow;
        HSLFSheet hSLFSheet = this.parentParagraph.getSheet();
        HSLFSlideShow hSLFSlideShow2 = hSLFSlideShow = hSLFSheet == null ? null : hSLFSheet.getSlideShow();
        if (hSLFSheet == null || hSLFSlideShow == null) {
            this._fontFamily = string;
            return;
        }
        int n = hSLFSlideShow.getFontCollection().addFont(string);
        this.setCharTextPropVal("font.index", n);
    }

    public String getFontFamily() {
        HSLFSlideShow hSLFSlideShow;
        HSLFSheet hSLFSheet = this.parentParagraph.getSheet();
        HSLFSlideShow hSLFSlideShow2 = hSLFSlideShow = hSLFSheet == null ? null : hSLFSheet.getSlideShow();
        if (hSLFSheet == null || hSLFSlideShow == null) {
            return this._fontFamily;
        }
        TextProp textProp = HSLFTextParagraph.getPropVal(this.characterStyle, "font.index", this.parentParagraph);
        if (textProp == null) {
            return null;
        }
        return hSLFSlideShow.getFontCollection().getFontWithId(textProp.getValue());
    }

    public PaintStyle.SolidPaint getFontColor() {
        TextProp textProp = HSLFTextParagraph.getPropVal(this.characterStyle, "font.color", this.parentParagraph);
        if (textProp == null) {
            return null;
        }
        Color color = HSLFTextParagraph.getColorFromColorIndexStruct(textProp.getValue(), this.parentParagraph.getSheet());
        PaintStyle.SolidPaint solidPaint = DrawPaint.createSolidPaint(color);
        return solidPaint;
    }

    public void setFontColor(int n) {
        this.setCharTextPropVal("font.color", n);
    }

    public void setFontColor(Color color) {
        this.setFontColor(DrawPaint.createSolidPaint(color));
    }

    public void setFontColor(PaintStyle paintStyle) {
        if (!(paintStyle instanceof PaintStyle.SolidPaint)) {
            throw new IllegalArgumentException("HSLF only supports solid paint");
        }
        PaintStyle.SolidPaint solidPaint = (PaintStyle.SolidPaint)paintStyle;
        Color color = DrawPaint.applyColorTransform(solidPaint.getSolidColor());
        int n = new Color(color.getBlue(), color.getGreen(), color.getRed(), 254).getRGB();
        this.setFontColor(n);
    }

    protected void setFlag(int n, boolean bl) {
        BitMaskTextProp bitMaskTextProp = (BitMaskTextProp)this.characterStyle.addWithName("char_flags");
        bitMaskTextProp.setSubValue(bl, n);
    }

    public HSLFTextParagraph getTextParagraph() {
        return this.parentParagraph;
    }

    public TextRun.TextCap getTextCap() {
        return TextRun.TextCap.NONE;
    }

    public boolean isSubscript() {
        return false;
    }

    public boolean isSuperscript() {
        return false;
    }

    public byte getPitchAndFamily() {
        return 0;
    }
}

