/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.hslf.model.PPFont;
import ai2.org.apache.poi.hslf.model.textproperties.BitMaskTextProp;
import ai2.org.apache.poi.hslf.model.textproperties.IndentProp;
import ai2.org.apache.poi.hslf.model.textproperties.TextPFException9;
import ai2.org.apache.poi.hslf.model.textproperties.TextProp;
import ai2.org.apache.poi.hslf.model.textproperties.TextPropCollection;
import ai2.org.apache.poi.hslf.record.ColorSchemeAtom;
import ai2.org.apache.poi.hslf.record.EscherTextboxWrapper;
import ai2.org.apache.poi.hslf.record.FontCollection;
import ai2.org.apache.poi.hslf.record.MasterTextPropAtom;
import ai2.org.apache.poi.hslf.record.OutlineTextRefAtom;
import ai2.org.apache.poi.hslf.record.PPDrawing;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.record.SlideListWithText;
import ai2.org.apache.poi.hslf.record.SlidePersistAtom;
import ai2.org.apache.poi.hslf.record.StyleTextProp9Atom;
import ai2.org.apache.poi.hslf.record.StyleTextPropAtom;
import ai2.org.apache.poi.hslf.record.TextBytesAtom;
import ai2.org.apache.poi.hslf.record.TextCharsAtom;
import ai2.org.apache.poi.hslf.record.TextHeaderAtom;
import ai2.org.apache.poi.hslf.record.TextRulerAtom;
import ai2.org.apache.poi.hslf.record.TextSpecInfoAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextRun;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextShape;
import ai2.org.apache.poi.sl.draw.DrawPaint;
import ai2.org.apache.poi.sl.usermodel.AutoNumberingScheme;
import ai2.org.apache.poi.sl.usermodel.PaintStyle;
import ai2.org.apache.poi.sl.usermodel.TextParagraph;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.StringUtil;
import ai2.org.apache.poi.util.Units;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSLFTextParagraph
implements TextParagraph<HSLFShape, HSLFTextParagraph, HSLFTextRun> {
    protected static final POILogger logger = POILogFactory.getLogger(HSLFTextParagraph.class);
    static final int AlignLeft = 0;
    static final int AlignCenter = 1;
    static final int AlignRight = 2;
    static final int AlignJustify = 3;
    private final TextHeaderAtom _headerAtom;
    private TextBytesAtom _byteAtom;
    private TextCharsAtom _charAtom;
    private final TextPropCollection _paragraphStyle = new TextPropCollection(1, TextPropCollection.TextPropType.paragraph);
    protected TextRulerAtom _ruler;
    protected final List<HSLFTextRun> _runs = new ArrayList<HSLFTextRun>();
    protected HSLFTextShape _parentShape;
    private HSLFSheet _sheet;
    private int shapeId;
    private StyleTextProp9Atom styleTextProp9Atom;
    private boolean _dirty = false;

    HSLFTextParagraph(TextHeaderAtom textHeaderAtom, TextBytesAtom textBytesAtom, TextCharsAtom textCharsAtom) {
        if (textHeaderAtom == null) {
            throw new IllegalArgumentException("TextHeaderAtom must be set.");
        }
        this._headerAtom = textHeaderAtom;
        this._byteAtom = textBytesAtom;
        this._charAtom = textCharsAtom;
    }

    HSLFTextParagraph(HSLFTextParagraph hSLFTextParagraph) {
        this._headerAtom = hSLFTextParagraph._headerAtom;
        this._byteAtom = hSLFTextParagraph._byteAtom;
        this._charAtom = hSLFTextParagraph._charAtom;
        this._parentShape = hSLFTextParagraph._parentShape;
        this._sheet = hSLFTextParagraph._sheet;
        this._ruler = hSLFTextParagraph._ruler;
        this.shapeId = hSLFTextParagraph.shapeId;
        this._paragraphStyle.copy(hSLFTextParagraph._paragraphStyle);
    }

    public void addTextRun(HSLFTextRun hSLFTextRun) {
        this._runs.add(hSLFTextRun);
    }

    public List<HSLFTextRun> getTextRuns() {
        return this._runs;
    }

    public TextPropCollection getParagraphStyle() {
        return this._paragraphStyle;
    }

    public void setParagraphStyle(TextPropCollection textPropCollection) {
        this._paragraphStyle.copy(textPropCollection);
    }

    public void supplySheet(HSLFSheet hSLFSheet) {
        this._sheet = hSLFSheet;
        if (this._runs == null) {
            return;
        }
        for (HSLFTextRun hSLFTextRun : this._runs) {
            hSLFTextRun.updateSheet();
        }
    }

    public HSLFSheet getSheet() {
        return this._sheet;
    }

    protected int getShapeId() {
        return this.shapeId;
    }

    protected void setShapeId(int n) {
        this.shapeId = n;
    }

    protected int getIndex() {
        return this._headerAtom != null ? this._headerAtom.getIndex() : -1;
    }

    protected void setIndex(int n) {
        if (this._headerAtom != null) {
            this._headerAtom.setIndex(n);
        }
    }

    public int getRunType() {
        return this._headerAtom != null ? this._headerAtom.getTextType() : -1;
    }

    public void setRunType(int n) {
        if (this._headerAtom != null) {
            this._headerAtom.setTextType(n);
        }
    }

    public boolean isDrawingBased() {
        return this.getIndex() == -1;
    }

    public TextRulerAtom getTextRuler() {
        return this._ruler;
    }

    public TextRulerAtom createTextRuler() {
        this._ruler = this.getTextRuler();
        if (this._ruler == null) {
            this._ruler = TextRulerAtom.getParagraphInstance();
            RecordAtom recordAtom = this._byteAtom;
            if (recordAtom == null) {
                recordAtom = this._charAtom;
            }
            if (recordAtom == null) {
                recordAtom = this._headerAtom;
            }
            this._headerAtom.getParentRecord().addChildAfter(this._ruler, recordAtom);
        }
        return this._ruler;
    }

    public Record[] getRecords() {
        Record[] recordArray = this._headerAtom.getParentRecord().getChildRecords();
        return HSLFTextParagraph.getRecords(recordArray, new int[]{0}, this._headerAtom);
    }

    private static Record[] getRecords(Record[] recordArray, int[] nArray, TextHeaderAtom textHeaderAtom) {
        Record[] recordArray2;
        Record record;
        if (recordArray == null) {
            throw new NullPointerException("records need to be set.");
        }
        while (nArray[0] < recordArray.length && (!((record = recordArray[nArray[0]]) instanceof TextHeaderAtom) || textHeaderAtom != null && record != textHeaderAtom)) {
            nArray[0] = nArray[0] + 1;
        }
        if (nArray[0] >= recordArray.length) {
            logger.log(3, new Object[]{"header atom wasn't found - container might contain only an OutlineTextRefAtom"});
            return new Record[0];
        }
        int n = 1;
        while (nArray[0] + n < recordArray.length && !((recordArray2 = recordArray[nArray[0] + n]) instanceof TextHeaderAtom) && !(recordArray2 instanceof SlidePersistAtom)) {
            ++n;
        }
        recordArray2 = new Record[n];
        System.arraycopy(recordArray, nArray[0], recordArray2, 0, n);
        nArray[0] = nArray[0] + n;
        return recordArray2;
    }

    public void setStyleTextProp9Atom(StyleTextProp9Atom styleTextProp9Atom) {
        this.styleTextProp9Atom = styleTextProp9Atom;
    }

    public StyleTextProp9Atom getStyleTextProp9Atom() {
        return this.styleTextProp9Atom;
    }

    @Override
    public Iterator<HSLFTextRun> iterator() {
        return this._runs.iterator();
    }

    @Override
    public Double getLeftMargin() {
        TextProp textProp = HSLFTextParagraph.getPropVal(this._paragraphStyle, "text.offset", this);
        return textProp == null ? null : Double.valueOf(Units.masterToPoints(textProp.getValue()));
    }

    @Override
    public void setLeftMargin(Double d) {
        Integer n = d == null ? null : Integer.valueOf(Units.pointsToMaster(d));
        this.setParagraphTextPropVal("text.offset", n);
    }

    @Override
    public Double getRightMargin() {
        return null;
    }

    @Override
    public void setRightMargin(Double d) {
    }

    @Override
    public Double getIndent() {
        TextProp textProp = HSLFTextParagraph.getPropVal(this._paragraphStyle, "bullet.offset", this);
        return textProp == null ? null : Double.valueOf(Units.masterToPoints(textProp.getValue()));
    }

    @Override
    public void setIndent(Double d) {
        Integer n = d == null ? null : Integer.valueOf(Units.pointsToMaster(d));
        this.setParagraphTextPropVal("bullet.offset", n);
    }

    @Override
    public String getDefaultFontFamily() {
        String string = null;
        if (!this._runs.isEmpty()) {
            string = this._runs.get(0).getFontFamily();
        }
        return string != null ? string : "Arial";
    }

    @Override
    public Double getDefaultFontSize() {
        Double d = null;
        if (!this._runs.isEmpty()) {
            d = this._runs.get(0).getFontSize();
        }
        return d != null ? d : 12.0;
    }

    public void setAlignment(TextParagraph.TextAlign textAlign) {
        Integer n = null;
        if (textAlign != null) {
            switch (textAlign) {
                default: {
                    n = 0;
                    break;
                }
                case CENTER: {
                    n = 1;
                    break;
                }
                case RIGHT: {
                    n = 2;
                    break;
                }
                case DIST: {
                    n = 4;
                    break;
                }
                case JUSTIFY: {
                    n = 3;
                    break;
                }
                case JUSTIFY_LOW: {
                    n = 6;
                    break;
                }
                case THAI_DIST: {
                    n = 5;
                }
            }
        }
        this.setParagraphTextPropVal("alignment", n);
    }

    @Override
    public TextParagraph.TextAlign getTextAlign() {
        TextProp textProp = HSLFTextParagraph.getPropVal(this._paragraphStyle, "alignment", this);
        if (textProp == null) {
            return null;
        }
        switch (textProp.getValue()) {
            default: {
                return TextParagraph.TextAlign.LEFT;
            }
            case 1: {
                return TextParagraph.TextAlign.CENTER;
            }
            case 2: {
                return TextParagraph.TextAlign.RIGHT;
            }
            case 3: {
                return TextParagraph.TextAlign.JUSTIFY;
            }
            case 6: {
                return TextParagraph.TextAlign.JUSTIFY_LOW;
            }
            case 4: {
                return TextParagraph.TextAlign.DIST;
            }
            case 5: 
        }
        return TextParagraph.TextAlign.THAI_DIST;
    }

    @Override
    public TextParagraph.FontAlign getFontAlign() {
        TextProp textProp = HSLFTextParagraph.getPropVal(this._paragraphStyle, "fontAlign", this);
        if (textProp == null) {
            return null;
        }
        switch (textProp.getValue()) {
            case 0: {
                return TextParagraph.FontAlign.BASELINE;
            }
            case 1: {
                return TextParagraph.FontAlign.TOP;
            }
            case 2: {
                return TextParagraph.FontAlign.CENTER;
            }
            case 3: {
                return TextParagraph.FontAlign.BOTTOM;
            }
        }
        return TextParagraph.FontAlign.AUTO;
    }

    public AutoNumberingScheme getAutoNumberingScheme() {
        if (this.styleTextProp9Atom == null) {
            return null;
        }
        TextPFException9[] textPFException9Array = this.styleTextProp9Atom.getAutoNumberTypes();
        int n = this.getIndentLevel();
        if (textPFException9Array == null || n >= textPFException9Array.length) {
            return null;
        }
        return textPFException9Array[n].getAutoNumberScheme();
    }

    public Integer getAutoNumberingStartAt() {
        if (this.styleTextProp9Atom == null) {
            return null;
        }
        TextPFException9[] textPFException9Array = this.styleTextProp9Atom.getAutoNumberTypes();
        int n = this.getIndentLevel();
        if (textPFException9Array == null || n >= textPFException9Array.length) {
            return null;
        }
        Short s = textPFException9Array[n].getAutoNumberStartNumber();
        assert (s != null);
        return s.intValue();
    }

    @Override
    public TextParagraph.BulletStyle getBulletStyle() {
        if (!this.isBullet() && this.getAutoNumberingScheme() == null) {
            return null;
        }
        return new TextParagraph.BulletStyle(){

            public String getBulletCharacter() {
                Character c = HSLFTextParagraph.this.getBulletChar();
                return c == null || c.charValue() == '\u0000' ? "" : "" + c;
            }

            public String getBulletFont() {
                return HSLFTextParagraph.this.getBulletFont();
            }

            public Double getBulletFontSize() {
                return HSLFTextParagraph.this.getBulletSize();
            }

            public void setBulletFontColor(Color color) {
                this.setBulletFontColor(DrawPaint.createSolidPaint(color));
            }

            public void setBulletFontColor(PaintStyle paintStyle) {
                if (!(paintStyle instanceof PaintStyle.SolidPaint)) {
                    throw new IllegalArgumentException("HSLF only supports SolidPaint");
                }
                PaintStyle.SolidPaint solidPaint = (PaintStyle.SolidPaint)paintStyle;
                Color color = DrawPaint.applyColorTransform(solidPaint.getSolidColor());
                HSLFTextParagraph.this.setBulletColor(color);
            }

            public PaintStyle getBulletFontColor() {
                Color color = HSLFTextParagraph.this.getBulletColor();
                return DrawPaint.createSolidPaint(color);
            }

            public AutoNumberingScheme getAutoNumberingScheme() {
                return HSLFTextParagraph.this.getAutoNumberingScheme();
            }

            public Integer getAutoNumberingStartAt() {
                return HSLFTextParagraph.this.getAutoNumberingStartAt();
            }
        };
    }

    public HSLFTextShape getParentShape() {
        return this._parentShape;
    }

    public void setParentShape(HSLFTextShape hSLFTextShape) {
        this._parentShape = hSLFTextShape;
    }

    @Override
    public int getIndentLevel() {
        return this._paragraphStyle == null ? 0 : (int)this._paragraphStyle.getIndentLevel();
    }

    @Override
    public void setIndentLevel(int n) {
        if (this._paragraphStyle != null) {
            this._paragraphStyle.setIndentLevel((short)n);
        }
    }

    public void setBullet(boolean bl) {
        this.setFlag(0, bl);
    }

    public boolean isBullet() {
        return this.getFlag(0);
    }

    public void setBulletChar(Character c) {
        Integer n = c == null ? null : Integer.valueOf(c.charValue());
        this.setParagraphTextPropVal("bullet.char", n);
    }

    public Character getBulletChar() {
        TextProp textProp = HSLFTextParagraph.getPropVal(this._paragraphStyle, "bullet.char", this);
        return textProp == null ? null : Character.valueOf((char)textProp.getValue());
    }

    public void setBulletSize(Double d) {
        this.setPctOrPoints("bullet.size", d);
    }

    public Double getBulletSize() {
        return this.getPctOrPoints("bullet.size");
    }

    public void setBulletColor(Color color) {
        Integer n = color == null ? null : Integer.valueOf(new Color(color.getBlue(), color.getGreen(), color.getRed(), 254).getRGB());
        this.setParagraphTextPropVal("bullet.color", n);
    }

    public Color getBulletColor() {
        TextProp textProp = HSLFTextParagraph.getPropVal(this._paragraphStyle, "bullet.color", this);
        if (textProp == null) {
            if (this._runs.isEmpty()) {
                return null;
            }
            PaintStyle.SolidPaint solidPaint = this._runs.get(0).getFontColor();
            return DrawPaint.applyColorTransform(solidPaint.getSolidColor());
        }
        return HSLFTextParagraph.getColorFromColorIndexStruct(textProp.getValue(), this._sheet);
    }

    public void setBulletFont(String string) {
        if (string == null) {
            HSLFTextParagraph.setPropVal(this._paragraphStyle, "bullet.font", null);
            this.setFlag(1, false);
        }
        FontCollection fontCollection = this.getSheet().getSlideShow().getFontCollection();
        int n = fontCollection.addFont(string);
        this.setParagraphTextPropVal("bullet.font", n);
        this.setFlag(1, true);
    }

    public String getBulletFont() {
        TextProp textProp = HSLFTextParagraph.getPropVal(this._paragraphStyle, "bullet.font", this);
        if (textProp == null) {
            return this.getDefaultFontFamily();
        }
        PPFont pPFont = this.getSheet().getSlideShow().getFont(textProp.getValue());
        assert (pPFont != null);
        return pPFont.getFontName();
    }

    @Override
    public void setLineSpacing(Double d) {
        this.setPctOrPoints("linespacing", d);
    }

    @Override
    public Double getLineSpacing() {
        return this.getPctOrPoints("linespacing");
    }

    @Override
    public void setSpaceBefore(Double d) {
        this.setPctOrPoints("spacebefore", d);
    }

    @Override
    public Double getSpaceBefore() {
        return this.getPctOrPoints("spacebefore");
    }

    @Override
    public void setSpaceAfter(Double d) {
        this.setPctOrPoints("spaceafter", d);
    }

    @Override
    public Double getSpaceAfter() {
        return this.getPctOrPoints("spaceafter");
    }

    @Override
    public Double getDefaultTabSize() {
        return null;
    }

    private Double getPctOrPoints(String string) {
        TextProp textProp = HSLFTextParagraph.getPropVal(this._paragraphStyle, string, this);
        if (textProp == null) {
            return null;
        }
        int n = textProp.getValue();
        return n < 0 ? Units.masterToPoints(n) : (double)n;
    }

    private void setPctOrPoints(String string, Double d) {
        Integer n = null;
        if (d != null) {
            n = d < 0.0 ? Units.pointsToMaster(d) : d.intValue();
        }
        this.setParagraphTextPropVal(string, n);
    }

    private boolean getFlag(int n) {
        BitMaskTextProp bitMaskTextProp = (BitMaskTextProp)HSLFTextParagraph.getPropVal(this._paragraphStyle, "paragraph_flags", this);
        return bitMaskTextProp == null ? false : bitMaskTextProp.getSubValue(n);
    }

    private void setFlag(int n, boolean bl) {
        BitMaskTextProp bitMaskTextProp = (BitMaskTextProp)this._paragraphStyle.addWithName("paragraph_flags");
        bitMaskTextProp.setSubValue(bl, n);
        this.setDirty();
    }

    protected static TextProp getPropVal(TextPropCollection textPropCollection, String string, HSLFTextParagraph hSLFTextParagraph) {
        boolean bl;
        TextProp textProp = textPropCollection.findByName(string);
        if (textProp != null) {
            return textProp;
        }
        BitMaskTextProp bitMaskTextProp = (BitMaskTextProp)textPropCollection.findByName("paragraph_flags");
        boolean bl2 = bl = bitMaskTextProp != null && bitMaskTextProp.getValue() == 0;
        if (bl) {
            return null;
        }
        HSLFSheet hSLFSheet = hSLFTextParagraph.getSheet();
        int n = hSLFTextParagraph.getRunType();
        HSLFMasterSheet hSLFMasterSheet = hSLFSheet.getMasterSheet();
        if (hSLFMasterSheet == null) {
            logger.log(5, new Object[]{"MasterSheet is not available"});
            return null;
        }
        boolean bl3 = textPropCollection.getTextPropType() == TextPropCollection.TextPropType.character;
        return hSLFMasterSheet.getStyleAttribute(n, hSLFTextParagraph.getIndentLevel(), string, bl3);
    }

    protected static void setPropVal(TextPropCollection textPropCollection, String string, Integer n) {
        if (n == null) {
            textPropCollection.removeByName(string);
            return;
        }
        TextProp textProp = textPropCollection.addWithName(string);
        textProp.setValue(n);
    }

    protected static void fixLineEndings(List<HSLFTextParagraph> list) {
        HSLFTextRun hSLFTextRun = null;
        for (HSLFTextParagraph hSLFTextParagraph : list) {
            List<HSLFTextRun> list2;
            if (hSLFTextRun != null && !hSLFTextRun.getRawText().endsWith("\r")) {
                hSLFTextRun.setText(hSLFTextRun.getRawText() + "\r");
            }
            if ((list2 = hSLFTextParagraph.getTextRuns()).isEmpty()) {
                throw new RuntimeException("paragraph without textruns found");
            }
            hSLFTextRun = list2.get(list2.size() - 1);
            assert (hSLFTextRun.getRawText() != null);
        }
    }

    private static StyleTextPropAtom findStyleAtomPresent(TextHeaderAtom textHeaderAtom, int n) {
        boolean bl = false;
        StyleTextPropAtom styleTextPropAtom = null;
        for (Record record : textHeaderAtom.getParentRecord().getChildRecords()) {
            long l = record.getRecordType();
            if (bl && l == (long)RecordTypes.TextHeaderAtom.typeID) break;
            if (!(bl |= textHeaderAtom == record) || l != (long)RecordTypes.StyleTextPropAtom.typeID) continue;
            styleTextPropAtom = (StyleTextPropAtom)record;
        }
        if (styleTextPropAtom == null) {
            logger.log(3, new Object[]{"styles atom doesn't exist. Creating dummy record for later saving."});
            styleTextPropAtom = new StyleTextPropAtom(n < 0 ? 1 : n);
        } else if (n >= 0) {
            styleTextPropAtom.setParentTextSize(n);
        }
        return styleTextPropAtom;
    }

    /*
     * WARNING - void declaration
     */
    protected static void storeText(List<HSLFTextParagraph> list) {
        void var14_19;
        Object object2;
        HSLFTextParagraph.fixLineEndings(list);
        String string = HSLFTextParagraph.toInternalString(HSLFTextParagraph.getRawText(list));
        boolean bl = StringUtil.hasMultibyte(string);
        TextHeaderAtom textHeaderAtom = list.get((int)0)._headerAtom;
        TextBytesAtom textBytesAtom = list.get((int)0)._byteAtom;
        TextCharsAtom textCharsAtom = list.get((int)0)._charAtom;
        StyleTextPropAtom styleTextPropAtom = HSLFTextParagraph.findStyleAtomPresent(textHeaderAtom, string.length());
        RecordAtom recordAtom = null;
        RecordAtom recordAtom2 = null;
        if (bl) {
            if (textBytesAtom != null || textCharsAtom == null) {
                recordAtom = textBytesAtom;
                textCharsAtom = new TextCharsAtom();
            }
            recordAtom2 = textCharsAtom;
            textCharsAtom.setText(string);
        } else {
            if (textCharsAtom != null || textBytesAtom == null) {
                recordAtom = textCharsAtom;
                textBytesAtom = new TextBytesAtom();
            }
            recordAtom2 = textBytesAtom;
            object2 = new byte[string.length()];
            StringUtil.putCompressedUnicode(string, (byte[])object2, 0);
            textBytesAtom.setText((byte[])object2);
        }
        assert (recordAtom2 != null);
        object2 = textHeaderAtom.getParentRecord();
        Record[] recordArray = ((RecordContainer)object2).getChildRecords();
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < recordArray.length; ++i) {
            Record object3 = recordArray[i];
            if (object3 == textHeaderAtom) continue;
            if (object3 == recordAtom || object3 == recordAtom2) {
                n = i;
                continue;
            }
            if (object3 != styleTextPropAtom) continue;
            n2 = i;
        }
        if (n == -1) {
            ((RecordContainer)object2).addChildAfter(recordAtom2, textHeaderAtom);
        } else {
            recordArray[n] = recordAtom2;
        }
        if (n2 == -1) {
            ((RecordContainer)object2).addChildAfter(styleTextPropAtom, recordAtom2);
        }
        for (HSLFTextParagraph hSLFTextParagraph : list) {
            if (recordAtom2 == textBytesAtom) {
                hSLFTextParagraph._byteAtom = textBytesAtom;
                hSLFTextParagraph._charAtom = null;
                continue;
            }
            hSLFTextParagraph._byteAtom = null;
            hSLFTextParagraph._charAtom = textCharsAtom;
        }
        styleTextPropAtom.clearStyles();
        Object object4 = null;
        Object var14_18 = null;
        TextPropCollection textPropCollection = null;
        TextPropCollection textPropCollection2 = null;
        for (HSLFTextParagraph hSLFTextParagraph : list) {
            textPropCollection = hSLFTextParagraph.getParagraphStyle();
            textPropCollection.updateTextSize(0);
            if (!textPropCollection.equals(object4)) {
                object4 = styleTextPropAtom.addParagraphTextPropCollection(0);
                ((TextPropCollection)object4).copy(textPropCollection);
            }
            for (HSLFTextRun hSLFTextRun : hSLFTextParagraph.getTextRuns()) {
                textPropCollection2 = hSLFTextRun.getCharacterStyle();
                textPropCollection2.updateTextSize(0);
                if (!textPropCollection2.equals(var14_19)) {
                    TextPropCollection textPropCollection3 = styleTextPropAtom.addCharacterTextPropCollection(0);
                    textPropCollection3.copy(textPropCollection2);
                }
                int n3 = hSLFTextRun.getLength();
                textPropCollection.updateTextSize(textPropCollection.getCharactersCovered() + n3);
                textPropCollection2.updateTextSize(n3);
                ((TextPropCollection)object4).updateTextSize(((TextPropCollection)object4).getCharactersCovered() + n3);
                var14_19.updateTextSize(var14_19.getCharactersCovered() + n3);
            }
        }
        assert (object4 != null && var14_19 != null && textPropCollection != null && textPropCollection2 != null);
        textPropCollection.updateTextSize(textPropCollection.getCharactersCovered() + 1);
        textPropCollection2.updateTextSize(textPropCollection2.getCharactersCovered() + 1);
        ((TextPropCollection)object4).updateTextSize(((TextPropCollection)object4).getCharactersCovered() + 1);
        var14_19.updateTextSize(var14_19.getCharactersCovered() + 1);
        for (Record record : list.get(0).getRecords()) {
            if (!(record instanceof TextSpecInfoAtom)) continue;
            ((TextSpecInfoAtom)record).setParentSize(string.length() + 1);
            break;
        }
        if (object2 instanceof EscherTextboxWrapper) {
            try {
                ((EscherTextboxWrapper)object2).writeOut(null);
            }
            catch (IOException iOException) {
                throw new RuntimeException("failed dummy write", iOException);
            }
        }
        for (HSLFTextParagraph hSLFTextParagraph : list) {
            hSLFTextParagraph._dirty = false;
        }
    }

    protected static HSLFTextRun appendText(List<HSLFTextParagraph> list, String string, boolean bl) {
        string = HSLFTextParagraph.toInternalString(string);
        assert (!list.isEmpty() && !list.get(0).getTextRuns().isEmpty());
        HSLFTextParagraph hSLFTextParagraph = list.get(list.size() - 1);
        HSLFTextRun hSLFTextRun = hSLFTextParagraph.getTextRuns().get(hSLFTextParagraph.getTextRuns().size() - 1);
        boolean bl2 = !bl;
        for (String string2 : string.split("(?<=\r)")) {
            TextPropCollection textPropCollection;
            if (!bl2) {
                textPropCollection = hSLFTextParagraph.getParagraphStyle();
                HSLFTextParagraph hSLFTextParagraph2 = hSLFTextParagraph;
                hSLFTextParagraph = new HSLFTextParagraph(hSLFTextParagraph._headerAtom, hSLFTextParagraph._byteAtom, hSLFTextParagraph._charAtom);
                hSLFTextParagraph.getParagraphStyle().copy(textPropCollection);
                hSLFTextParagraph.setParentShape(hSLFTextParagraph2.getParentShape());
                hSLFTextParagraph.setShapeId(hSLFTextParagraph2.getShapeId());
                hSLFTextParagraph.supplySheet(hSLFTextParagraph2.getSheet());
                list.add(hSLFTextParagraph);
            }
            bl2 = false;
            textPropCollection = hSLFTextRun.getCharacterStyle();
            if (hSLFTextRun.getLength() > 0) {
                hSLFTextRun = new HSLFTextRun(hSLFTextParagraph);
                hSLFTextRun.getCharacterStyle().copy(textPropCollection);
                hSLFTextParagraph.addTextRun(hSLFTextRun);
            }
            hSLFTextRun.setText(string2);
        }
        HSLFTextParagraph.storeText(list);
        return hSLFTextRun;
    }

    public static HSLFTextRun setText(List<HSLFTextParagraph> list, String string) {
        assert (!list.isEmpty() && !list.get(0).getTextRuns().isEmpty());
        Iterator<HSLFTextParagraph> iterator = list.iterator();
        HSLFTextParagraph hSLFTextParagraph = iterator.next();
        assert (hSLFTextParagraph != null);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        Iterator<HSLFTextRun> iterator2 = hSLFTextParagraph.getTextRuns().iterator();
        HSLFTextRun hSLFTextRun = iterator2.next();
        hSLFTextRun.setText("");
        assert (hSLFTextRun != null);
        while (iterator2.hasNext()) {
            iterator2.next();
            iterator2.remove();
        }
        return HSLFTextParagraph.appendText(list, string, false);
    }

    public static String getText(List<HSLFTextParagraph> list) {
        assert (!list.isEmpty());
        String string = HSLFTextParagraph.getRawText(list);
        return HSLFTextParagraph.toExternalString(string, list.get(0).getRunType());
    }

    public static String getRawText(List<HSLFTextParagraph> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (HSLFTextParagraph hSLFTextParagraph : list) {
            for (HSLFTextRun hSLFTextRun : hSLFTextParagraph.getTextRuns()) {
                stringBuilder.append(hSLFTextRun.getRawText());
            }
        }
        return stringBuilder.toString();
    }

    protected static String toInternalString(String string) {
        String string2 = string.replaceAll("\\r?\\n", "\r");
        return string2;
    }

    public static String toExternalString(String string, int n) {
        String string2 = string.replace('\r', '\n');
        switch (n) {
            case -1: 
            case 0: 
            case 6: {
                string2 = string2.replace('\u000b', '\n');
                break;
            }
            default: {
                string2 = string2.replace('\u000b', ' ');
            }
        }
        return string2;
    }

    public static List<List<HSLFTextParagraph>> findTextParagraphs(PPDrawing pPDrawing, HSLFSheet hSLFSheet) {
        ArrayList<List<HSLFTextParagraph>> arrayList = new ArrayList<List<HSLFTextParagraph>>();
        for (EscherTextboxWrapper escherTextboxWrapper : pPDrawing.getTextboxWrappers()) {
            List<HSLFTextParagraph> list = HSLFTextParagraph.findTextParagraphs(escherTextboxWrapper, hSLFSheet);
            if (list == null) continue;
            arrayList.add(list);
        }
        return arrayList;
    }

    protected static List<HSLFTextParagraph> findTextParagraphs(EscherTextboxWrapper escherTextboxWrapper, HSLFSheet hSLFSheet) {
        List<HSLFTextParagraph> list3;
        Object object;
        RecordContainer.handleParentAwareRecords(escherTextboxWrapper);
        int n = escherTextboxWrapper.getShapeId();
        ArrayList arrayList = null;
        OutlineTextRefAtom outlineTextRefAtom = (OutlineTextRefAtom)escherTextboxWrapper.findFirstOfType(RecordTypes.OutlineTextRefAtom.typeID);
        if (outlineTextRefAtom != null) {
            if (hSLFSheet == null) {
                throw new RuntimeException("Outline atom reference can't be solved without a sheet record");
            }
            object = hSLFSheet.getTextParagraphs();
            assert (object != null);
            int n2 = outlineTextRefAtom.getTextIndex();
            list3 = object.iterator();
            while (list3.hasNext()) {
                List list2 = (List)list3.next();
                if (list2.isEmpty()) continue;
                int n3 = ((HSLFTextParagraph)list2.get(0)).getIndex();
                if (n3 > n2) break;
                if (n3 != n2) continue;
                if (arrayList == null) {
                    arrayList = list2;
                    continue;
                }
                arrayList = new ArrayList(arrayList);
                arrayList.addAll(list2);
            }
            if (arrayList == null || arrayList.isEmpty()) {
                logger.log(5, new Object[]{"text run not found for OutlineTextRefAtom.TextIndex=" + n2});
            }
        } else {
            if (hSLFSheet != null) {
                object = hSLFSheet.getTextParagraphs();
                assert (object != null);
                Iterator<List<HSLFTextParagraph>> iterator = object.iterator();
                while (iterator.hasNext()) {
                    list3 = iterator.next();
                    if (list3.isEmpty() || ((HSLFTextParagraph)list3.get((int)0))._headerAtom.getParentRecord() != escherTextboxWrapper) continue;
                    arrayList = list3;
                    break;
                }
            }
            if (arrayList == null) {
                object = HSLFTextParagraph.findTextParagraphs(escherTextboxWrapper.getChildRecords());
                switch (object.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        arrayList = (List)object.get(0);
                        break;
                    }
                    default: {
                        throw new RuntimeException("TextBox contains more than one list of paragraphs.");
                    }
                }
            }
        }
        if (arrayList != null) {
            object = escherTextboxWrapper.getStyleTextProp9Atom();
            for (List<HSLFTextParagraph> list3 : arrayList) {
                ((HSLFTextParagraph)((Object)list3)).setShapeId(n);
                ((HSLFTextParagraph)((Object)list3)).setStyleTextProp9Atom((StyleTextProp9Atom)object);
            }
        }
        return arrayList;
    }

    protected static List<List<HSLFTextParagraph>> findTextParagraphs(Record[] recordArray) {
        ArrayList<List<HSLFTextParagraph>> arrayList = new ArrayList<List<HSLFTextParagraph>>();
        int[] nArray = new int[]{0};
        int n = 0;
        while (nArray[0] < recordArray.length) {
            TextHeaderAtom textHeaderAtom = null;
            TextBytesAtom textBytesAtom = null;
            TextCharsAtom textCharsAtom = null;
            TextRulerAtom textRulerAtom = null;
            MasterTextPropAtom masterTextPropAtom = null;
            for (Record record : HSLFTextParagraph.getRecords(recordArray, nArray, null)) {
                long l = record.getRecordType();
                if ((long)RecordTypes.TextHeaderAtom.typeID == l) {
                    textHeaderAtom = (TextHeaderAtom)record;
                    continue;
                }
                if ((long)RecordTypes.TextBytesAtom.typeID == l) {
                    textBytesAtom = (TextBytesAtom)record;
                    continue;
                }
                if ((long)RecordTypes.TextCharsAtom.typeID == l) {
                    textCharsAtom = (TextCharsAtom)record;
                    continue;
                }
                if ((long)RecordTypes.TextRulerAtom.typeID == l) {
                    textRulerAtom = (TextRulerAtom)record;
                    continue;
                }
                if ((long)RecordTypes.MasterTextPropAtom.typeID != l) continue;
                masterTextPropAtom = (MasterTextPropAtom)record;
            }
            if (textHeaderAtom == null) break;
            if (textHeaderAtom.getParentRecord() instanceof SlideListWithText) {
                textHeaderAtom.setIndex(n);
            }
            if (textBytesAtom == null && textCharsAtom == null) {
                textBytesAtom = new TextBytesAtom();
                logger.log(3, new Object[]{"bytes nor chars atom doesn't exist. Creating dummy record for later saving."});
            }
            String string = textCharsAtom != null ? textCharsAtom.getText() : textBytesAtom.getText();
            StyleTextPropAtom styleTextPropAtom = HSLFTextParagraph.findStyleAtomPresent(textHeaderAtom, string.length());
            ArrayList<HSLFTextParagraph> arrayList2 = new ArrayList<HSLFTextParagraph>();
            arrayList.add(arrayList2);
            for (String string2 : string.split("(?<=\r)")) {
                HSLFTextParagraph hSLFTextParagraph = new HSLFTextParagraph(textHeaderAtom, textBytesAtom, textCharsAtom);
                arrayList2.add(hSLFTextParagraph);
                hSLFTextParagraph._ruler = textRulerAtom;
                hSLFTextParagraph.getParagraphStyle().updateTextSize(string2.length());
                HSLFTextRun hSLFTextRun = new HSLFTextRun(hSLFTextParagraph);
                hSLFTextParagraph.addTextRun(hSLFTextRun);
                hSLFTextRun.setText(string2);
            }
            HSLFTextParagraph.applyCharacterStyles(arrayList2, styleTextPropAtom.getCharacterStyles());
            HSLFTextParagraph.applyParagraphStyles(arrayList2, styleTextPropAtom.getParagraphStyles());
            if (masterTextPropAtom != null) {
                HSLFTextParagraph.applyParagraphIndents(arrayList2, masterTextPropAtom.getIndents());
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            logger.log(1, new Object[]{"No text records found."});
        }
        return arrayList;
    }

    protected static void applyCharacterStyles(List<HSLFTextParagraph> list, List<TextPropCollection> list2) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < list2.size(); ++i) {
            TextPropCollection textPropCollection = list2.get(i);
            int n3 = 0;
            int n4 = textPropCollection.getCharactersCovered();
            while (n3 < n4) {
                HSLFTextRun hSLFTextRun;
                Object object;
                HSLFTextParagraph hSLFTextParagraph = list.get(n);
                List<HSLFTextRun> list3 = hSLFTextParagraph.getTextRuns();
                HSLFTextRun hSLFTextRun2 = list3.get(n2);
                int n5 = hSLFTextRun2.getLength();
                if (n3 + n5 <= n4) {
                    n3 += n5;
                } else {
                    object = hSLFTextRun2.getRawText();
                    hSLFTextRun2.setText(((String)object).substring(0, n4 - n3));
                    hSLFTextRun = new HSLFTextRun(hSLFTextParagraph);
                    hSLFTextRun.setText(((String)object).substring(n4 - n3));
                    list3.add(n2 + 1, hSLFTextRun);
                    n3 += n4 - n3;
                }
                object = new TextPropCollection(0, TextPropCollection.TextPropType.character);
                ((TextPropCollection)object).copy(textPropCollection);
                hSLFTextRun2.setCharacterStyle((TextPropCollection)object);
                n5 = hSLFTextRun2.getLength();
                if (n == list.size() - 1 && n2 == list3.size() - 1) {
                    if (i < list2.size() - 1) {
                        hSLFTextRun = new HSLFTextRun(hSLFTextParagraph);
                        hSLFTextRun.setText("");
                        list3.add(hSLFTextRun);
                        ++n3;
                    } else {
                        ++n5;
                        ++n3;
                    }
                }
                ((TextPropCollection)object).updateTextSize(n5);
                if (++n2 != list3.size()) continue;
                ++n;
                n2 = 0;
            }
        }
    }

    protected static void applyParagraphStyles(List<HSLFTextParagraph> list, List<TextPropCollection> list2) {
        int n = 0;
        for (TextPropCollection textPropCollection : list2) {
            int n2 = 0;
            int n3 = textPropCollection.getCharactersCovered();
            while (n2 < n3) {
                if (n >= list.size() || n2 >= n3 - 1) {
                    return;
                }
                HSLFTextParagraph hSLFTextParagraph = list.get(n);
                TextPropCollection textPropCollection2 = new TextPropCollection(0, TextPropCollection.TextPropType.paragraph);
                textPropCollection2.copy(textPropCollection);
                hSLFTextParagraph.setParagraphStyle(textPropCollection2);
                int n4 = 0;
                for (HSLFTextRun hSLFTextRun : hSLFTextParagraph.getTextRuns()) {
                    n4 += hSLFTextRun.getLength();
                }
                if (n == list.size() - 1) {
                    ++n4;
                }
                textPropCollection2.updateTextSize(n4);
                n2 += n4;
                ++n;
            }
        }
    }

    protected static void applyParagraphIndents(List<HSLFTextParagraph> list, List<IndentProp> list2) {
        int n = 0;
        for (IndentProp indentProp : list2) {
            int n2 = 0;
            int n3 = indentProp.getCharactersCovered();
            while (n2 < n3) {
                HSLFTextParagraph hSLFTextParagraph = list.get(n);
                int n4 = 0;
                for (HSLFTextRun hSLFTextRun : hSLFTextParagraph.getTextRuns()) {
                    n4 += hSLFTextRun.getLength();
                }
                hSLFTextParagraph.setIndentLevel(indentProp.getIndentLevel());
                n2 += n4 + 1;
                ++n;
            }
        }
    }

    protected static List<HSLFTextParagraph> createEmptyParagraph() {
        EscherTextboxWrapper escherTextboxWrapper = new EscherTextboxWrapper();
        return HSLFTextParagraph.createEmptyParagraph(escherTextboxWrapper);
    }

    protected static List<HSLFTextParagraph> createEmptyParagraph(EscherTextboxWrapper escherTextboxWrapper) {
        TextHeaderAtom textHeaderAtom = new TextHeaderAtom();
        textHeaderAtom.setParentRecord(escherTextboxWrapper);
        escherTextboxWrapper.appendChildRecord(textHeaderAtom);
        TextBytesAtom textBytesAtom = new TextBytesAtom();
        textBytesAtom.setText("".getBytes(LocaleUtil.CHARSET_1252));
        escherTextboxWrapper.appendChildRecord(textBytesAtom);
        StyleTextPropAtom styleTextPropAtom = new StyleTextPropAtom(1);
        TextPropCollection textPropCollection = styleTextPropAtom.addParagraphTextPropCollection(1);
        TextPropCollection textPropCollection2 = styleTextPropAtom.addCharacterTextPropCollection(1);
        escherTextboxWrapper.appendChildRecord(styleTextPropAtom);
        HSLFTextParagraph hSLFTextParagraph = new HSLFTextParagraph(textHeaderAtom, textBytesAtom, null);
        hSLFTextParagraph.setParagraphStyle(textPropCollection);
        HSLFTextRun hSLFTextRun = new HSLFTextRun(hSLFTextParagraph);
        hSLFTextRun.setCharacterStyle(textPropCollection2);
        hSLFTextRun.setText("");
        hSLFTextParagraph.addTextRun(hSLFTextRun);
        return Arrays.asList(hSLFTextParagraph);
    }

    public EscherTextboxWrapper getTextboxWrapper() {
        return (EscherTextboxWrapper)this._headerAtom.getParentRecord();
    }

    protected static Color getColorFromColorIndexStruct(int n, HSLFSheet hSLFSheet) {
        Color color;
        int n2 = n >>> 24;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (hSLFSheet == null) {
                    return null;
                }
                ColorSchemeAtom colorSchemeAtom = hSLFSheet.getColorScheme();
                color = new Color(colorSchemeAtom.getColor(n2), true);
                break;
            }
            case 254: {
                color = new Color(n, true);
                break;
            }
            default: {
                return null;
            }
        }
        return new Color(color.getBlue(), color.getGreen(), color.getRed());
    }

    public void setParagraphTextPropVal(String string, Integer n) {
        HSLFTextParagraph.setPropVal(this._paragraphStyle, string, n);
        this.setDirty();
    }

    public void setDirty() {
        this._dirty = true;
    }

    public boolean isDirty() {
        return this._dirty;
    }
}

