/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.AbstractEscherOptRecord;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.hslf.usermodel.HSLFLine;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextBox;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.sl.usermodel.TableCell;
import java.awt.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSLFTableCell
extends HSLFTextBox
implements TableCell<HSLFShape, HSLFTextParagraph> {
    protected static final int DEFAULT_WIDTH = 100;
    protected static final int DEFAULT_HEIGHT = 40;
    private HSLFLine borderLeft;
    private HSLFLine borderRight;
    private HSLFLine borderTop;
    private HSLFLine borderBottom;

    protected HSLFTableCell(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(escherContainerRecord, shapeContainer);
    }

    public HSLFTableCell(ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(shapeContainer);
        this.setShapeType(ShapeType.RECT);
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean bl) {
        this._escherContainer = super.createSpContainer(bl);
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        HSLFTableCell.setEscherProperty(abstractEscherOptRecord, (short)128, 0);
        HSLFTableCell.setEscherProperty(abstractEscherOptRecord, (short)191, 131072);
        HSLFTableCell.setEscherProperty(abstractEscherOptRecord, (short)447, 0x150001);
        HSLFTableCell.setEscherProperty(abstractEscherOptRecord, (short)575, 131072);
        HSLFTableCell.setEscherProperty(abstractEscherOptRecord, (short)127, 262144);
        return this._escherContainer;
    }

    protected void anchorBorder(int n, HSLFLine hSLFLine) {
        Rectangle rectangle = this.getAnchor();
        Rectangle rectangle2 = new Rectangle();
        switch (n) {
            case 1: {
                rectangle2.x = rectangle.x;
                rectangle2.y = rectangle.y;
                rectangle2.width = rectangle.width;
                rectangle2.height = 0;
                break;
            }
            case 2: {
                rectangle2.x = rectangle.x + rectangle.width;
                rectangle2.y = rectangle.y;
                rectangle2.width = 0;
                rectangle2.height = rectangle.height;
                break;
            }
            case 3: {
                rectangle2.x = rectangle.x;
                rectangle2.y = rectangle.y + rectangle.height;
                rectangle2.width = rectangle.width;
                rectangle2.height = 0;
                break;
            }
            case 4: {
                rectangle2.x = rectangle.x;
                rectangle2.y = rectangle.y;
                rectangle2.width = 0;
                rectangle2.height = rectangle.height;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown border type: " + n);
            }
        }
        hSLFLine.setAnchor(rectangle2);
    }

    public HSLFLine getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(HSLFLine hSLFLine) {
        if (hSLFLine != null) {
            this.anchorBorder(4, hSLFLine);
        }
        this.borderLeft = hSLFLine;
    }

    public HSLFLine getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(HSLFLine hSLFLine) {
        if (hSLFLine != null) {
            this.anchorBorder(2, hSLFLine);
        }
        this.borderRight = hSLFLine;
    }

    public HSLFLine getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(HSLFLine hSLFLine) {
        if (hSLFLine != null) {
            this.anchorBorder(1, hSLFLine);
        }
        this.borderTop = hSLFLine;
    }

    public HSLFLine getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(HSLFLine hSLFLine) {
        if (hSLFLine != null) {
            this.anchorBorder(3, hSLFLine);
        }
        this.borderBottom = hSLFLine;
    }

    @Override
    public void setAnchor(Rectangle rectangle) {
        super.setAnchor(rectangle);
        if (this.borderTop != null) {
            this.anchorBorder(1, this.borderTop);
        }
        if (this.borderRight != null) {
            this.anchorBorder(2, this.borderRight);
        }
        if (this.borderBottom != null) {
            this.anchorBorder(3, this.borderBottom);
        }
        if (this.borderLeft != null) {
            this.anchorBorder(4, this.borderLeft);
        }
    }
}

